<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceValidationServiceResponse StructType
 * @subpackage Structs
 */
class InsuranceValidationServiceResponse extends AbstractStructBase
{
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $State;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceId;
    /**
     * Constructor method for InsuranceValidationServiceResponse
     * @uses InsuranceValidationServiceResponse::setState()
     * @uses InsuranceValidationServiceResponse::setReferenceId()
     * @param int $state
     * @param string $referenceId
     */
    public function __construct($state = null, $referenceId = null)
    {
        $this
            ->setState($state)
            ->setReferenceId($referenceId);
    }
    /**
     * Get State value
     * @return int
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param int $state
     * @return \StructType\InsuranceValidationServiceResponse
     */
    public function setState($state = null)
    {
        // validation for constraint: int
        if (!is_null($state) && !(is_int($state) || ctype_digit($state))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param string $referenceId
     * @return \StructType\InsuranceValidationServiceResponse
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsuranceValidationServiceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
