<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Registry ServiceType
 * @subpackage Services
 */
class Registry extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named registry
     * Meta information extracted from the WSDL
     * - documentation: Registrierung am SIT-Pay SEPA System
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Registry $parameters
     * @return \StructType\RegistryResponse|bool
     */
    public function registry(\StructType\Registry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->registry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RegistryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
