<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insurance ServiceType
 * @subpackage Services
 */
class Insurance extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named insuranceValidation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsuranceValidation $parameters
     * @return \StructType\InsuranceValidationResponse|bool
     */
    public function insuranceValidation(\StructType\InsuranceValidation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->insuranceValidation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InsuranceValidationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
