<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Confirm ServiceType
 * @subpackage Services
 */
class Confirm extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named confirmMandate
     * Meta information extracted from the WSDL
     * - documentation: Registrierung der Kundendaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConfirmMandate $parameters
     * @return \StructType\ConfirmMandateResponse|bool
     */
    public function confirmMandate(\StructType\ConfirmMandate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->confirmMandate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named confirmAccessCode
     * Meta information extracted from the WSDL
     * - documentation: Bestätigung des Freischaltcodes der Gutschrift
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConfirmAccessCode $parameters
     * @return \StructType\ConfirmAccessCodeResponse|bool
     */
    public function confirmAccessCode(\StructType\ConfirmAccessCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->confirmAccessCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConfirmAccessCodeResponse|\StructType\ConfirmMandateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
