<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'registry' => '\\StructType\\Registry',
            'registryResponse' => '\\StructType\\RegistryResponse',
            'checkAddressData' => '\\StructType\\CheckAddressData',
            'checkAddressDataResponse' => '\\StructType\\CheckAddressDataResponse',
            'checkCustomerData' => '\\StructType\\CheckCustomerData',
            'checkCustomerDataResponse' => '\\StructType\\CheckCustomerDataResponse',
            'getBic4Iban' => '\\StructType\\GetBic4Iban',
            'getBic4IbanResponse' => '\\StructType\\GetBic4IbanResponse',
            'insuranceValidation' => '\\StructType\\InsuranceValidation',
            'insuranceValidationResponse' => '\\StructType\\InsuranceValidationResponse',
            'InsuranceValidationServiceResponse' => '\\StructType\\InsuranceValidationServiceResponse',
            'checkBankData' => '\\StructType\\CheckBankData',
            'checkBankDataResponse' => '\\StructType\\CheckBankDataResponse',
            'checkCreditRating' => '\\StructType\\CheckCreditRating',
            'checkCreditRatingResponse' => '\\StructType\\CheckCreditRatingResponse',
            'insertMandate' => '\\StructType\\InsertMandate',
            'insertMandateResponse' => '\\StructType\\InsertMandateResponse',
            'verifyMandate' => '\\StructType\\VerifyMandate',
            'verifyMandateResponse' => '\\StructType\\VerifyMandateResponse',
            'confirmMandate' => '\\StructType\\ConfirmMandate',
            'confirmMandateResponse' => '\\StructType\\ConfirmMandateResponse',
            'confirmAccessCode' => '\\StructType\\ConfirmAccessCode',
            'confirmAccessCodeResponse' => '\\StructType\\ConfirmAccessCodeResponse',
            'insertPayment' => '\\StructType\\InsertPayment',
            'insertPaymentResponse' => '\\StructType\\InsertPaymentResponse',
            'cancelPayment' => '\\StructType\\CancelPayment',
            'cancelPaymentResponse' => '\\StructType\\CancelPaymentResponse',
            'retrieveCustomerData' => '\\StructType\\RetrieveCustomerData',
            'retrieveCustomerDataResponse' => '\\StructType\\RetrieveCustomerDataResponse',
            'updateCustomerData' => '\\StructType\\UpdateCustomerData',
            'updateCustomerDataResponse' => '\\StructType\\UpdateCustomerDataResponse',
            'blockCustomerData' => '\\StructType\\BlockCustomerData',
            'blockCustomerDataResponse' => '\\StructType\\BlockCustomerDataResponse',
            'deleteCustomerData' => '\\StructType\\DeleteCustomerData',
            'deleteCustomerDataResponse' => '\\StructType\\DeleteCustomerDataResponse',
        );
    }
}
