<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportTransferOrders StructType
 * Meta information extracted from the WSDL
 * - type: tns:ReportTransferOrders
 * @subpackage Structs
 */
class ReportTransferOrders extends AbstractStructBase
{
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The SupplierRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SupplierRef;
    /**
     * Constructor method for ReportTransferOrders
     * @uses ReportTransferOrders::setInvoiceDate()
     * @uses ReportTransferOrders::setSupplierRef()
     * @param string $invoiceDate
     * @param string $supplierRef
     */
    public function __construct($invoiceDate = null, $supplierRef = null)
    {
        $this
            ->setInvoiceDate($invoiceDate)
            ->setSupplierRef($supplierRef);
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\ReportTransferOrders
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get SupplierRef value
     * @return string|null
     */
    public function getSupplierRef()
    {
        return $this->SupplierRef;
    }
    /**
     * Set SupplierRef value
     * @param string $supplierRef
     * @return \StructType\ReportTransferOrders
     */
    public function setSupplierRef($supplierRef = null)
    {
        // validation for constraint: string
        if (!is_null($supplierRef) && !is_string($supplierRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierRef, true), gettype($supplierRef)), __LINE__);
        }
        $this->SupplierRef = $supplierRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportTransferOrders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
