<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Line StructType
 * @subpackage Structs
 */
class Line extends AbstractStructBase
{
    /**
     * The SupplierReference
     * @var string
     */
    public $SupplierReference;
    /**
     * The ProductCode
     * @var string
     */
    public $ProductCode;
    /**
     * The ProductDesignation
     * @var string
     */
    public $ProductDesignation;
    /**
     * The DispensedQty
     * @var int
     */
    public $DispensedQty;
    /**
     * The BonusQty
     * @var int
     */
    public $BonusQty;
    /**
     * The Discount
     * @var float
     */
    public $Discount;
    /**
     * The InvoiceDate
     * @var string
     */
    public $InvoiceDate;
    /**
     * The Invoice
     * @var string
     */
    public $Invoice;
    /**
     * The SupplierLineRef
     * @var int
     */
    public $SupplierLineRef;
    /**
     * The ClienteCode
     * @var string
     */
    public $ClienteCode;
    /**
     * The ClienteName
     * @var string
     */
    public $ClienteName;
    /**
     * The ClienteGLN
     * @var string
     */
    public $ClienteGLN;
    /**
     * Constructor method for Line
     * @uses Line::setSupplierReference()
     * @uses Line::setProductCode()
     * @uses Line::setProductDesignation()
     * @uses Line::setDispensedQty()
     * @uses Line::setBonusQty()
     * @uses Line::setDiscount()
     * @uses Line::setInvoiceDate()
     * @uses Line::setInvoice()
     * @uses Line::setSupplierLineRef()
     * @uses Line::setClienteCode()
     * @uses Line::setClienteName()
     * @uses Line::setClienteGLN()
     * @param string $supplierReference
     * @param string $productCode
     * @param string $productDesignation
     * @param int $dispensedQty
     * @param int $bonusQty
     * @param float $discount
     * @param string $invoiceDate
     * @param string $invoice
     * @param int $supplierLineRef
     * @param string $clienteCode
     * @param string $clienteName
     * @param string $clienteGLN
     */
    public function __construct($supplierReference = null, $productCode = null, $productDesignation = null, $dispensedQty = null, $bonusQty = null, $discount = null, $invoiceDate = null, $invoice = null, $supplierLineRef = null, $clienteCode = null, $clienteName = null, $clienteGLN = null)
    {
        $this
            ->setSupplierReference($supplierReference)
            ->setProductCode($productCode)
            ->setProductDesignation($productDesignation)
            ->setDispensedQty($dispensedQty)
            ->setBonusQty($bonusQty)
            ->setDiscount($discount)
            ->setInvoiceDate($invoiceDate)
            ->setInvoice($invoice)
            ->setSupplierLineRef($supplierLineRef)
            ->setClienteCode($clienteCode)
            ->setClienteName($clienteName)
            ->setClienteGLN($clienteGLN);
    }
    /**
     * Get SupplierReference value
     * @return string|null
     */
    public function getSupplierReference()
    {
        return $this->SupplierReference;
    }
    /**
     * Set SupplierReference value
     * @param string $supplierReference
     * @return \StructType\Line
     */
    public function setSupplierReference($supplierReference = null)
    {
        // validation for constraint: string
        if (!is_null($supplierReference) && !is_string($supplierReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierReference, true), gettype($supplierReference)), __LINE__);
        }
        $this->SupplierReference = $supplierReference;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\Line
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get ProductDesignation value
     * @return string|null
     */
    public function getProductDesignation()
    {
        return $this->ProductDesignation;
    }
    /**
     * Set ProductDesignation value
     * @param string $productDesignation
     * @return \StructType\Line
     */
    public function setProductDesignation($productDesignation = null)
    {
        // validation for constraint: string
        if (!is_null($productDesignation) && !is_string($productDesignation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productDesignation, true), gettype($productDesignation)), __LINE__);
        }
        $this->ProductDesignation = $productDesignation;
        return $this;
    }
    /**
     * Get DispensedQty value
     * @return int|null
     */
    public function getDispensedQty()
    {
        return $this->DispensedQty;
    }
    /**
     * Set DispensedQty value
     * @param int $dispensedQty
     * @return \StructType\Line
     */
    public function setDispensedQty($dispensedQty = null)
    {
        // validation for constraint: int
        if (!is_null($dispensedQty) && !(is_int($dispensedQty) || ctype_digit($dispensedQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dispensedQty, true), gettype($dispensedQty)), __LINE__);
        }
        $this->DispensedQty = $dispensedQty;
        return $this;
    }
    /**
     * Get BonusQty value
     * @return int|null
     */
    public function getBonusQty()
    {
        return $this->BonusQty;
    }
    /**
     * Set BonusQty value
     * @param int $bonusQty
     * @return \StructType\Line
     */
    public function setBonusQty($bonusQty = null)
    {
        // validation for constraint: int
        if (!is_null($bonusQty) && !(is_int($bonusQty) || ctype_digit($bonusQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusQty, true), gettype($bonusQty)), __LINE__);
        }
        $this->BonusQty = $bonusQty;
        return $this;
    }
    /**
     * Get Discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \StructType\Line
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\Line
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get Invoice value
     * @return string|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param string $invoice
     * @return \StructType\Line
     */
    public function setInvoice($invoice = null)
    {
        // validation for constraint: string
        if (!is_null($invoice) && !is_string($invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice, true), gettype($invoice)), __LINE__);
        }
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get SupplierLineRef value
     * @return int|null
     */
    public function getSupplierLineRef()
    {
        return $this->SupplierLineRef;
    }
    /**
     * Set SupplierLineRef value
     * @param int $supplierLineRef
     * @return \StructType\Line
     */
    public function setSupplierLineRef($supplierLineRef = null)
    {
        // validation for constraint: int
        if (!is_null($supplierLineRef) && !(is_int($supplierLineRef) || ctype_digit($supplierLineRef))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supplierLineRef, true), gettype($supplierLineRef)), __LINE__);
        }
        $this->SupplierLineRef = $supplierLineRef;
        return $this;
    }
    /**
     * Get ClienteCode value
     * @return string|null
     */
    public function getClienteCode()
    {
        return $this->ClienteCode;
    }
    /**
     * Set ClienteCode value
     * @param string $clienteCode
     * @return \StructType\Line
     */
    public function setClienteCode($clienteCode = null)
    {
        // validation for constraint: string
        if (!is_null($clienteCode) && !is_string($clienteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clienteCode, true), gettype($clienteCode)), __LINE__);
        }
        $this->ClienteCode = $clienteCode;
        return $this;
    }
    /**
     * Get ClienteName value
     * @return string|null
     */
    public function getClienteName()
    {
        return $this->ClienteName;
    }
    /**
     * Set ClienteName value
     * @param string $clienteName
     * @return \StructType\Line
     */
    public function setClienteName($clienteName = null)
    {
        // validation for constraint: string
        if (!is_null($clienteName) && !is_string($clienteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clienteName, true), gettype($clienteName)), __LINE__);
        }
        $this->ClienteName = $clienteName;
        return $this;
    }
    /**
     * Get ClienteGLN value
     * @return string|null
     */
    public function getClienteGLN()
    {
        return $this->ClienteGLN;
    }
    /**
     * Set ClienteGLN value
     * @param string $clienteGLN
     * @return \StructType\Line
     */
    public function setClienteGLN($clienteGLN = null)
    {
        // validation for constraint: string
        if (!is_null($clienteGLN) && !is_string($clienteGLN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clienteGLN, true), gettype($clienteGLN)), __LINE__);
        }
        $this->ClienteGLN = $clienteGLN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Line
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
