<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferOrder StructType
 * Meta information extracted from the WSDL
 * - final: extension restriction
 * @subpackage Structs
 */
class TransferOrder extends AbstractStructBase
{
    /**
     * The Line
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Line[]
     */
    public $Line;
    /**
     * The Status
     * @var \StructType\Status
     */
    public $Status;
    /**
     * Constructor method for TransferOrder
     * @uses TransferOrder::setLine()
     * @uses TransferOrder::setStatus()
     * @param \StructType\Line[] $line
     * @param \StructType\Status $status
     */
    public function __construct(array $line = array(), \StructType\Status $status = null)
    {
        $this
            ->setLine($line)
            ->setStatus($status);
    }
    /**
     * Get Line value
     * @return \StructType\Line[]|null
     */
    public function getLine()
    {
        return $this->Line;
    }
    /**
     * This method is responsible for validating the values passed to the setLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineForArrayConstraintsFromSetLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transferOrderLineItem) {
            // validation for constraint: itemType
            if (!$transferOrderLineItem instanceof \StructType\Line) {
                $invalidValues[] = is_object($transferOrderLineItem) ? get_class($transferOrderLineItem) : sprintf('%s(%s)', gettype($transferOrderLineItem), var_export($transferOrderLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Line property can only contain items of type \StructType\Line, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Line[] $line
     * @return \StructType\TransferOrder
     */
    public function setLine(array $line = array())
    {
        // validation for constraint: array
        if ('' !== ($lineArrayErrorMessage = self::validateLineForArrayConstraintsFromSetLine($line))) {
            throw new \InvalidArgumentException($lineArrayErrorMessage, __LINE__);
        }
        $this->Line = $line;
        return $this;
    }
    /**
     * Add item to Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Line $item
     * @return \StructType\TransferOrder
     */
    public function addToLine(\StructType\Line $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Line) {
            throw new \InvalidArgumentException(sprintf('The Line property can only contain items of type \StructType\Line, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Line[] = $item;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Status $status
     * @return \StructType\TransferOrder
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransferOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
