<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadSurvey StructType
 * @subpackage Structs
 */
class UploadSurvey extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pHubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubSurveyID;
    /**
     * The pCompletedLongitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $pCompletedLongitude;
    /**
     * The pCompletedLatitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $pCompletedLatitude;
    /**
     * The pCompletedAccuracy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $pCompletedAccuracy;
    /**
     * The pUploadedLongitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $pUploadedLongitude;
    /**
     * The pUploadedLatitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $pUploadedLatitude;
    /**
     * The pUploadedAccuracy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $pUploadedAccuracy;
    /**
     * The pCompletedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pCompletedDateTime;
    /**
     * The pDrawingPhotoCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pDrawingPhotoCount;
    /**
     * The pRiskPhotoCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pRiskPhotoCount;
    /**
     * The pHubSurveyorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubSurveyorID;
    /**
     * The pNoAccessAreas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pNoAccessAreas;
    /**
     * The pAreasIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pAreasIncluded;
    /**
     * Constructor method for UploadSurvey
     * @uses UploadSurvey::setPCompanyID()
     * @uses UploadSurvey::setPUserID()
     * @uses UploadSurvey::setPAuthKey()
     * @uses UploadSurvey::setPHubSurveyID()
     * @uses UploadSurvey::setPCompletedLongitude()
     * @uses UploadSurvey::setPCompletedLatitude()
     * @uses UploadSurvey::setPCompletedAccuracy()
     * @uses UploadSurvey::setPUploadedLongitude()
     * @uses UploadSurvey::setPUploadedLatitude()
     * @uses UploadSurvey::setPUploadedAccuracy()
     * @uses UploadSurvey::setPCompletedDateTime()
     * @uses UploadSurvey::setPDrawingPhotoCount()
     * @uses UploadSurvey::setPRiskPhotoCount()
     * @uses UploadSurvey::setPHubSurveyorID()
     * @uses UploadSurvey::setPNoAccessAreas()
     * @uses UploadSurvey::setPAreasIncluded()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pHubSurveyID
     * @param float $pCompletedLongitude
     * @param float $pCompletedLatitude
     * @param float $pCompletedAccuracy
     * @param float $pUploadedLongitude
     * @param float $pUploadedLatitude
     * @param float $pUploadedAccuracy
     * @param string $pCompletedDateTime
     * @param int $pDrawingPhotoCount
     * @param int $pRiskPhotoCount
     * @param int $pHubSurveyorID
     * @param string $pNoAccessAreas
     * @param string $pAreasIncluded
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pHubSurveyID = null, $pCompletedLongitude = null, $pCompletedLatitude = null, $pCompletedAccuracy = null, $pUploadedLongitude = null, $pUploadedLatitude = null, $pUploadedAccuracy = null, $pCompletedDateTime = null, $pDrawingPhotoCount = null, $pRiskPhotoCount = null, $pHubSurveyorID = null, $pNoAccessAreas = null, $pAreasIncluded = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPHubSurveyID($pHubSurveyID)
            ->setPCompletedLongitude($pCompletedLongitude)
            ->setPCompletedLatitude($pCompletedLatitude)
            ->setPCompletedAccuracy($pCompletedAccuracy)
            ->setPUploadedLongitude($pUploadedLongitude)
            ->setPUploadedLatitude($pUploadedLatitude)
            ->setPUploadedAccuracy($pUploadedAccuracy)
            ->setPCompletedDateTime($pCompletedDateTime)
            ->setPDrawingPhotoCount($pDrawingPhotoCount)
            ->setPRiskPhotoCount($pRiskPhotoCount)
            ->setPHubSurveyorID($pHubSurveyorID)
            ->setPNoAccessAreas($pNoAccessAreas)
            ->setPAreasIncluded($pAreasIncluded);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadSurvey
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadSurvey
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadSurvey
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pHubSurveyID value
     * @return int
     */
    public function getPHubSurveyID()
    {
        return $this->pHubSurveyID;
    }
    /**
     * Set pHubSurveyID value
     * @param int $pHubSurveyID
     * @return \StructType\UploadSurvey
     */
    public function setPHubSurveyID($pHubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubSurveyID) && !(is_int($pHubSurveyID) || ctype_digit($pHubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubSurveyID, true), gettype($pHubSurveyID)), __LINE__);
        }
        $this->pHubSurveyID = $pHubSurveyID;
        return $this;
    }
    /**
     * Get pCompletedLongitude value
     * @return float
     */
    public function getPCompletedLongitude()
    {
        return $this->pCompletedLongitude;
    }
    /**
     * Set pCompletedLongitude value
     * @param float $pCompletedLongitude
     * @return \StructType\UploadSurvey
     */
    public function setPCompletedLongitude($pCompletedLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($pCompletedLongitude) && !(is_float($pCompletedLongitude) || is_numeric($pCompletedLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pCompletedLongitude, true), gettype($pCompletedLongitude)), __LINE__);
        }
        $this->pCompletedLongitude = $pCompletedLongitude;
        return $this;
    }
    /**
     * Get pCompletedLatitude value
     * @return float
     */
    public function getPCompletedLatitude()
    {
        return $this->pCompletedLatitude;
    }
    /**
     * Set pCompletedLatitude value
     * @param float $pCompletedLatitude
     * @return \StructType\UploadSurvey
     */
    public function setPCompletedLatitude($pCompletedLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($pCompletedLatitude) && !(is_float($pCompletedLatitude) || is_numeric($pCompletedLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pCompletedLatitude, true), gettype($pCompletedLatitude)), __LINE__);
        }
        $this->pCompletedLatitude = $pCompletedLatitude;
        return $this;
    }
    /**
     * Get pCompletedAccuracy value
     * @return float
     */
    public function getPCompletedAccuracy()
    {
        return $this->pCompletedAccuracy;
    }
    /**
     * Set pCompletedAccuracy value
     * @param float $pCompletedAccuracy
     * @return \StructType\UploadSurvey
     */
    public function setPCompletedAccuracy($pCompletedAccuracy = null)
    {
        // validation for constraint: float
        if (!is_null($pCompletedAccuracy) && !(is_float($pCompletedAccuracy) || is_numeric($pCompletedAccuracy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pCompletedAccuracy, true), gettype($pCompletedAccuracy)), __LINE__);
        }
        $this->pCompletedAccuracy = $pCompletedAccuracy;
        return $this;
    }
    /**
     * Get pUploadedLongitude value
     * @return float
     */
    public function getPUploadedLongitude()
    {
        return $this->pUploadedLongitude;
    }
    /**
     * Set pUploadedLongitude value
     * @param float $pUploadedLongitude
     * @return \StructType\UploadSurvey
     */
    public function setPUploadedLongitude($pUploadedLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($pUploadedLongitude) && !(is_float($pUploadedLongitude) || is_numeric($pUploadedLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pUploadedLongitude, true), gettype($pUploadedLongitude)), __LINE__);
        }
        $this->pUploadedLongitude = $pUploadedLongitude;
        return $this;
    }
    /**
     * Get pUploadedLatitude value
     * @return float
     */
    public function getPUploadedLatitude()
    {
        return $this->pUploadedLatitude;
    }
    /**
     * Set pUploadedLatitude value
     * @param float $pUploadedLatitude
     * @return \StructType\UploadSurvey
     */
    public function setPUploadedLatitude($pUploadedLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($pUploadedLatitude) && !(is_float($pUploadedLatitude) || is_numeric($pUploadedLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pUploadedLatitude, true), gettype($pUploadedLatitude)), __LINE__);
        }
        $this->pUploadedLatitude = $pUploadedLatitude;
        return $this;
    }
    /**
     * Get pUploadedAccuracy value
     * @return float
     */
    public function getPUploadedAccuracy()
    {
        return $this->pUploadedAccuracy;
    }
    /**
     * Set pUploadedAccuracy value
     * @param float $pUploadedAccuracy
     * @return \StructType\UploadSurvey
     */
    public function setPUploadedAccuracy($pUploadedAccuracy = null)
    {
        // validation for constraint: float
        if (!is_null($pUploadedAccuracy) && !(is_float($pUploadedAccuracy) || is_numeric($pUploadedAccuracy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pUploadedAccuracy, true), gettype($pUploadedAccuracy)), __LINE__);
        }
        $this->pUploadedAccuracy = $pUploadedAccuracy;
        return $this;
    }
    /**
     * Get pCompletedDateTime value
     * @return string
     */
    public function getPCompletedDateTime()
    {
        return $this->pCompletedDateTime;
    }
    /**
     * Set pCompletedDateTime value
     * @param string $pCompletedDateTime
     * @return \StructType\UploadSurvey
     */
    public function setPCompletedDateTime($pCompletedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($pCompletedDateTime) && !is_string($pCompletedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pCompletedDateTime, true), gettype($pCompletedDateTime)), __LINE__);
        }
        $this->pCompletedDateTime = $pCompletedDateTime;
        return $this;
    }
    /**
     * Get pDrawingPhotoCount value
     * @return int
     */
    public function getPDrawingPhotoCount()
    {
        return $this->pDrawingPhotoCount;
    }
    /**
     * Set pDrawingPhotoCount value
     * @param int $pDrawingPhotoCount
     * @return \StructType\UploadSurvey
     */
    public function setPDrawingPhotoCount($pDrawingPhotoCount = null)
    {
        // validation for constraint: int
        if (!is_null($pDrawingPhotoCount) && !(is_int($pDrawingPhotoCount) || ctype_digit($pDrawingPhotoCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pDrawingPhotoCount, true), gettype($pDrawingPhotoCount)), __LINE__);
        }
        $this->pDrawingPhotoCount = $pDrawingPhotoCount;
        return $this;
    }
    /**
     * Get pRiskPhotoCount value
     * @return int
     */
    public function getPRiskPhotoCount()
    {
        return $this->pRiskPhotoCount;
    }
    /**
     * Set pRiskPhotoCount value
     * @param int $pRiskPhotoCount
     * @return \StructType\UploadSurvey
     */
    public function setPRiskPhotoCount($pRiskPhotoCount = null)
    {
        // validation for constraint: int
        if (!is_null($pRiskPhotoCount) && !(is_int($pRiskPhotoCount) || ctype_digit($pRiskPhotoCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pRiskPhotoCount, true), gettype($pRiskPhotoCount)), __LINE__);
        }
        $this->pRiskPhotoCount = $pRiskPhotoCount;
        return $this;
    }
    /**
     * Get pHubSurveyorID value
     * @return int
     */
    public function getPHubSurveyorID()
    {
        return $this->pHubSurveyorID;
    }
    /**
     * Set pHubSurveyorID value
     * @param int $pHubSurveyorID
     * @return \StructType\UploadSurvey
     */
    public function setPHubSurveyorID($pHubSurveyorID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubSurveyorID) && !(is_int($pHubSurveyorID) || ctype_digit($pHubSurveyorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubSurveyorID, true), gettype($pHubSurveyorID)), __LINE__);
        }
        $this->pHubSurveyorID = $pHubSurveyorID;
        return $this;
    }
    /**
     * Get pNoAccessAreas value
     * @return string|null
     */
    public function getPNoAccessAreas()
    {
        return $this->pNoAccessAreas;
    }
    /**
     * Set pNoAccessAreas value
     * @param string $pNoAccessAreas
     * @return \StructType\UploadSurvey
     */
    public function setPNoAccessAreas($pNoAccessAreas = null)
    {
        // validation for constraint: string
        if (!is_null($pNoAccessAreas) && !is_string($pNoAccessAreas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pNoAccessAreas, true), gettype($pNoAccessAreas)), __LINE__);
        }
        $this->pNoAccessAreas = $pNoAccessAreas;
        return $this;
    }
    /**
     * Get pAreasIncluded value
     * @return string|null
     */
    public function getPAreasIncluded()
    {
        return $this->pAreasIncluded;
    }
    /**
     * Set pAreasIncluded value
     * @param string $pAreasIncluded
     * @return \StructType\UploadSurvey
     */
    public function setPAreasIncluded($pAreasIncluded = null)
    {
        // validation for constraint: string
        if (!is_null($pAreasIncluded) && !is_string($pAreasIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAreasIncluded, true), gettype($pAreasIncluded)), __LINE__);
        }
        $this->pAreasIncluded = $pAreasIncluded;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadSurvey
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
