<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadCompanySettings StructType
 * @subpackage Structs
 */
class UploadCompanySettings extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pWaterManagementPolicyAssetID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pWaterManagementPolicyAssetID;
    /**
     * The pWaterManagementSystemAssetID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pWaterManagementSystemAssetID;
    /**
     * The pWaterManagementWaterSystemTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pWaterManagementWaterSystemTypeID;
    /**
     * Constructor method for UploadCompanySettings
     * @uses UploadCompanySettings::setPCompanyID()
     * @uses UploadCompanySettings::setPUserID()
     * @uses UploadCompanySettings::setPAuthKey()
     * @uses UploadCompanySettings::setPWaterManagementPolicyAssetID()
     * @uses UploadCompanySettings::setPWaterManagementSystemAssetID()
     * @uses UploadCompanySettings::setPWaterManagementWaterSystemTypeID()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pWaterManagementPolicyAssetID
     * @param int $pWaterManagementSystemAssetID
     * @param int $pWaterManagementWaterSystemTypeID
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pWaterManagementPolicyAssetID = null, $pWaterManagementSystemAssetID = null, $pWaterManagementWaterSystemTypeID = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPWaterManagementPolicyAssetID($pWaterManagementPolicyAssetID)
            ->setPWaterManagementSystemAssetID($pWaterManagementSystemAssetID)
            ->setPWaterManagementWaterSystemTypeID($pWaterManagementWaterSystemTypeID);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadCompanySettings
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadCompanySettings
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadCompanySettings
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pWaterManagementPolicyAssetID value
     * @return int
     */
    public function getPWaterManagementPolicyAssetID()
    {
        return $this->pWaterManagementPolicyAssetID;
    }
    /**
     * Set pWaterManagementPolicyAssetID value
     * @param int $pWaterManagementPolicyAssetID
     * @return \StructType\UploadCompanySettings
     */
    public function setPWaterManagementPolicyAssetID($pWaterManagementPolicyAssetID = null)
    {
        // validation for constraint: int
        if (!is_null($pWaterManagementPolicyAssetID) && !(is_int($pWaterManagementPolicyAssetID) || ctype_digit($pWaterManagementPolicyAssetID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pWaterManagementPolicyAssetID, true), gettype($pWaterManagementPolicyAssetID)), __LINE__);
        }
        $this->pWaterManagementPolicyAssetID = $pWaterManagementPolicyAssetID;
        return $this;
    }
    /**
     * Get pWaterManagementSystemAssetID value
     * @return int
     */
    public function getPWaterManagementSystemAssetID()
    {
        return $this->pWaterManagementSystemAssetID;
    }
    /**
     * Set pWaterManagementSystemAssetID value
     * @param int $pWaterManagementSystemAssetID
     * @return \StructType\UploadCompanySettings
     */
    public function setPWaterManagementSystemAssetID($pWaterManagementSystemAssetID = null)
    {
        // validation for constraint: int
        if (!is_null($pWaterManagementSystemAssetID) && !(is_int($pWaterManagementSystemAssetID) || ctype_digit($pWaterManagementSystemAssetID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pWaterManagementSystemAssetID, true), gettype($pWaterManagementSystemAssetID)), __LINE__);
        }
        $this->pWaterManagementSystemAssetID = $pWaterManagementSystemAssetID;
        return $this;
    }
    /**
     * Get pWaterManagementWaterSystemTypeID value
     * @return int
     */
    public function getPWaterManagementWaterSystemTypeID()
    {
        return $this->pWaterManagementWaterSystemTypeID;
    }
    /**
     * Set pWaterManagementWaterSystemTypeID value
     * @param int $pWaterManagementWaterSystemTypeID
     * @return \StructType\UploadCompanySettings
     */
    public function setPWaterManagementWaterSystemTypeID($pWaterManagementWaterSystemTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($pWaterManagementWaterSystemTypeID) && !(is_int($pWaterManagementWaterSystemTypeID) || ctype_digit($pWaterManagementWaterSystemTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pWaterManagementWaterSystemTypeID, true), gettype($pWaterManagementWaterSystemTypeID)), __LINE__);
        }
        $this->pWaterManagementWaterSystemTypeID = $pWaterManagementWaterSystemTypeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadCompanySettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
