<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownloadFileChunk StructType
 * @subpackage Structs
 */
class DownloadFileChunk extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pChunkNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pChunkNo;
    /**
     * The pFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pFileName;
    /**
     * Constructor method for DownloadFileChunk
     * @uses DownloadFileChunk::setPCompanyID()
     * @uses DownloadFileChunk::setPUserID()
     * @uses DownloadFileChunk::setPAuthKey()
     * @uses DownloadFileChunk::setPChunkNo()
     * @uses DownloadFileChunk::setPFileName()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pChunkNo
     * @param string $pFileName
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pChunkNo = null, $pFileName = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPChunkNo($pChunkNo)
            ->setPFileName($pFileName);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\DownloadFileChunk
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\DownloadFileChunk
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\DownloadFileChunk
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pChunkNo value
     * @return int
     */
    public function getPChunkNo()
    {
        return $this->pChunkNo;
    }
    /**
     * Set pChunkNo value
     * @param int $pChunkNo
     * @return \StructType\DownloadFileChunk
     */
    public function setPChunkNo($pChunkNo = null)
    {
        // validation for constraint: int
        if (!is_null($pChunkNo) && !(is_int($pChunkNo) || ctype_digit($pChunkNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pChunkNo, true), gettype($pChunkNo)), __LINE__);
        }
        $this->pChunkNo = $pChunkNo;
        return $this;
    }
    /**
     * Get pFileName value
     * @return string|null
     */
    public function getPFileName()
    {
        return $this->pFileName;
    }
    /**
     * Set pFileName value
     * @param string $pFileName
     * @return \StructType\DownloadFileChunk
     */
    public function setPFileName($pFileName = null)
    {
        // validation for constraint: string
        if (!is_null($pFileName) && !is_string($pFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pFileName, true), gettype($pFileName)), __LINE__);
        }
        $this->pFileName = $pFileName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DownloadFileChunk
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
