<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFSurvey StructType
 * @subpackage Structs
 */
class ClsWCFSurvey extends AbstractStructBase
{
    /**
     * The HousingFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HousingFlag;
    /**
     * The SurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SurveyID;
    /**
     * The ActualSurveyorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ActualSurveyorID;
    /**
     * The SchemeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SchemeID;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The SurveyDateAndTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SurveyDateAndTime;
    /**
     * The PriorityAssessmentReqFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PriorityAssessmentReqFlag;
    /**
     * The MaterialAssessmentReqFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MaterialAssessmentReqFlag;
    /**
     * The QuestionnareUploadedFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $QuestionnareUploadedFlag;
    /**
     * The DownloadedFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DownloadedFlag;
    /**
     * The ModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModifiedDateTime;
    /**
     * The SurveyTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurveyTypeCode;
    /**
     * The TelephoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TelephoneNumber;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientName;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiteName;
    /**
     * The SiteAddress1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiteAddress1;
    /**
     * The SiteAddress2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiteAddress2;
    /**
     * The SiteAddress3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiteAddress3;
    /**
     * The SiteAddress4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiteAddress4;
    /**
     * The SiteAddress5
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiteAddress5;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The ReportSpecialInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportSpecialInstructions;
    /**
     * The ProjectManagerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProjectManagerName;
    /**
     * The SpecialInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstructions;
    /**
     * The Scope
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Scope;
    /**
     * The ReInspectionItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClsWCFReInspectionItem
     */
    public $ReInspectionItems;
    /**
     * Constructor method for clsWCFSurvey
     * @uses ClsWCFSurvey::setHousingFlag()
     * @uses ClsWCFSurvey::setSurveyID()
     * @uses ClsWCFSurvey::setActualSurveyorID()
     * @uses ClsWCFSurvey::setSchemeID()
     * @uses ClsWCFSurvey::setReferenceNumber()
     * @uses ClsWCFSurvey::setStatusCode()
     * @uses ClsWCFSurvey::setSurveyDateAndTime()
     * @uses ClsWCFSurvey::setPriorityAssessmentReqFlag()
     * @uses ClsWCFSurvey::setMaterialAssessmentReqFlag()
     * @uses ClsWCFSurvey::setQuestionnareUploadedFlag()
     * @uses ClsWCFSurvey::setDownloadedFlag()
     * @uses ClsWCFSurvey::setModifiedDateTime()
     * @uses ClsWCFSurvey::setSurveyTypeCode()
     * @uses ClsWCFSurvey::setTelephoneNumber()
     * @uses ClsWCFSurvey::setClientName()
     * @uses ClsWCFSurvey::setSiteName()
     * @uses ClsWCFSurvey::setSiteAddress1()
     * @uses ClsWCFSurvey::setSiteAddress2()
     * @uses ClsWCFSurvey::setSiteAddress3()
     * @uses ClsWCFSurvey::setSiteAddress4()
     * @uses ClsWCFSurvey::setSiteAddress5()
     * @uses ClsWCFSurvey::setContactName()
     * @uses ClsWCFSurvey::setReportSpecialInstructions()
     * @uses ClsWCFSurvey::setProjectManagerName()
     * @uses ClsWCFSurvey::setSpecialInstructions()
     * @uses ClsWCFSurvey::setScope()
     * @uses ClsWCFSurvey::setReInspectionItems()
     * @param bool $housingFlag
     * @param int $surveyID
     * @param int $actualSurveyorID
     * @param int $schemeID
     * @param int $referenceNumber
     * @param int $statusCode
     * @param string $surveyDateAndTime
     * @param bool $priorityAssessmentReqFlag
     * @param bool $materialAssessmentReqFlag
     * @param bool $questionnareUploadedFlag
     * @param bool $downloadedFlag
     * @param string $modifiedDateTime
     * @param string $surveyTypeCode
     * @param string $telephoneNumber
     * @param string $clientName
     * @param string $siteName
     * @param string $siteAddress1
     * @param string $siteAddress2
     * @param string $siteAddress3
     * @param string $siteAddress4
     * @param string $siteAddress5
     * @param string $contactName
     * @param string $reportSpecialInstructions
     * @param string $projectManagerName
     * @param string $specialInstructions
     * @param string $scope
     * @param \ArrayType\ArrayOfClsWCFReInspectionItem $reInspectionItems
     */
    public function __construct($housingFlag = null, $surveyID = null, $actualSurveyorID = null, $schemeID = null, $referenceNumber = null, $statusCode = null, $surveyDateAndTime = null, $priorityAssessmentReqFlag = null, $materialAssessmentReqFlag = null, $questionnareUploadedFlag = null, $downloadedFlag = null, $modifiedDateTime = null, $surveyTypeCode = null, $telephoneNumber = null, $clientName = null, $siteName = null, $siteAddress1 = null, $siteAddress2 = null, $siteAddress3 = null, $siteAddress4 = null, $siteAddress5 = null, $contactName = null, $reportSpecialInstructions = null, $projectManagerName = null, $specialInstructions = null, $scope = null, \ArrayType\ArrayOfClsWCFReInspectionItem $reInspectionItems = null)
    {
        $this
            ->setHousingFlag($housingFlag)
            ->setSurveyID($surveyID)
            ->setActualSurveyorID($actualSurveyorID)
            ->setSchemeID($schemeID)
            ->setReferenceNumber($referenceNumber)
            ->setStatusCode($statusCode)
            ->setSurveyDateAndTime($surveyDateAndTime)
            ->setPriorityAssessmentReqFlag($priorityAssessmentReqFlag)
            ->setMaterialAssessmentReqFlag($materialAssessmentReqFlag)
            ->setQuestionnareUploadedFlag($questionnareUploadedFlag)
            ->setDownloadedFlag($downloadedFlag)
            ->setModifiedDateTime($modifiedDateTime)
            ->setSurveyTypeCode($surveyTypeCode)
            ->setTelephoneNumber($telephoneNumber)
            ->setClientName($clientName)
            ->setSiteName($siteName)
            ->setSiteAddress1($siteAddress1)
            ->setSiteAddress2($siteAddress2)
            ->setSiteAddress3($siteAddress3)
            ->setSiteAddress4($siteAddress4)
            ->setSiteAddress5($siteAddress5)
            ->setContactName($contactName)
            ->setReportSpecialInstructions($reportSpecialInstructions)
            ->setProjectManagerName($projectManagerName)
            ->setSpecialInstructions($specialInstructions)
            ->setScope($scope)
            ->setReInspectionItems($reInspectionItems);
    }
    /**
     * Get HousingFlag value
     * @return bool
     */
    public function getHousingFlag()
    {
        return $this->HousingFlag;
    }
    /**
     * Set HousingFlag value
     * @param bool $housingFlag
     * @return \StructType\ClsWCFSurvey
     */
    public function setHousingFlag($housingFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($housingFlag) && !is_bool($housingFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($housingFlag, true), gettype($housingFlag)), __LINE__);
        }
        $this->HousingFlag = $housingFlag;
        return $this;
    }
    /**
     * Get SurveyID value
     * @return int
     */
    public function getSurveyID()
    {
        return $this->SurveyID;
    }
    /**
     * Set SurveyID value
     * @param int $surveyID
     * @return \StructType\ClsWCFSurvey
     */
    public function setSurveyID($surveyID = null)
    {
        // validation for constraint: int
        if (!is_null($surveyID) && !(is_int($surveyID) || ctype_digit($surveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($surveyID, true), gettype($surveyID)), __LINE__);
        }
        $this->SurveyID = $surveyID;
        return $this;
    }
    /**
     * Get ActualSurveyorID value
     * @return int
     */
    public function getActualSurveyorID()
    {
        return $this->ActualSurveyorID;
    }
    /**
     * Set ActualSurveyorID value
     * @param int $actualSurveyorID
     * @return \StructType\ClsWCFSurvey
     */
    public function setActualSurveyorID($actualSurveyorID = null)
    {
        // validation for constraint: int
        if (!is_null($actualSurveyorID) && !(is_int($actualSurveyorID) || ctype_digit($actualSurveyorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actualSurveyorID, true), gettype($actualSurveyorID)), __LINE__);
        }
        $this->ActualSurveyorID = $actualSurveyorID;
        return $this;
    }
    /**
     * Get SchemeID value
     * @return int
     */
    public function getSchemeID()
    {
        return $this->SchemeID;
    }
    /**
     * Set SchemeID value
     * @param int $schemeID
     * @return \StructType\ClsWCFSurvey
     */
    public function setSchemeID($schemeID = null)
    {
        // validation for constraint: int
        if (!is_null($schemeID) && !(is_int($schemeID) || ctype_digit($schemeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($schemeID, true), gettype($schemeID)), __LINE__);
        }
        $this->SchemeID = $schemeID;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return int
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \StructType\ClsWCFSurvey
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \StructType\ClsWCFSurvey
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get SurveyDateAndTime value
     * @return string
     */
    public function getSurveyDateAndTime()
    {
        return $this->SurveyDateAndTime;
    }
    /**
     * Set SurveyDateAndTime value
     * @param string $surveyDateAndTime
     * @return \StructType\ClsWCFSurvey
     */
    public function setSurveyDateAndTime($surveyDateAndTime = null)
    {
        // validation for constraint: string
        if (!is_null($surveyDateAndTime) && !is_string($surveyDateAndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyDateAndTime, true), gettype($surveyDateAndTime)), __LINE__);
        }
        $this->SurveyDateAndTime = $surveyDateAndTime;
        return $this;
    }
    /**
     * Get PriorityAssessmentReqFlag value
     * @return bool
     */
    public function getPriorityAssessmentReqFlag()
    {
        return $this->PriorityAssessmentReqFlag;
    }
    /**
     * Set PriorityAssessmentReqFlag value
     * @param bool $priorityAssessmentReqFlag
     * @return \StructType\ClsWCFSurvey
     */
    public function setPriorityAssessmentReqFlag($priorityAssessmentReqFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($priorityAssessmentReqFlag) && !is_bool($priorityAssessmentReqFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($priorityAssessmentReqFlag, true), gettype($priorityAssessmentReqFlag)), __LINE__);
        }
        $this->PriorityAssessmentReqFlag = $priorityAssessmentReqFlag;
        return $this;
    }
    /**
     * Get MaterialAssessmentReqFlag value
     * @return bool
     */
    public function getMaterialAssessmentReqFlag()
    {
        return $this->MaterialAssessmentReqFlag;
    }
    /**
     * Set MaterialAssessmentReqFlag value
     * @param bool $materialAssessmentReqFlag
     * @return \StructType\ClsWCFSurvey
     */
    public function setMaterialAssessmentReqFlag($materialAssessmentReqFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($materialAssessmentReqFlag) && !is_bool($materialAssessmentReqFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($materialAssessmentReqFlag, true), gettype($materialAssessmentReqFlag)), __LINE__);
        }
        $this->MaterialAssessmentReqFlag = $materialAssessmentReqFlag;
        return $this;
    }
    /**
     * Get QuestionnareUploadedFlag value
     * @return bool
     */
    public function getQuestionnareUploadedFlag()
    {
        return $this->QuestionnareUploadedFlag;
    }
    /**
     * Set QuestionnareUploadedFlag value
     * @param bool $questionnareUploadedFlag
     * @return \StructType\ClsWCFSurvey
     */
    public function setQuestionnareUploadedFlag($questionnareUploadedFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($questionnareUploadedFlag) && !is_bool($questionnareUploadedFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($questionnareUploadedFlag, true), gettype($questionnareUploadedFlag)), __LINE__);
        }
        $this->QuestionnareUploadedFlag = $questionnareUploadedFlag;
        return $this;
    }
    /**
     * Get DownloadedFlag value
     * @return bool
     */
    public function getDownloadedFlag()
    {
        return $this->DownloadedFlag;
    }
    /**
     * Set DownloadedFlag value
     * @param bool $downloadedFlag
     * @return \StructType\ClsWCFSurvey
     */
    public function setDownloadedFlag($downloadedFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($downloadedFlag) && !is_bool($downloadedFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($downloadedFlag, true), gettype($downloadedFlag)), __LINE__);
        }
        $this->DownloadedFlag = $downloadedFlag;
        return $this;
    }
    /**
     * Get ModifiedDateTime value
     * @return string
     */
    public function getModifiedDateTime()
    {
        return $this->ModifiedDateTime;
    }
    /**
     * Set ModifiedDateTime value
     * @param string $modifiedDateTime
     * @return \StructType\ClsWCFSurvey
     */
    public function setModifiedDateTime($modifiedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDateTime) && !is_string($modifiedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedDateTime, true), gettype($modifiedDateTime)), __LINE__);
        }
        $this->ModifiedDateTime = $modifiedDateTime;
        return $this;
    }
    /**
     * Get SurveyTypeCode value
     * @return string|null
     */
    public function getSurveyTypeCode()
    {
        return $this->SurveyTypeCode;
    }
    /**
     * Set SurveyTypeCode value
     * @param string $surveyTypeCode
     * @return \StructType\ClsWCFSurvey
     */
    public function setSurveyTypeCode($surveyTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($surveyTypeCode) && !is_string($surveyTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyTypeCode, true), gettype($surveyTypeCode)), __LINE__);
        }
        $this->SurveyTypeCode = $surveyTypeCode;
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->TelephoneNumber;
    }
    /**
     * Set TelephoneNumber value
     * @param string $telephoneNumber
     * @return \StructType\ClsWCFSurvey
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephoneNumber, true), gettype($telephoneNumber)), __LINE__);
        }
        $this->TelephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get ClientName value
     * @return string|null
     */
    public function getClientName()
    {
        return $this->ClientName;
    }
    /**
     * Set ClientName value
     * @param string $clientName
     * @return \StructType\ClsWCFSurvey
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        $this->ClientName = $clientName;
        return $this;
    }
    /**
     * Get SiteName value
     * @return string|null
     */
    public function getSiteName()
    {
        return $this->SiteName;
    }
    /**
     * Set SiteName value
     * @param string $siteName
     * @return \StructType\ClsWCFSurvey
     */
    public function setSiteName($siteName = null)
    {
        // validation for constraint: string
        if (!is_null($siteName) && !is_string($siteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteName, true), gettype($siteName)), __LINE__);
        }
        $this->SiteName = $siteName;
        return $this;
    }
    /**
     * Get SiteAddress1 value
     * @return string|null
     */
    public function getSiteAddress1()
    {
        return $this->SiteAddress1;
    }
    /**
     * Set SiteAddress1 value
     * @param string $siteAddress1
     * @return \StructType\ClsWCFSurvey
     */
    public function setSiteAddress1($siteAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($siteAddress1) && !is_string($siteAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteAddress1, true), gettype($siteAddress1)), __LINE__);
        }
        $this->SiteAddress1 = $siteAddress1;
        return $this;
    }
    /**
     * Get SiteAddress2 value
     * @return string|null
     */
    public function getSiteAddress2()
    {
        return $this->SiteAddress2;
    }
    /**
     * Set SiteAddress2 value
     * @param string $siteAddress2
     * @return \StructType\ClsWCFSurvey
     */
    public function setSiteAddress2($siteAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($siteAddress2) && !is_string($siteAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteAddress2, true), gettype($siteAddress2)), __LINE__);
        }
        $this->SiteAddress2 = $siteAddress2;
        return $this;
    }
    /**
     * Get SiteAddress3 value
     * @return string|null
     */
    public function getSiteAddress3()
    {
        return $this->SiteAddress3;
    }
    /**
     * Set SiteAddress3 value
     * @param string $siteAddress3
     * @return \StructType\ClsWCFSurvey
     */
    public function setSiteAddress3($siteAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($siteAddress3) && !is_string($siteAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteAddress3, true), gettype($siteAddress3)), __LINE__);
        }
        $this->SiteAddress3 = $siteAddress3;
        return $this;
    }
    /**
     * Get SiteAddress4 value
     * @return string|null
     */
    public function getSiteAddress4()
    {
        return $this->SiteAddress4;
    }
    /**
     * Set SiteAddress4 value
     * @param string $siteAddress4
     * @return \StructType\ClsWCFSurvey
     */
    public function setSiteAddress4($siteAddress4 = null)
    {
        // validation for constraint: string
        if (!is_null($siteAddress4) && !is_string($siteAddress4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteAddress4, true), gettype($siteAddress4)), __LINE__);
        }
        $this->SiteAddress4 = $siteAddress4;
        return $this;
    }
    /**
     * Get SiteAddress5 value
     * @return string|null
     */
    public function getSiteAddress5()
    {
        return $this->SiteAddress5;
    }
    /**
     * Set SiteAddress5 value
     * @param string $siteAddress5
     * @return \StructType\ClsWCFSurvey
     */
    public function setSiteAddress5($siteAddress5 = null)
    {
        // validation for constraint: string
        if (!is_null($siteAddress5) && !is_string($siteAddress5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteAddress5, true), gettype($siteAddress5)), __LINE__);
        }
        $this->SiteAddress5 = $siteAddress5;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\ClsWCFSurvey
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get ReportSpecialInstructions value
     * @return string|null
     */
    public function getReportSpecialInstructions()
    {
        return $this->ReportSpecialInstructions;
    }
    /**
     * Set ReportSpecialInstructions value
     * @param string $reportSpecialInstructions
     * @return \StructType\ClsWCFSurvey
     */
    public function setReportSpecialInstructions($reportSpecialInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($reportSpecialInstructions) && !is_string($reportSpecialInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportSpecialInstructions, true), gettype($reportSpecialInstructions)), __LINE__);
        }
        $this->ReportSpecialInstructions = $reportSpecialInstructions;
        return $this;
    }
    /**
     * Get ProjectManagerName value
     * @return string|null
     */
    public function getProjectManagerName()
    {
        return $this->ProjectManagerName;
    }
    /**
     * Set ProjectManagerName value
     * @param string $projectManagerName
     * @return \StructType\ClsWCFSurvey
     */
    public function setProjectManagerName($projectManagerName = null)
    {
        // validation for constraint: string
        if (!is_null($projectManagerName) && !is_string($projectManagerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectManagerName, true), gettype($projectManagerName)), __LINE__);
        }
        $this->ProjectManagerName = $projectManagerName;
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * @return string|null
     */
    public function getSpecialInstructions()
    {
        return $this->SpecialInstructions;
    }
    /**
     * Set SpecialInstructions value
     * @param string $specialInstructions
     * @return \StructType\ClsWCFSurvey
     */
    public function setSpecialInstructions($specialInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions) && !is_string($specialInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstructions, true), gettype($specialInstructions)), __LINE__);
        }
        $this->SpecialInstructions = $specialInstructions;
        return $this;
    }
    /**
     * Get Scope value
     * @return string|null
     */
    public function getScope()
    {
        return $this->Scope;
    }
    /**
     * Set Scope value
     * @param string $scope
     * @return \StructType\ClsWCFSurvey
     */
    public function setScope($scope = null)
    {
        // validation for constraint: string
        if (!is_null($scope) && !is_string($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scope, true), gettype($scope)), __LINE__);
        }
        $this->Scope = $scope;
        return $this;
    }
    /**
     * Get ReInspectionItems value
     * @return \ArrayType\ArrayOfClsWCFReInspectionItem|null
     */
    public function getReInspectionItems()
    {
        return $this->ReInspectionItems;
    }
    /**
     * Set ReInspectionItems value
     * @param \ArrayType\ArrayOfClsWCFReInspectionItem $reInspectionItems
     * @return \StructType\ClsWCFSurvey
     */
    public function setReInspectionItems(\ArrayType\ArrayOfClsWCFReInspectionItem $reInspectionItems = null)
    {
        $this->ReInspectionItems = $reInspectionItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFSurvey
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
