<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFReInspectionItem StructType
 * @subpackage Structs
 */
class ClsWCFReInspectionItem extends AbstractStructBase
{
    /**
     * The ReInspectionItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReInspectionItemID;
    /**
     * The SurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SurveyID;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The OriginalReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OriginalReferenceNumber;
    /**
     * The MaterialProductTypeFactorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaterialProductTypeFactorId;
    /**
     * The MaterialAsbestosTypeFactorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaterialAsbestosTypeFactorId;
    /**
     * The BuildingDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingDescription;
    /**
     * The BlockNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BlockNumber;
    /**
     * The FloorDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FloorDescription;
    /**
     * The RoomDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomDescription;
    /**
     * The RoomNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomNumber;
    /**
     * The PositionDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PositionDescription;
    /**
     * The ComponentDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ComponentDescription;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for clsWCFReInspectionItem
     * @uses ClsWCFReInspectionItem::setReInspectionItemID()
     * @uses ClsWCFReInspectionItem::setSurveyID()
     * @uses ClsWCFReInspectionItem::setReferenceNumber()
     * @uses ClsWCFReInspectionItem::setOriginalReferenceNumber()
     * @uses ClsWCFReInspectionItem::setMaterialProductTypeFactorId()
     * @uses ClsWCFReInspectionItem::setMaterialAsbestosTypeFactorId()
     * @uses ClsWCFReInspectionItem::setBuildingDescription()
     * @uses ClsWCFReInspectionItem::setBlockNumber()
     * @uses ClsWCFReInspectionItem::setFloorDescription()
     * @uses ClsWCFReInspectionItem::setRoomDescription()
     * @uses ClsWCFReInspectionItem::setRoomNumber()
     * @uses ClsWCFReInspectionItem::setPositionDescription()
     * @uses ClsWCFReInspectionItem::setComponentDescription()
     * @uses ClsWCFReInspectionItem::setNotes()
     * @param int $reInspectionItemID
     * @param int $surveyID
     * @param int $referenceNumber
     * @param int $originalReferenceNumber
     * @param int $materialProductTypeFactorId
     * @param int $materialAsbestosTypeFactorId
     * @param string $buildingDescription
     * @param string $blockNumber
     * @param string $floorDescription
     * @param string $roomDescription
     * @param string $roomNumber
     * @param string $positionDescription
     * @param string $componentDescription
     * @param string $notes
     */
    public function __construct($reInspectionItemID = null, $surveyID = null, $referenceNumber = null, $originalReferenceNumber = null, $materialProductTypeFactorId = null, $materialAsbestosTypeFactorId = null, $buildingDescription = null, $blockNumber = null, $floorDescription = null, $roomDescription = null, $roomNumber = null, $positionDescription = null, $componentDescription = null, $notes = null)
    {
        $this
            ->setReInspectionItemID($reInspectionItemID)
            ->setSurveyID($surveyID)
            ->setReferenceNumber($referenceNumber)
            ->setOriginalReferenceNumber($originalReferenceNumber)
            ->setMaterialProductTypeFactorId($materialProductTypeFactorId)
            ->setMaterialAsbestosTypeFactorId($materialAsbestosTypeFactorId)
            ->setBuildingDescription($buildingDescription)
            ->setBlockNumber($blockNumber)
            ->setFloorDescription($floorDescription)
            ->setRoomDescription($roomDescription)
            ->setRoomNumber($roomNumber)
            ->setPositionDescription($positionDescription)
            ->setComponentDescription($componentDescription)
            ->setNotes($notes);
    }
    /**
     * Get ReInspectionItemID value
     * @return int
     */
    public function getReInspectionItemID()
    {
        return $this->ReInspectionItemID;
    }
    /**
     * Set ReInspectionItemID value
     * @param int $reInspectionItemID
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setReInspectionItemID($reInspectionItemID = null)
    {
        // validation for constraint: int
        if (!is_null($reInspectionItemID) && !(is_int($reInspectionItemID) || ctype_digit($reInspectionItemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reInspectionItemID, true), gettype($reInspectionItemID)), __LINE__);
        }
        $this->ReInspectionItemID = $reInspectionItemID;
        return $this;
    }
    /**
     * Get SurveyID value
     * @return int
     */
    public function getSurveyID()
    {
        return $this->SurveyID;
    }
    /**
     * Set SurveyID value
     * @param int $surveyID
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setSurveyID($surveyID = null)
    {
        // validation for constraint: int
        if (!is_null($surveyID) && !(is_int($surveyID) || ctype_digit($surveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($surveyID, true), gettype($surveyID)), __LINE__);
        }
        $this->SurveyID = $surveyID;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return int
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get OriginalReferenceNumber value
     * @return int
     */
    public function getOriginalReferenceNumber()
    {
        return $this->OriginalReferenceNumber;
    }
    /**
     * Set OriginalReferenceNumber value
     * @param int $originalReferenceNumber
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setOriginalReferenceNumber($originalReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($originalReferenceNumber) && !(is_int($originalReferenceNumber) || ctype_digit($originalReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalReferenceNumber, true), gettype($originalReferenceNumber)), __LINE__);
        }
        $this->OriginalReferenceNumber = $originalReferenceNumber;
        return $this;
    }
    /**
     * Get MaterialProductTypeFactorId value
     * @return int
     */
    public function getMaterialProductTypeFactorId()
    {
        return $this->MaterialProductTypeFactorId;
    }
    /**
     * Set MaterialProductTypeFactorId value
     * @param int $materialProductTypeFactorId
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setMaterialProductTypeFactorId($materialProductTypeFactorId = null)
    {
        // validation for constraint: int
        if (!is_null($materialProductTypeFactorId) && !(is_int($materialProductTypeFactorId) || ctype_digit($materialProductTypeFactorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($materialProductTypeFactorId, true), gettype($materialProductTypeFactorId)), __LINE__);
        }
        $this->MaterialProductTypeFactorId = $materialProductTypeFactorId;
        return $this;
    }
    /**
     * Get MaterialAsbestosTypeFactorId value
     * @return int
     */
    public function getMaterialAsbestosTypeFactorId()
    {
        return $this->MaterialAsbestosTypeFactorId;
    }
    /**
     * Set MaterialAsbestosTypeFactorId value
     * @param int $materialAsbestosTypeFactorId
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setMaterialAsbestosTypeFactorId($materialAsbestosTypeFactorId = null)
    {
        // validation for constraint: int
        if (!is_null($materialAsbestosTypeFactorId) && !(is_int($materialAsbestosTypeFactorId) || ctype_digit($materialAsbestosTypeFactorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($materialAsbestosTypeFactorId, true), gettype($materialAsbestosTypeFactorId)), __LINE__);
        }
        $this->MaterialAsbestosTypeFactorId = $materialAsbestosTypeFactorId;
        return $this;
    }
    /**
     * Get BuildingDescription value
     * @return string|null
     */
    public function getBuildingDescription()
    {
        return $this->BuildingDescription;
    }
    /**
     * Set BuildingDescription value
     * @param string $buildingDescription
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setBuildingDescription($buildingDescription = null)
    {
        // validation for constraint: string
        if (!is_null($buildingDescription) && !is_string($buildingDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingDescription, true), gettype($buildingDescription)), __LINE__);
        }
        $this->BuildingDescription = $buildingDescription;
        return $this;
    }
    /**
     * Get BlockNumber value
     * @return string|null
     */
    public function getBlockNumber()
    {
        return $this->BlockNumber;
    }
    /**
     * Set BlockNumber value
     * @param string $blockNumber
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setBlockNumber($blockNumber = null)
    {
        // validation for constraint: string
        if (!is_null($blockNumber) && !is_string($blockNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockNumber, true), gettype($blockNumber)), __LINE__);
        }
        $this->BlockNumber = $blockNumber;
        return $this;
    }
    /**
     * Get FloorDescription value
     * @return string|null
     */
    public function getFloorDescription()
    {
        return $this->FloorDescription;
    }
    /**
     * Set FloorDescription value
     * @param string $floorDescription
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setFloorDescription($floorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($floorDescription) && !is_string($floorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floorDescription, true), gettype($floorDescription)), __LINE__);
        }
        $this->FloorDescription = $floorDescription;
        return $this;
    }
    /**
     * Get RoomDescription value
     * @return string|null
     */
    public function getRoomDescription()
    {
        return $this->RoomDescription;
    }
    /**
     * Set RoomDescription value
     * @param string $roomDescription
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setRoomDescription($roomDescription = null)
    {
        // validation for constraint: string
        if (!is_null($roomDescription) && !is_string($roomDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomDescription, true), gettype($roomDescription)), __LINE__);
        }
        $this->RoomDescription = $roomDescription;
        return $this;
    }
    /**
     * Get RoomNumber value
     * @return string|null
     */
    public function getRoomNumber()
    {
        return $this->RoomNumber;
    }
    /**
     * Set RoomNumber value
     * @param string $roomNumber
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setRoomNumber($roomNumber = null)
    {
        // validation for constraint: string
        if (!is_null($roomNumber) && !is_string($roomNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomNumber, true), gettype($roomNumber)), __LINE__);
        }
        $this->RoomNumber = $roomNumber;
        return $this;
    }
    /**
     * Get PositionDescription value
     * @return string|null
     */
    public function getPositionDescription()
    {
        return $this->PositionDescription;
    }
    /**
     * Set PositionDescription value
     * @param string $positionDescription
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setPositionDescription($positionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($positionDescription) && !is_string($positionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionDescription, true), gettype($positionDescription)), __LINE__);
        }
        $this->PositionDescription = $positionDescription;
        return $this;
    }
    /**
     * Get ComponentDescription value
     * @return string|null
     */
    public function getComponentDescription()
    {
        return $this->ComponentDescription;
    }
    /**
     * Set ComponentDescription value
     * @param string $componentDescription
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setComponentDescription($componentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($componentDescription) && !is_string($componentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($componentDescription, true), gettype($componentDescription)), __LINE__);
        }
        $this->ComponentDescription = $componentDescription;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\ClsWCFReInspectionItem
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFReInspectionItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
