<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFJobOperative StructType
 * @subpackage Structs
 */
class ClsWCFJobOperative extends AbstractStructBase
{
    /**
     * The OperativeEntryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OperativeEntryID;
    /**
     * The SurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SurveyID;
    /**
     * The OperativeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OperativeID;
    /**
     * The OperativeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperativeName;
    /**
     * Constructor method for clsWCFJobOperative
     * @uses ClsWCFJobOperative::setOperativeEntryID()
     * @uses ClsWCFJobOperative::setSurveyID()
     * @uses ClsWCFJobOperative::setOperativeID()
     * @uses ClsWCFJobOperative::setOperativeName()
     * @param int $operativeEntryID
     * @param int $surveyID
     * @param int $operativeID
     * @param string $operativeName
     */
    public function __construct($operativeEntryID = null, $surveyID = null, $operativeID = null, $operativeName = null)
    {
        $this
            ->setOperativeEntryID($operativeEntryID)
            ->setSurveyID($surveyID)
            ->setOperativeID($operativeID)
            ->setOperativeName($operativeName);
    }
    /**
     * Get OperativeEntryID value
     * @return int
     */
    public function getOperativeEntryID()
    {
        return $this->OperativeEntryID;
    }
    /**
     * Set OperativeEntryID value
     * @param int $operativeEntryID
     * @return \StructType\ClsWCFJobOperative
     */
    public function setOperativeEntryID($operativeEntryID = null)
    {
        // validation for constraint: int
        if (!is_null($operativeEntryID) && !(is_int($operativeEntryID) || ctype_digit($operativeEntryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operativeEntryID, true), gettype($operativeEntryID)), __LINE__);
        }
        $this->OperativeEntryID = $operativeEntryID;
        return $this;
    }
    /**
     * Get SurveyID value
     * @return int
     */
    public function getSurveyID()
    {
        return $this->SurveyID;
    }
    /**
     * Set SurveyID value
     * @param int $surveyID
     * @return \StructType\ClsWCFJobOperative
     */
    public function setSurveyID($surveyID = null)
    {
        // validation for constraint: int
        if (!is_null($surveyID) && !(is_int($surveyID) || ctype_digit($surveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($surveyID, true), gettype($surveyID)), __LINE__);
        }
        $this->SurveyID = $surveyID;
        return $this;
    }
    /**
     * Get OperativeID value
     * @return int
     */
    public function getOperativeID()
    {
        return $this->OperativeID;
    }
    /**
     * Set OperativeID value
     * @param int $operativeID
     * @return \StructType\ClsWCFJobOperative
     */
    public function setOperativeID($operativeID = null)
    {
        // validation for constraint: int
        if (!is_null($operativeID) && !(is_int($operativeID) || ctype_digit($operativeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operativeID, true), gettype($operativeID)), __LINE__);
        }
        $this->OperativeID = $operativeID;
        return $this;
    }
    /**
     * Get OperativeName value
     * @return string|null
     */
    public function getOperativeName()
    {
        return $this->OperativeName;
    }
    /**
     * Set OperativeName value
     * @param string $operativeName
     * @return \StructType\ClsWCFJobOperative
     */
    public function setOperativeName($operativeName = null)
    {
        // validation for constraint: string
        if (!is_null($operativeName) && !is_string($operativeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operativeName, true), gettype($operativeName)), __LINE__);
        }
        $this->OperativeName = $operativeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFJobOperative
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
