<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFIntMessage StructType
 * @subpackage Structs
 */
class ClsWCFIntMessage extends AbstractStructBase
{
    /**
     * The ReturnValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReturnValue;
    /**
     * The NextAuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NextAuthCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for clsWCFIntMessage
     * @uses ClsWCFIntMessage::setReturnValue()
     * @uses ClsWCFIntMessage::setNextAuthCode()
     * @uses ClsWCFIntMessage::setErrorMessage()
     * @param int $returnValue
     * @param string $nextAuthCode
     * @param string $errorMessage
     */
    public function __construct($returnValue = null, $nextAuthCode = null, $errorMessage = null)
    {
        $this
            ->setReturnValue($returnValue)
            ->setNextAuthCode($nextAuthCode)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get ReturnValue value
     * @return int
     */
    public function getReturnValue()
    {
        return $this->ReturnValue;
    }
    /**
     * Set ReturnValue value
     * @param int $returnValue
     * @return \StructType\ClsWCFIntMessage
     */
    public function setReturnValue($returnValue = null)
    {
        // validation for constraint: int
        if (!is_null($returnValue) && !(is_int($returnValue) || ctype_digit($returnValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnValue, true), gettype($returnValue)), __LINE__);
        }
        $this->ReturnValue = $returnValue;
        return $this;
    }
    /**
     * Get NextAuthCode value
     * @return string|null
     */
    public function getNextAuthCode()
    {
        return $this->NextAuthCode;
    }
    /**
     * Set NextAuthCode value
     * @param string $nextAuthCode
     * @return \StructType\ClsWCFIntMessage
     */
    public function setNextAuthCode($nextAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($nextAuthCode) && !is_string($nextAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextAuthCode, true), gettype($nextAuthCode)), __LINE__);
        }
        $this->NextAuthCode = $nextAuthCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\ClsWCFIntMessage
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFIntMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
