<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFFlatFire StructType
 * @subpackage Structs
 */
class ClsWCFFlatFire extends AbstractStructBase
{
    /**
     * The HubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSurveyID;
    /**
     * The DomicileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DomicileID;
    /**
     * The DomicileNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DomicileNumber;
    /**
     * The IntermittentSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IntermittentSelection;
    /**
     * The IntermittentPriority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IntermittentPriority;
    /**
     * The CloserSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CloserSelection;
    /**
     * The CloserPriority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CloserPriority;
    /**
     * The AdequateSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdequateSelection;
    /**
     * The AdequatePriority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdequatePriority;
    /**
     * The DomicileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomicileName;
    /**
     * The AdditionalComments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalComments;
    /**
     * Constructor method for clsWCFFlatFire
     * @uses ClsWCFFlatFire::setHubSurveyID()
     * @uses ClsWCFFlatFire::setDomicileID()
     * @uses ClsWCFFlatFire::setDomicileNumber()
     * @uses ClsWCFFlatFire::setIntermittentSelection()
     * @uses ClsWCFFlatFire::setIntermittentPriority()
     * @uses ClsWCFFlatFire::setCloserSelection()
     * @uses ClsWCFFlatFire::setCloserPriority()
     * @uses ClsWCFFlatFire::setAdequateSelection()
     * @uses ClsWCFFlatFire::setAdequatePriority()
     * @uses ClsWCFFlatFire::setDomicileName()
     * @uses ClsWCFFlatFire::setAdditionalComments()
     * @param int $hubSurveyID
     * @param int $domicileID
     * @param int $domicileNumber
     * @param int $intermittentSelection
     * @param int $intermittentPriority
     * @param int $closerSelection
     * @param int $closerPriority
     * @param int $adequateSelection
     * @param int $adequatePriority
     * @param string $domicileName
     * @param string $additionalComments
     */
    public function __construct($hubSurveyID = null, $domicileID = null, $domicileNumber = null, $intermittentSelection = null, $intermittentPriority = null, $closerSelection = null, $closerPriority = null, $adequateSelection = null, $adequatePriority = null, $domicileName = null, $additionalComments = null)
    {
        $this
            ->setHubSurveyID($hubSurveyID)
            ->setDomicileID($domicileID)
            ->setDomicileNumber($domicileNumber)
            ->setIntermittentSelection($intermittentSelection)
            ->setIntermittentPriority($intermittentPriority)
            ->setCloserSelection($closerSelection)
            ->setCloserPriority($closerPriority)
            ->setAdequateSelection($adequateSelection)
            ->setAdequatePriority($adequatePriority)
            ->setDomicileName($domicileName)
            ->setAdditionalComments($additionalComments);
    }
    /**
     * Get HubSurveyID value
     * @return int
     */
    public function getHubSurveyID()
    {
        return $this->HubSurveyID;
    }
    /**
     * Set HubSurveyID value
     * @param int $hubSurveyID
     * @return \StructType\ClsWCFFlatFire
     */
    public function setHubSurveyID($hubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSurveyID) && !(is_int($hubSurveyID) || ctype_digit($hubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSurveyID, true), gettype($hubSurveyID)), __LINE__);
        }
        $this->HubSurveyID = $hubSurveyID;
        return $this;
    }
    /**
     * Get DomicileID value
     * @return int
     */
    public function getDomicileID()
    {
        return $this->DomicileID;
    }
    /**
     * Set DomicileID value
     * @param int $domicileID
     * @return \StructType\ClsWCFFlatFire
     */
    public function setDomicileID($domicileID = null)
    {
        // validation for constraint: int
        if (!is_null($domicileID) && !(is_int($domicileID) || ctype_digit($domicileID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($domicileID, true), gettype($domicileID)), __LINE__);
        }
        $this->DomicileID = $domicileID;
        return $this;
    }
    /**
     * Get DomicileNumber value
     * @return int
     */
    public function getDomicileNumber()
    {
        return $this->DomicileNumber;
    }
    /**
     * Set DomicileNumber value
     * @param int $domicileNumber
     * @return \StructType\ClsWCFFlatFire
     */
    public function setDomicileNumber($domicileNumber = null)
    {
        // validation for constraint: int
        if (!is_null($domicileNumber) && !(is_int($domicileNumber) || ctype_digit($domicileNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($domicileNumber, true), gettype($domicileNumber)), __LINE__);
        }
        $this->DomicileNumber = $domicileNumber;
        return $this;
    }
    /**
     * Get IntermittentSelection value
     * @return int
     */
    public function getIntermittentSelection()
    {
        return $this->IntermittentSelection;
    }
    /**
     * Set IntermittentSelection value
     * @param int $intermittentSelection
     * @return \StructType\ClsWCFFlatFire
     */
    public function setIntermittentSelection($intermittentSelection = null)
    {
        // validation for constraint: int
        if (!is_null($intermittentSelection) && !(is_int($intermittentSelection) || ctype_digit($intermittentSelection))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intermittentSelection, true), gettype($intermittentSelection)), __LINE__);
        }
        $this->IntermittentSelection = $intermittentSelection;
        return $this;
    }
    /**
     * Get IntermittentPriority value
     * @return int
     */
    public function getIntermittentPriority()
    {
        return $this->IntermittentPriority;
    }
    /**
     * Set IntermittentPriority value
     * @param int $intermittentPriority
     * @return \StructType\ClsWCFFlatFire
     */
    public function setIntermittentPriority($intermittentPriority = null)
    {
        // validation for constraint: int
        if (!is_null($intermittentPriority) && !(is_int($intermittentPriority) || ctype_digit($intermittentPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intermittentPriority, true), gettype($intermittentPriority)), __LINE__);
        }
        $this->IntermittentPriority = $intermittentPriority;
        return $this;
    }
    /**
     * Get CloserSelection value
     * @return int
     */
    public function getCloserSelection()
    {
        return $this->CloserSelection;
    }
    /**
     * Set CloserSelection value
     * @param int $closerSelection
     * @return \StructType\ClsWCFFlatFire
     */
    public function setCloserSelection($closerSelection = null)
    {
        // validation for constraint: int
        if (!is_null($closerSelection) && !(is_int($closerSelection) || ctype_digit($closerSelection))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($closerSelection, true), gettype($closerSelection)), __LINE__);
        }
        $this->CloserSelection = $closerSelection;
        return $this;
    }
    /**
     * Get CloserPriority value
     * @return int
     */
    public function getCloserPriority()
    {
        return $this->CloserPriority;
    }
    /**
     * Set CloserPriority value
     * @param int $closerPriority
     * @return \StructType\ClsWCFFlatFire
     */
    public function setCloserPriority($closerPriority = null)
    {
        // validation for constraint: int
        if (!is_null($closerPriority) && !(is_int($closerPriority) || ctype_digit($closerPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($closerPriority, true), gettype($closerPriority)), __LINE__);
        }
        $this->CloserPriority = $closerPriority;
        return $this;
    }
    /**
     * Get AdequateSelection value
     * @return int
     */
    public function getAdequateSelection()
    {
        return $this->AdequateSelection;
    }
    /**
     * Set AdequateSelection value
     * @param int $adequateSelection
     * @return \StructType\ClsWCFFlatFire
     */
    public function setAdequateSelection($adequateSelection = null)
    {
        // validation for constraint: int
        if (!is_null($adequateSelection) && !(is_int($adequateSelection) || ctype_digit($adequateSelection))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adequateSelection, true), gettype($adequateSelection)), __LINE__);
        }
        $this->AdequateSelection = $adequateSelection;
        return $this;
    }
    /**
     * Get AdequatePriority value
     * @return int
     */
    public function getAdequatePriority()
    {
        return $this->AdequatePriority;
    }
    /**
     * Set AdequatePriority value
     * @param int $adequatePriority
     * @return \StructType\ClsWCFFlatFire
     */
    public function setAdequatePriority($adequatePriority = null)
    {
        // validation for constraint: int
        if (!is_null($adequatePriority) && !(is_int($adequatePriority) || ctype_digit($adequatePriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adequatePriority, true), gettype($adequatePriority)), __LINE__);
        }
        $this->AdequatePriority = $adequatePriority;
        return $this;
    }
    /**
     * Get DomicileName value
     * @return string|null
     */
    public function getDomicileName()
    {
        return $this->DomicileName;
    }
    /**
     * Set DomicileName value
     * @param string $domicileName
     * @return \StructType\ClsWCFFlatFire
     */
    public function setDomicileName($domicileName = null)
    {
        // validation for constraint: string
        if (!is_null($domicileName) && !is_string($domicileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domicileName, true), gettype($domicileName)), __LINE__);
        }
        $this->DomicileName = $domicileName;
        return $this;
    }
    /**
     * Get AdditionalComments value
     * @return string|null
     */
    public function getAdditionalComments()
    {
        return $this->AdditionalComments;
    }
    /**
     * Set AdditionalComments value
     * @param string $additionalComments
     * @return \StructType\ClsWCFFlatFire
     */
    public function setAdditionalComments($additionalComments = null)
    {
        // validation for constraint: string
        if (!is_null($additionalComments) && !is_string($additionalComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalComments, true), gettype($additionalComments)), __LINE__);
        }
        $this->AdditionalComments = $additionalComments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFFlatFire
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
