<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFErrorMessage StructType
 * @subpackage Structs
 */
class ClsWCFErrorMessage extends AbstractStructBase
{
    /**
     * The LineNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineNumber;
    /**
     * The PriorityLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriorityLevel;
    /**
     * The DateAndTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateAndTime;
    /**
     * The LocalUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalUserName;
    /**
     * The LocationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationCode;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramName;
    /**
     * The ModuleAndProcedure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModuleAndProcedure;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The AdditionalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalInfo;
    /**
     * Constructor method for clsWCFErrorMessage
     * @uses ClsWCFErrorMessage::setLineNumber()
     * @uses ClsWCFErrorMessage::setPriorityLevel()
     * @uses ClsWCFErrorMessage::setDateAndTime()
     * @uses ClsWCFErrorMessage::setLocalUserName()
     * @uses ClsWCFErrorMessage::setLocationCode()
     * @uses ClsWCFErrorMessage::setProgramName()
     * @uses ClsWCFErrorMessage::setModuleAndProcedure()
     * @uses ClsWCFErrorMessage::setMessage()
     * @uses ClsWCFErrorMessage::setAdditionalInfo()
     * @param int $lineNumber
     * @param int $priorityLevel
     * @param string $dateAndTime
     * @param string $localUserName
     * @param string $locationCode
     * @param string $programName
     * @param string $moduleAndProcedure
     * @param string $message
     * @param string $additionalInfo
     */
    public function __construct($lineNumber = null, $priorityLevel = null, $dateAndTime = null, $localUserName = null, $locationCode = null, $programName = null, $moduleAndProcedure = null, $message = null, $additionalInfo = null)
    {
        $this
            ->setLineNumber($lineNumber)
            ->setPriorityLevel($priorityLevel)
            ->setDateAndTime($dateAndTime)
            ->setLocalUserName($localUserName)
            ->setLocationCode($locationCode)
            ->setProgramName($programName)
            ->setModuleAndProcedure($moduleAndProcedure)
            ->setMessage($message)
            ->setAdditionalInfo($additionalInfo);
    }
    /**
     * Get LineNumber value
     * @return int
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param int $lineNumber
     * @return \StructType\ClsWCFErrorMessage
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !(is_int($lineNumber) || ctype_digit($lineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get PriorityLevel value
     * @return int
     */
    public function getPriorityLevel()
    {
        return $this->PriorityLevel;
    }
    /**
     * Set PriorityLevel value
     * @param int $priorityLevel
     * @return \StructType\ClsWCFErrorMessage
     */
    public function setPriorityLevel($priorityLevel = null)
    {
        // validation for constraint: int
        if (!is_null($priorityLevel) && !(is_int($priorityLevel) || ctype_digit($priorityLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priorityLevel, true), gettype($priorityLevel)), __LINE__);
        }
        $this->PriorityLevel = $priorityLevel;
        return $this;
    }
    /**
     * Get DateAndTime value
     * @return string
     */
    public function getDateAndTime()
    {
        return $this->DateAndTime;
    }
    /**
     * Set DateAndTime value
     * @param string $dateAndTime
     * @return \StructType\ClsWCFErrorMessage
     */
    public function setDateAndTime($dateAndTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateAndTime) && !is_string($dateAndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateAndTime, true), gettype($dateAndTime)), __LINE__);
        }
        $this->DateAndTime = $dateAndTime;
        return $this;
    }
    /**
     * Get LocalUserName value
     * @return string|null
     */
    public function getLocalUserName()
    {
        return $this->LocalUserName;
    }
    /**
     * Set LocalUserName value
     * @param string $localUserName
     * @return \StructType\ClsWCFErrorMessage
     */
    public function setLocalUserName($localUserName = null)
    {
        // validation for constraint: string
        if (!is_null($localUserName) && !is_string($localUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localUserName, true), gettype($localUserName)), __LINE__);
        }
        $this->LocalUserName = $localUserName;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \StructType\ClsWCFErrorMessage
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationCode, true), gettype($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \StructType\ClsWCFErrorMessage
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get ModuleAndProcedure value
     * @return string|null
     */
    public function getModuleAndProcedure()
    {
        return $this->ModuleAndProcedure;
    }
    /**
     * Set ModuleAndProcedure value
     * @param string $moduleAndProcedure
     * @return \StructType\ClsWCFErrorMessage
     */
    public function setModuleAndProcedure($moduleAndProcedure = null)
    {
        // validation for constraint: string
        if (!is_null($moduleAndProcedure) && !is_string($moduleAndProcedure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moduleAndProcedure, true), gettype($moduleAndProcedure)), __LINE__);
        }
        $this->ModuleAndProcedure = $moduleAndProcedure;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\ClsWCFErrorMessage
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param string $additionalInfo
     * @return \StructType\ClsWCFErrorMessage
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInfo, true), gettype($additionalInfo)), __LINE__);
        }
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFErrorMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
