<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFCompanyMessage StructType
 * @subpackage Structs
 */
class ClsWCFCompanyMessage extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The NextAuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NextAuthCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The UserKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserKey;
    /**
     * Constructor method for clsWCFCompanyMessage
     * @uses ClsWCFCompanyMessage::setCompanyID()
     * @uses ClsWCFCompanyMessage::setUserID()
     * @uses ClsWCFCompanyMessage::setNextAuthCode()
     * @uses ClsWCFCompanyMessage::setErrorMessage()
     * @uses ClsWCFCompanyMessage::setCompanyName()
     * @uses ClsWCFCompanyMessage::setUserKey()
     * @param int $companyID
     * @param int $userID
     * @param string $nextAuthCode
     * @param string $errorMessage
     * @param string $companyName
     * @param string $userKey
     */
    public function __construct($companyID = null, $userID = null, $nextAuthCode = null, $errorMessage = null, $companyName = null, $userKey = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setUserID($userID)
            ->setNextAuthCode($nextAuthCode)
            ->setErrorMessage($errorMessage)
            ->setCompanyName($companyName)
            ->setUserKey($userKey);
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \StructType\ClsWCFCompanyMessage
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \StructType\ClsWCFCompanyMessage
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get NextAuthCode value
     * @return string|null
     */
    public function getNextAuthCode()
    {
        return $this->NextAuthCode;
    }
    /**
     * Set NextAuthCode value
     * @param string $nextAuthCode
     * @return \StructType\ClsWCFCompanyMessage
     */
    public function setNextAuthCode($nextAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($nextAuthCode) && !is_string($nextAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextAuthCode, true), gettype($nextAuthCode)), __LINE__);
        }
        $this->NextAuthCode = $nextAuthCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\ClsWCFCompanyMessage
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\ClsWCFCompanyMessage
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get UserKey value
     * @return string|null
     */
    public function getUserKey()
    {
        return $this->UserKey;
    }
    /**
     * Set UserKey value
     * @param string $userKey
     * @return \StructType\ClsWCFCompanyMessage
     */
    public function setUserKey($userKey = null)
    {
        // validation for constraint: string
        if (!is_null($userKey) && !is_string($userKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userKey, true), gettype($userKey)), __LINE__);
        }
        $this->UserKey = $userKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFCompanyMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
