<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFCalibrationEntry StructType
 * @subpackage Structs
 */
class ClsWCFCalibrationEntry extends AbstractStructBase
{
    /**
     * The SurveyorSignatureDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SurveyorSignatureDateTime;
    /**
     * The SiteSignatureDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SiteSignatureDateTime;
    /**
     * The ContractorsSame
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractorsSame;
    /**
     * The HubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSurveyID;
    /**
     * The CalibrationNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CalibrationNo;
    /**
     * The EMails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClsWCFEmailEntry
     */
    public $EMails;
    /**
     * The SupervisorName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupervisorName;
    /**
     * The ContractorsName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractorsName;
    /**
     * The ContractorsAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractorsAddress;
    /**
     * The ContractorsContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractorsContact;
    /**
     * The MethodStatement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MethodStatement;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The AirPressure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirPressure;
    /**
     * The Temperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Temperature;
    /**
     * The SuitabilityCheck
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SuitabilityCheck;
    /**
     * The LabLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabLocation;
    /**
     * The Barometer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barometer;
    /**
     * The Thermometer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Thermometer;
    /**
     * The TimePiece
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimePiece;
    /**
     * The VisibleTestBeads
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VisibleTestBeads;
    /**
     * The GraticuleDiameter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GraticuleDiameter;
    /**
     * The ORingDiameter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ORingDiameter;
    /**
     * The HSENPLTestSlide
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HSENPLTestSlide;
    /**
     * The Micrometers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Micrometers;
    /**
     * The FlowMeters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlowMeters;
    /**
     * The Microscope
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Microscope;
    /**
     * Constructor method for clsWCFCalibrationEntry
     * @uses ClsWCFCalibrationEntry::setSurveyorSignatureDateTime()
     * @uses ClsWCFCalibrationEntry::setSiteSignatureDateTime()
     * @uses ClsWCFCalibrationEntry::setContractorsSame()
     * @uses ClsWCFCalibrationEntry::setHubSurveyID()
     * @uses ClsWCFCalibrationEntry::setCalibrationNo()
     * @uses ClsWCFCalibrationEntry::setEMails()
     * @uses ClsWCFCalibrationEntry::setSupervisorName()
     * @uses ClsWCFCalibrationEntry::setContractorsName()
     * @uses ClsWCFCalibrationEntry::setContractorsAddress()
     * @uses ClsWCFCalibrationEntry::setContractorsContact()
     * @uses ClsWCFCalibrationEntry::setMethodStatement()
     * @uses ClsWCFCalibrationEntry::setStartDate()
     * @uses ClsWCFCalibrationEntry::setEndDate()
     * @uses ClsWCFCalibrationEntry::setAirPressure()
     * @uses ClsWCFCalibrationEntry::setTemperature()
     * @uses ClsWCFCalibrationEntry::setSuitabilityCheck()
     * @uses ClsWCFCalibrationEntry::setLabLocation()
     * @uses ClsWCFCalibrationEntry::setBarometer()
     * @uses ClsWCFCalibrationEntry::setThermometer()
     * @uses ClsWCFCalibrationEntry::setTimePiece()
     * @uses ClsWCFCalibrationEntry::setVisibleTestBeads()
     * @uses ClsWCFCalibrationEntry::setGraticuleDiameter()
     * @uses ClsWCFCalibrationEntry::setORingDiameter()
     * @uses ClsWCFCalibrationEntry::setHSENPLTestSlide()
     * @uses ClsWCFCalibrationEntry::setMicrometers()
     * @uses ClsWCFCalibrationEntry::setFlowMeters()
     * @uses ClsWCFCalibrationEntry::setMicroscope()
     * @param string $surveyorSignatureDateTime
     * @param string $siteSignatureDateTime
     * @param int $contractorsSame
     * @param int $hubSurveyID
     * @param int $calibrationNo
     * @param \ArrayType\ArrayOfClsWCFEmailEntry $eMails
     * @param string $supervisorName
     * @param string $contractorsName
     * @param string $contractorsAddress
     * @param string $contractorsContact
     * @param string $methodStatement
     * @param string $startDate
     * @param string $endDate
     * @param string $airPressure
     * @param string $temperature
     * @param string $suitabilityCheck
     * @param string $labLocation
     * @param string $barometer
     * @param string $thermometer
     * @param string $timePiece
     * @param string $visibleTestBeads
     * @param string $graticuleDiameter
     * @param string $oRingDiameter
     * @param string $hSENPLTestSlide
     * @param string $micrometers
     * @param string $flowMeters
     * @param string $microscope
     */
    public function __construct($surveyorSignatureDateTime = null, $siteSignatureDateTime = null, $contractorsSame = null, $hubSurveyID = null, $calibrationNo = null, \ArrayType\ArrayOfClsWCFEmailEntry $eMails = null, $supervisorName = null, $contractorsName = null, $contractorsAddress = null, $contractorsContact = null, $methodStatement = null, $startDate = null, $endDate = null, $airPressure = null, $temperature = null, $suitabilityCheck = null, $labLocation = null, $barometer = null, $thermometer = null, $timePiece = null, $visibleTestBeads = null, $graticuleDiameter = null, $oRingDiameter = null, $hSENPLTestSlide = null, $micrometers = null, $flowMeters = null, $microscope = null)
    {
        $this
            ->setSurveyorSignatureDateTime($surveyorSignatureDateTime)
            ->setSiteSignatureDateTime($siteSignatureDateTime)
            ->setContractorsSame($contractorsSame)
            ->setHubSurveyID($hubSurveyID)
            ->setCalibrationNo($calibrationNo)
            ->setEMails($eMails)
            ->setSupervisorName($supervisorName)
            ->setContractorsName($contractorsName)
            ->setContractorsAddress($contractorsAddress)
            ->setContractorsContact($contractorsContact)
            ->setMethodStatement($methodStatement)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setAirPressure($airPressure)
            ->setTemperature($temperature)
            ->setSuitabilityCheck($suitabilityCheck)
            ->setLabLocation($labLocation)
            ->setBarometer($barometer)
            ->setThermometer($thermometer)
            ->setTimePiece($timePiece)
            ->setVisibleTestBeads($visibleTestBeads)
            ->setGraticuleDiameter($graticuleDiameter)
            ->setORingDiameter($oRingDiameter)
            ->setHSENPLTestSlide($hSENPLTestSlide)
            ->setMicrometers($micrometers)
            ->setFlowMeters($flowMeters)
            ->setMicroscope($microscope);
    }
    /**
     * Get SurveyorSignatureDateTime value
     * @return string
     */
    public function getSurveyorSignatureDateTime()
    {
        return $this->SurveyorSignatureDateTime;
    }
    /**
     * Set SurveyorSignatureDateTime value
     * @param string $surveyorSignatureDateTime
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setSurveyorSignatureDateTime($surveyorSignatureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($surveyorSignatureDateTime) && !is_string($surveyorSignatureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyorSignatureDateTime, true), gettype($surveyorSignatureDateTime)), __LINE__);
        }
        $this->SurveyorSignatureDateTime = $surveyorSignatureDateTime;
        return $this;
    }
    /**
     * Get SiteSignatureDateTime value
     * @return string
     */
    public function getSiteSignatureDateTime()
    {
        return $this->SiteSignatureDateTime;
    }
    /**
     * Set SiteSignatureDateTime value
     * @param string $siteSignatureDateTime
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setSiteSignatureDateTime($siteSignatureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($siteSignatureDateTime) && !is_string($siteSignatureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteSignatureDateTime, true), gettype($siteSignatureDateTime)), __LINE__);
        }
        $this->SiteSignatureDateTime = $siteSignatureDateTime;
        return $this;
    }
    /**
     * Get ContractorsSame value
     * @return int
     */
    public function getContractorsSame()
    {
        return $this->ContractorsSame;
    }
    /**
     * Set ContractorsSame value
     * @param int $contractorsSame
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setContractorsSame($contractorsSame = null)
    {
        // validation for constraint: int
        if (!is_null($contractorsSame) && !(is_int($contractorsSame) || ctype_digit($contractorsSame))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contractorsSame, true), gettype($contractorsSame)), __LINE__);
        }
        $this->ContractorsSame = $contractorsSame;
        return $this;
    }
    /**
     * Get HubSurveyID value
     * @return int
     */
    public function getHubSurveyID()
    {
        return $this->HubSurveyID;
    }
    /**
     * Set HubSurveyID value
     * @param int $hubSurveyID
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setHubSurveyID($hubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSurveyID) && !(is_int($hubSurveyID) || ctype_digit($hubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSurveyID, true), gettype($hubSurveyID)), __LINE__);
        }
        $this->HubSurveyID = $hubSurveyID;
        return $this;
    }
    /**
     * Get CalibrationNo value
     * @return int
     */
    public function getCalibrationNo()
    {
        return $this->CalibrationNo;
    }
    /**
     * Set CalibrationNo value
     * @param int $calibrationNo
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setCalibrationNo($calibrationNo = null)
    {
        // validation for constraint: int
        if (!is_null($calibrationNo) && !(is_int($calibrationNo) || ctype_digit($calibrationNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($calibrationNo, true), gettype($calibrationNo)), __LINE__);
        }
        $this->CalibrationNo = $calibrationNo;
        return $this;
    }
    /**
     * Get EMails value
     * @return \ArrayType\ArrayOfClsWCFEmailEntry|null
     */
    public function getEMails()
    {
        return $this->EMails;
    }
    /**
     * Set EMails value
     * @param \ArrayType\ArrayOfClsWCFEmailEntry $eMails
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setEMails(\ArrayType\ArrayOfClsWCFEmailEntry $eMails = null)
    {
        $this->EMails = $eMails;
        return $this;
    }
    /**
     * Get SupervisorName value
     * @return string|null
     */
    public function getSupervisorName()
    {
        return $this->SupervisorName;
    }
    /**
     * Set SupervisorName value
     * @param string $supervisorName
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setSupervisorName($supervisorName = null)
    {
        // validation for constraint: string
        if (!is_null($supervisorName) && !is_string($supervisorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supervisorName, true), gettype($supervisorName)), __LINE__);
        }
        $this->SupervisorName = $supervisorName;
        return $this;
    }
    /**
     * Get ContractorsName value
     * @return string|null
     */
    public function getContractorsName()
    {
        return $this->ContractorsName;
    }
    /**
     * Set ContractorsName value
     * @param string $contractorsName
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setContractorsName($contractorsName = null)
    {
        // validation for constraint: string
        if (!is_null($contractorsName) && !is_string($contractorsName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractorsName, true), gettype($contractorsName)), __LINE__);
        }
        $this->ContractorsName = $contractorsName;
        return $this;
    }
    /**
     * Get ContractorsAddress value
     * @return string|null
     */
    public function getContractorsAddress()
    {
        return $this->ContractorsAddress;
    }
    /**
     * Set ContractorsAddress value
     * @param string $contractorsAddress
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setContractorsAddress($contractorsAddress = null)
    {
        // validation for constraint: string
        if (!is_null($contractorsAddress) && !is_string($contractorsAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractorsAddress, true), gettype($contractorsAddress)), __LINE__);
        }
        $this->ContractorsAddress = $contractorsAddress;
        return $this;
    }
    /**
     * Get ContractorsContact value
     * @return string|null
     */
    public function getContractorsContact()
    {
        return $this->ContractorsContact;
    }
    /**
     * Set ContractorsContact value
     * @param string $contractorsContact
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setContractorsContact($contractorsContact = null)
    {
        // validation for constraint: string
        if (!is_null($contractorsContact) && !is_string($contractorsContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractorsContact, true), gettype($contractorsContact)), __LINE__);
        }
        $this->ContractorsContact = $contractorsContact;
        return $this;
    }
    /**
     * Get MethodStatement value
     * @return string|null
     */
    public function getMethodStatement()
    {
        return $this->MethodStatement;
    }
    /**
     * Set MethodStatement value
     * @param string $methodStatement
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setMethodStatement($methodStatement = null)
    {
        // validation for constraint: string
        if (!is_null($methodStatement) && !is_string($methodStatement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodStatement, true), gettype($methodStatement)), __LINE__);
        }
        $this->MethodStatement = $methodStatement;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get AirPressure value
     * @return string|null
     */
    public function getAirPressure()
    {
        return $this->AirPressure;
    }
    /**
     * Set AirPressure value
     * @param string $airPressure
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setAirPressure($airPressure = null)
    {
        // validation for constraint: string
        if (!is_null($airPressure) && !is_string($airPressure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airPressure, true), gettype($airPressure)), __LINE__);
        }
        $this->AirPressure = $airPressure;
        return $this;
    }
    /**
     * Get Temperature value
     * @return string|null
     */
    public function getTemperature()
    {
        return $this->Temperature;
    }
    /**
     * Set Temperature value
     * @param string $temperature
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setTemperature($temperature = null)
    {
        // validation for constraint: string
        if (!is_null($temperature) && !is_string($temperature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temperature, true), gettype($temperature)), __LINE__);
        }
        $this->Temperature = $temperature;
        return $this;
    }
    /**
     * Get SuitabilityCheck value
     * @return string|null
     */
    public function getSuitabilityCheck()
    {
        return $this->SuitabilityCheck;
    }
    /**
     * Set SuitabilityCheck value
     * @param string $suitabilityCheck
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setSuitabilityCheck($suitabilityCheck = null)
    {
        // validation for constraint: string
        if (!is_null($suitabilityCheck) && !is_string($suitabilityCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suitabilityCheck, true), gettype($suitabilityCheck)), __LINE__);
        }
        $this->SuitabilityCheck = $suitabilityCheck;
        return $this;
    }
    /**
     * Get LabLocation value
     * @return string|null
     */
    public function getLabLocation()
    {
        return $this->LabLocation;
    }
    /**
     * Set LabLocation value
     * @param string $labLocation
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setLabLocation($labLocation = null)
    {
        // validation for constraint: string
        if (!is_null($labLocation) && !is_string($labLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labLocation, true), gettype($labLocation)), __LINE__);
        }
        $this->LabLocation = $labLocation;
        return $this;
    }
    /**
     * Get Barometer value
     * @return string|null
     */
    public function getBarometer()
    {
        return $this->Barometer;
    }
    /**
     * Set Barometer value
     * @param string $barometer
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setBarometer($barometer = null)
    {
        // validation for constraint: string
        if (!is_null($barometer) && !is_string($barometer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barometer, true), gettype($barometer)), __LINE__);
        }
        $this->Barometer = $barometer;
        return $this;
    }
    /**
     * Get Thermometer value
     * @return string|null
     */
    public function getThermometer()
    {
        return $this->Thermometer;
    }
    /**
     * Set Thermometer value
     * @param string $thermometer
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setThermometer($thermometer = null)
    {
        // validation for constraint: string
        if (!is_null($thermometer) && !is_string($thermometer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thermometer, true), gettype($thermometer)), __LINE__);
        }
        $this->Thermometer = $thermometer;
        return $this;
    }
    /**
     * Get TimePiece value
     * @return string|null
     */
    public function getTimePiece()
    {
        return $this->TimePiece;
    }
    /**
     * Set TimePiece value
     * @param string $timePiece
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setTimePiece($timePiece = null)
    {
        // validation for constraint: string
        if (!is_null($timePiece) && !is_string($timePiece)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timePiece, true), gettype($timePiece)), __LINE__);
        }
        $this->TimePiece = $timePiece;
        return $this;
    }
    /**
     * Get VisibleTestBeads value
     * @return string|null
     */
    public function getVisibleTestBeads()
    {
        return $this->VisibleTestBeads;
    }
    /**
     * Set VisibleTestBeads value
     * @param string $visibleTestBeads
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setVisibleTestBeads($visibleTestBeads = null)
    {
        // validation for constraint: string
        if (!is_null($visibleTestBeads) && !is_string($visibleTestBeads)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visibleTestBeads, true), gettype($visibleTestBeads)), __LINE__);
        }
        $this->VisibleTestBeads = $visibleTestBeads;
        return $this;
    }
    /**
     * Get GraticuleDiameter value
     * @return string|null
     */
    public function getGraticuleDiameter()
    {
        return $this->GraticuleDiameter;
    }
    /**
     * Set GraticuleDiameter value
     * @param string $graticuleDiameter
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setGraticuleDiameter($graticuleDiameter = null)
    {
        // validation for constraint: string
        if (!is_null($graticuleDiameter) && !is_string($graticuleDiameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graticuleDiameter, true), gettype($graticuleDiameter)), __LINE__);
        }
        $this->GraticuleDiameter = $graticuleDiameter;
        return $this;
    }
    /**
     * Get ORingDiameter value
     * @return string|null
     */
    public function getORingDiameter()
    {
        return $this->ORingDiameter;
    }
    /**
     * Set ORingDiameter value
     * @param string $oRingDiameter
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setORingDiameter($oRingDiameter = null)
    {
        // validation for constraint: string
        if (!is_null($oRingDiameter) && !is_string($oRingDiameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRingDiameter, true), gettype($oRingDiameter)), __LINE__);
        }
        $this->ORingDiameter = $oRingDiameter;
        return $this;
    }
    /**
     * Get HSENPLTestSlide value
     * @return string|null
     */
    public function getHSENPLTestSlide()
    {
        return $this->HSENPLTestSlide;
    }
    /**
     * Set HSENPLTestSlide value
     * @param string $hSENPLTestSlide
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setHSENPLTestSlide($hSENPLTestSlide = null)
    {
        // validation for constraint: string
        if (!is_null($hSENPLTestSlide) && !is_string($hSENPLTestSlide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hSENPLTestSlide, true), gettype($hSENPLTestSlide)), __LINE__);
        }
        $this->HSENPLTestSlide = $hSENPLTestSlide;
        return $this;
    }
    /**
     * Get Micrometers value
     * @return string|null
     */
    public function getMicrometers()
    {
        return $this->Micrometers;
    }
    /**
     * Set Micrometers value
     * @param string $micrometers
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setMicrometers($micrometers = null)
    {
        // validation for constraint: string
        if (!is_null($micrometers) && !is_string($micrometers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($micrometers, true), gettype($micrometers)), __LINE__);
        }
        $this->Micrometers = $micrometers;
        return $this;
    }
    /**
     * Get FlowMeters value
     * @return string|null
     */
    public function getFlowMeters()
    {
        return $this->FlowMeters;
    }
    /**
     * Set FlowMeters value
     * @param string $flowMeters
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setFlowMeters($flowMeters = null)
    {
        // validation for constraint: string
        if (!is_null($flowMeters) && !is_string($flowMeters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flowMeters, true), gettype($flowMeters)), __LINE__);
        }
        $this->FlowMeters = $flowMeters;
        return $this;
    }
    /**
     * Get Microscope value
     * @return string|null
     */
    public function getMicroscope()
    {
        return $this->Microscope;
    }
    /**
     * Set Microscope value
     * @param string $microscope
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public function setMicroscope($microscope = null)
    {
        // validation for constraint: string
        if (!is_null($microscope) && !is_string($microscope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($microscope, true), gettype($microscope)), __LINE__);
        }
        $this->Microscope = $microscope;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFCalibrationEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
