<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFAssetAnswer StructType
 * @subpackage Structs
 */
class ClsWCFAssetAnswer extends AbstractStructBase
{
    /**
     * The AssetReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AssetReferenceNumber;
    /**
     * The HubQuestionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubQuestionID;
    /**
     * The HubSelectionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSelectionID;
    /**
     * The AnswerText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnswerText;
    /**
     * Constructor method for clsWCFAssetAnswer
     * @uses ClsWCFAssetAnswer::setAssetReferenceNumber()
     * @uses ClsWCFAssetAnswer::setHubQuestionID()
     * @uses ClsWCFAssetAnswer::setHubSelectionID()
     * @uses ClsWCFAssetAnswer::setAnswerText()
     * @param int $assetReferenceNumber
     * @param int $hubQuestionID
     * @param int $hubSelectionID
     * @param string $answerText
     */
    public function __construct($assetReferenceNumber = null, $hubQuestionID = null, $hubSelectionID = null, $answerText = null)
    {
        $this
            ->setAssetReferenceNumber($assetReferenceNumber)
            ->setHubQuestionID($hubQuestionID)
            ->setHubSelectionID($hubSelectionID)
            ->setAnswerText($answerText);
    }
    /**
     * Get AssetReferenceNumber value
     * @return int
     */
    public function getAssetReferenceNumber()
    {
        return $this->AssetReferenceNumber;
    }
    /**
     * Set AssetReferenceNumber value
     * @param int $assetReferenceNumber
     * @return \StructType\ClsWCFAssetAnswer
     */
    public function setAssetReferenceNumber($assetReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($assetReferenceNumber) && !(is_int($assetReferenceNumber) || ctype_digit($assetReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($assetReferenceNumber, true), gettype($assetReferenceNumber)), __LINE__);
        }
        $this->AssetReferenceNumber = $assetReferenceNumber;
        return $this;
    }
    /**
     * Get HubQuestionID value
     * @return int
     */
    public function getHubQuestionID()
    {
        return $this->HubQuestionID;
    }
    /**
     * Set HubQuestionID value
     * @param int $hubQuestionID
     * @return \StructType\ClsWCFAssetAnswer
     */
    public function setHubQuestionID($hubQuestionID = null)
    {
        // validation for constraint: int
        if (!is_null($hubQuestionID) && !(is_int($hubQuestionID) || ctype_digit($hubQuestionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubQuestionID, true), gettype($hubQuestionID)), __LINE__);
        }
        $this->HubQuestionID = $hubQuestionID;
        return $this;
    }
    /**
     * Get HubSelectionID value
     * @return int
     */
    public function getHubSelectionID()
    {
        return $this->HubSelectionID;
    }
    /**
     * Set HubSelectionID value
     * @param int $hubSelectionID
     * @return \StructType\ClsWCFAssetAnswer
     */
    public function setHubSelectionID($hubSelectionID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSelectionID) && !(is_int($hubSelectionID) || ctype_digit($hubSelectionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSelectionID, true), gettype($hubSelectionID)), __LINE__);
        }
        $this->HubSelectionID = $hubSelectionID;
        return $this;
    }
    /**
     * Get AnswerText value
     * @return string|null
     */
    public function getAnswerText()
    {
        return $this->AnswerText;
    }
    /**
     * Set AnswerText value
     * @param string $answerText
     * @return \StructType\ClsWCFAssetAnswer
     */
    public function setAnswerText($answerText = null)
    {
        // validation for constraint: string
        if (!is_null($answerText) && !is_string($answerText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answerText, true), gettype($answerText)), __LINE__);
        }
        $this->AnswerText = $answerText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFAssetAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
