<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFAsset StructType
 * @subpackage Structs
 */
class ClsWCFAsset extends AbstractStructBase
{
    /**
     * The HubSampleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSampleID;
    /**
     * The HubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSurveyID;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The HubWaterSystemTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubWaterSystemTypeID;
    /**
     * The HubAssetTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubAssetTypeID;
    /**
     * The PhoneAssetID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PhoneAssetID;
    /**
     * The NoOfPhotos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NoOfPhotos;
    /**
     * The BuildingDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingDescription;
    /**
     * The FloorDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FloorDescription;
    /**
     * The RoomDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomDescription;
    /**
     * The PositionDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PositionDescription;
    /**
     * The AssetRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AssetRef;
    /**
     * Constructor method for clsWCFAsset
     * @uses ClsWCFAsset::setHubSampleID()
     * @uses ClsWCFAsset::setHubSurveyID()
     * @uses ClsWCFAsset::setReferenceNumber()
     * @uses ClsWCFAsset::setHubWaterSystemTypeID()
     * @uses ClsWCFAsset::setHubAssetTypeID()
     * @uses ClsWCFAsset::setPhoneAssetID()
     * @uses ClsWCFAsset::setNoOfPhotos()
     * @uses ClsWCFAsset::setBuildingDescription()
     * @uses ClsWCFAsset::setFloorDescription()
     * @uses ClsWCFAsset::setRoomDescription()
     * @uses ClsWCFAsset::setPositionDescription()
     * @uses ClsWCFAsset::setAssetRef()
     * @param int $hubSampleID
     * @param int $hubSurveyID
     * @param int $referenceNumber
     * @param int $hubWaterSystemTypeID
     * @param int $hubAssetTypeID
     * @param int $phoneAssetID
     * @param int $noOfPhotos
     * @param string $buildingDescription
     * @param string $floorDescription
     * @param string $roomDescription
     * @param string $positionDescription
     * @param string $assetRef
     */
    public function __construct($hubSampleID = null, $hubSurveyID = null, $referenceNumber = null, $hubWaterSystemTypeID = null, $hubAssetTypeID = null, $phoneAssetID = null, $noOfPhotos = null, $buildingDescription = null, $floorDescription = null, $roomDescription = null, $positionDescription = null, $assetRef = null)
    {
        $this
            ->setHubSampleID($hubSampleID)
            ->setHubSurveyID($hubSurveyID)
            ->setReferenceNumber($referenceNumber)
            ->setHubWaterSystemTypeID($hubWaterSystemTypeID)
            ->setHubAssetTypeID($hubAssetTypeID)
            ->setPhoneAssetID($phoneAssetID)
            ->setNoOfPhotos($noOfPhotos)
            ->setBuildingDescription($buildingDescription)
            ->setFloorDescription($floorDescription)
            ->setRoomDescription($roomDescription)
            ->setPositionDescription($positionDescription)
            ->setAssetRef($assetRef);
    }
    /**
     * Get HubSampleID value
     * @return int
     */
    public function getHubSampleID()
    {
        return $this->HubSampleID;
    }
    /**
     * Set HubSampleID value
     * @param int $hubSampleID
     * @return \StructType\ClsWCFAsset
     */
    public function setHubSampleID($hubSampleID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSampleID) && !(is_int($hubSampleID) || ctype_digit($hubSampleID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSampleID, true), gettype($hubSampleID)), __LINE__);
        }
        $this->HubSampleID = $hubSampleID;
        return $this;
    }
    /**
     * Get HubSurveyID value
     * @return int
     */
    public function getHubSurveyID()
    {
        return $this->HubSurveyID;
    }
    /**
     * Set HubSurveyID value
     * @param int $hubSurveyID
     * @return \StructType\ClsWCFAsset
     */
    public function setHubSurveyID($hubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSurveyID) && !(is_int($hubSurveyID) || ctype_digit($hubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSurveyID, true), gettype($hubSurveyID)), __LINE__);
        }
        $this->HubSurveyID = $hubSurveyID;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return int
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \StructType\ClsWCFAsset
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get HubWaterSystemTypeID value
     * @return int
     */
    public function getHubWaterSystemTypeID()
    {
        return $this->HubWaterSystemTypeID;
    }
    /**
     * Set HubWaterSystemTypeID value
     * @param int $hubWaterSystemTypeID
     * @return \StructType\ClsWCFAsset
     */
    public function setHubWaterSystemTypeID($hubWaterSystemTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($hubWaterSystemTypeID) && !(is_int($hubWaterSystemTypeID) || ctype_digit($hubWaterSystemTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubWaterSystemTypeID, true), gettype($hubWaterSystemTypeID)), __LINE__);
        }
        $this->HubWaterSystemTypeID = $hubWaterSystemTypeID;
        return $this;
    }
    /**
     * Get HubAssetTypeID value
     * @return int
     */
    public function getHubAssetTypeID()
    {
        return $this->HubAssetTypeID;
    }
    /**
     * Set HubAssetTypeID value
     * @param int $hubAssetTypeID
     * @return \StructType\ClsWCFAsset
     */
    public function setHubAssetTypeID($hubAssetTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($hubAssetTypeID) && !(is_int($hubAssetTypeID) || ctype_digit($hubAssetTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubAssetTypeID, true), gettype($hubAssetTypeID)), __LINE__);
        }
        $this->HubAssetTypeID = $hubAssetTypeID;
        return $this;
    }
    /**
     * Get PhoneAssetID value
     * @return int
     */
    public function getPhoneAssetID()
    {
        return $this->PhoneAssetID;
    }
    /**
     * Set PhoneAssetID value
     * @param int $phoneAssetID
     * @return \StructType\ClsWCFAsset
     */
    public function setPhoneAssetID($phoneAssetID = null)
    {
        // validation for constraint: int
        if (!is_null($phoneAssetID) && !(is_int($phoneAssetID) || ctype_digit($phoneAssetID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($phoneAssetID, true), gettype($phoneAssetID)), __LINE__);
        }
        $this->PhoneAssetID = $phoneAssetID;
        return $this;
    }
    /**
     * Get NoOfPhotos value
     * @return int
     */
    public function getNoOfPhotos()
    {
        return $this->NoOfPhotos;
    }
    /**
     * Set NoOfPhotos value
     * @param int $noOfPhotos
     * @return \StructType\ClsWCFAsset
     */
    public function setNoOfPhotos($noOfPhotos = null)
    {
        // validation for constraint: int
        if (!is_null($noOfPhotos) && !(is_int($noOfPhotos) || ctype_digit($noOfPhotos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($noOfPhotos, true), gettype($noOfPhotos)), __LINE__);
        }
        $this->NoOfPhotos = $noOfPhotos;
        return $this;
    }
    /**
     * Get BuildingDescription value
     * @return string|null
     */
    public function getBuildingDescription()
    {
        return $this->BuildingDescription;
    }
    /**
     * Set BuildingDescription value
     * @param string $buildingDescription
     * @return \StructType\ClsWCFAsset
     */
    public function setBuildingDescription($buildingDescription = null)
    {
        // validation for constraint: string
        if (!is_null($buildingDescription) && !is_string($buildingDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingDescription, true), gettype($buildingDescription)), __LINE__);
        }
        $this->BuildingDescription = $buildingDescription;
        return $this;
    }
    /**
     * Get FloorDescription value
     * @return string|null
     */
    public function getFloorDescription()
    {
        return $this->FloorDescription;
    }
    /**
     * Set FloorDescription value
     * @param string $floorDescription
     * @return \StructType\ClsWCFAsset
     */
    public function setFloorDescription($floorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($floorDescription) && !is_string($floorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floorDescription, true), gettype($floorDescription)), __LINE__);
        }
        $this->FloorDescription = $floorDescription;
        return $this;
    }
    /**
     * Get RoomDescription value
     * @return string|null
     */
    public function getRoomDescription()
    {
        return $this->RoomDescription;
    }
    /**
     * Set RoomDescription value
     * @param string $roomDescription
     * @return \StructType\ClsWCFAsset
     */
    public function setRoomDescription($roomDescription = null)
    {
        // validation for constraint: string
        if (!is_null($roomDescription) && !is_string($roomDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomDescription, true), gettype($roomDescription)), __LINE__);
        }
        $this->RoomDescription = $roomDescription;
        return $this;
    }
    /**
     * Get PositionDescription value
     * @return string|null
     */
    public function getPositionDescription()
    {
        return $this->PositionDescription;
    }
    /**
     * Set PositionDescription value
     * @param string $positionDescription
     * @return \StructType\ClsWCFAsset
     */
    public function setPositionDescription($positionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($positionDescription) && !is_string($positionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionDescription, true), gettype($positionDescription)), __LINE__);
        }
        $this->PositionDescription = $positionDescription;
        return $this;
    }
    /**
     * Get AssetRef value
     * @return string|null
     */
    public function getAssetRef()
    {
        return $this->AssetRef;
    }
    /**
     * Set AssetRef value
     * @param string $assetRef
     * @return \StructType\ClsWCFAsset
     */
    public function setAssetRef($assetRef = null)
    {
        // validation for constraint: string
        if (!is_null($assetRef) && !is_string($assetRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assetRef, true), gettype($assetRef)), __LINE__);
        }
        $this->AssetRef = $assetRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFAsset
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
