<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFAnswer StructType
 * @subpackage Structs
 */
class ClsWCFAnswer extends AbstractStructBase
{
    /**
     * The HubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSurveyID;
    /**
     * The HubQuestionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubQuestionID;
    /**
     * The HubSelectionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSelectionID;
    /**
     * The AnswerText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnswerText;
    /**
     * The PhotoFilename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhotoFilename;
    /**
     * Constructor method for clsWCFAnswer
     * @uses ClsWCFAnswer::setHubSurveyID()
     * @uses ClsWCFAnswer::setHubQuestionID()
     * @uses ClsWCFAnswer::setHubSelectionID()
     * @uses ClsWCFAnswer::setAnswerText()
     * @uses ClsWCFAnswer::setPhotoFilename()
     * @param int $hubSurveyID
     * @param int $hubQuestionID
     * @param int $hubSelectionID
     * @param string $answerText
     * @param string $photoFilename
     */
    public function __construct($hubSurveyID = null, $hubQuestionID = null, $hubSelectionID = null, $answerText = null, $photoFilename = null)
    {
        $this
            ->setHubSurveyID($hubSurveyID)
            ->setHubQuestionID($hubQuestionID)
            ->setHubSelectionID($hubSelectionID)
            ->setAnswerText($answerText)
            ->setPhotoFilename($photoFilename);
    }
    /**
     * Get HubSurveyID value
     * @return int
     */
    public function getHubSurveyID()
    {
        return $this->HubSurveyID;
    }
    /**
     * Set HubSurveyID value
     * @param int $hubSurveyID
     * @return \StructType\ClsWCFAnswer
     */
    public function setHubSurveyID($hubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSurveyID) && !(is_int($hubSurveyID) || ctype_digit($hubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSurveyID, true), gettype($hubSurveyID)), __LINE__);
        }
        $this->HubSurveyID = $hubSurveyID;
        return $this;
    }
    /**
     * Get HubQuestionID value
     * @return int
     */
    public function getHubQuestionID()
    {
        return $this->HubQuestionID;
    }
    /**
     * Set HubQuestionID value
     * @param int $hubQuestionID
     * @return \StructType\ClsWCFAnswer
     */
    public function setHubQuestionID($hubQuestionID = null)
    {
        // validation for constraint: int
        if (!is_null($hubQuestionID) && !(is_int($hubQuestionID) || ctype_digit($hubQuestionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubQuestionID, true), gettype($hubQuestionID)), __LINE__);
        }
        $this->HubQuestionID = $hubQuestionID;
        return $this;
    }
    /**
     * Get HubSelectionID value
     * @return int
     */
    public function getHubSelectionID()
    {
        return $this->HubSelectionID;
    }
    /**
     * Set HubSelectionID value
     * @param int $hubSelectionID
     * @return \StructType\ClsWCFAnswer
     */
    public function setHubSelectionID($hubSelectionID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSelectionID) && !(is_int($hubSelectionID) || ctype_digit($hubSelectionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSelectionID, true), gettype($hubSelectionID)), __LINE__);
        }
        $this->HubSelectionID = $hubSelectionID;
        return $this;
    }
    /**
     * Get AnswerText value
     * @return string|null
     */
    public function getAnswerText()
    {
        return $this->AnswerText;
    }
    /**
     * Set AnswerText value
     * @param string $answerText
     * @return \StructType\ClsWCFAnswer
     */
    public function setAnswerText($answerText = null)
    {
        // validation for constraint: string
        if (!is_null($answerText) && !is_string($answerText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answerText, true), gettype($answerText)), __LINE__);
        }
        $this->AnswerText = $answerText;
        return $this;
    }
    /**
     * Get PhotoFilename value
     * @return string|null
     */
    public function getPhotoFilename()
    {
        return $this->PhotoFilename;
    }
    /**
     * Set PhotoFilename value
     * @param string $photoFilename
     * @return \StructType\ClsWCFAnswer
     */
    public function setPhotoFilename($photoFilename = null)
    {
        // validation for constraint: string
        if (!is_null($photoFilename) && !is_string($photoFilename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($photoFilename, true), gettype($photoFilename)), __LINE__);
        }
        $this->PhotoFilename = $photoFilename;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
