<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFAndroidSample StructType
 * @subpackage Structs
 */
class ClsWCFAndroidSample extends AbstractStructBase
{
    /**
     * The HubSampleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSampleID;
    /**
     * The HubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSurveyID;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The OriginalReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OriginalReferenceNumber;
    /**
     * The OldQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OldQty;
    /**
     * The HubUnitID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubUnitID;
    /**
     * The HubMaterialProductTypeFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubMaterialProductTypeFactorID;
    /**
     * The HubMaterialDamageExtentFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubMaterialDamageExtentFactorID;
    /**
     * The HubMaterialSurfaceTreatmentFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubMaterialSurfaceTreatmentFactorID;
    /**
     * The HubMaterialAsbestosTypeFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubMaterialAsbestosTypeFactorID;
    /**
     * The MaterialAccessibilityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MaterialAccessibilityCode;
    /**
     * The HubPriorityActivityPrimaryFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubPriorityActivityPrimaryFactorID;
    /**
     * The HubPriorityActivitySecondaryFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubPriorityActivitySecondaryFactorID;
    /**
     * The HubPriorityDisturbanceLocationFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubPriorityDisturbanceLocationFactorID;
    /**
     * The HubPriorityDisturbanceAccessibilityFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubPriorityDisturbanceAccessibilityFactorID;
    /**
     * The HubPriorityDisturbanceExtentFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubPriorityDisturbanceExtentFactorID;
    /**
     * The HubPriorityHumanOccupancyFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubPriorityHumanOccupancyFactorID;
    /**
     * The HubPriorityHumanFrequencyFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubPriorityHumanFrequencyFactorID;
    /**
     * The HubPriorityHumanTimeFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubPriorityHumanTimeFactorID;
    /**
     * The HubPriorityMaintDisturbanceFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubPriorityMaintDisturbanceFactorID;
    /**
     * The HubPriorityMaintFrequencyFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubPriorityMaintFrequencyFactorID;
    /**
     * The PriorityScore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriorityScore;
    /**
     * The MaterialScore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaterialScore;
    /**
     * The HubLabID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubLabID;
    /**
     * The ProposalWorkArea
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ProposalWorkArea;
    /**
     * The HubNoAccessReasonID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubNoAccessReasonID;
    /**
     * The SampleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SampleID;
    /**
     * The DuplicateOfSampleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DuplicateOfSampleID;
    /**
     * The PhotoFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhotoFileName;
    /**
     * The BuildingDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingDescription;
    /**
     * The BlockNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BlockNumber;
    /**
     * The FloorDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FloorDescription;
    /**
     * The RoomNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomNumber;
    /**
     * The RoomDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoomDescription;
    /**
     * The PositionDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PositionDescription;
    /**
     * The ComponentDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ComponentDescription;
    /**
     * The LabSampleRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabSampleRef;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Qty;
    /**
     * The HashText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HashText;
    /**
     * The MaterialRisk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaterialRisk;
    /**
     * The ActionDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActionDescription;
    /**
     * The NextInspectionDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NextInspectionDescription;
    /**
     * The SurveyorsRecommendation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurveyorsRecommendation;
    /**
     * The PriorityRisk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriorityRisk;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * Constructor method for clsWCFAndroidSample
     * @uses ClsWCFAndroidSample::setHubSampleID()
     * @uses ClsWCFAndroidSample::setHubSurveyID()
     * @uses ClsWCFAndroidSample::setReferenceNumber()
     * @uses ClsWCFAndroidSample::setOriginalReferenceNumber()
     * @uses ClsWCFAndroidSample::setOldQty()
     * @uses ClsWCFAndroidSample::setHubUnitID()
     * @uses ClsWCFAndroidSample::setHubMaterialProductTypeFactorID()
     * @uses ClsWCFAndroidSample::setHubMaterialDamageExtentFactorID()
     * @uses ClsWCFAndroidSample::setHubMaterialSurfaceTreatmentFactorID()
     * @uses ClsWCFAndroidSample::setHubMaterialAsbestosTypeFactorID()
     * @uses ClsWCFAndroidSample::setMaterialAccessibilityCode()
     * @uses ClsWCFAndroidSample::setHubPriorityActivityPrimaryFactorID()
     * @uses ClsWCFAndroidSample::setHubPriorityActivitySecondaryFactorID()
     * @uses ClsWCFAndroidSample::setHubPriorityDisturbanceLocationFactorID()
     * @uses ClsWCFAndroidSample::setHubPriorityDisturbanceAccessibilityFactorID()
     * @uses ClsWCFAndroidSample::setHubPriorityDisturbanceExtentFactorID()
     * @uses ClsWCFAndroidSample::setHubPriorityHumanOccupancyFactorID()
     * @uses ClsWCFAndroidSample::setHubPriorityHumanFrequencyFactorID()
     * @uses ClsWCFAndroidSample::setHubPriorityHumanTimeFactorID()
     * @uses ClsWCFAndroidSample::setHubPriorityMaintDisturbanceFactorID()
     * @uses ClsWCFAndroidSample::setHubPriorityMaintFrequencyFactorID()
     * @uses ClsWCFAndroidSample::setPriorityScore()
     * @uses ClsWCFAndroidSample::setMaterialScore()
     * @uses ClsWCFAndroidSample::setHubLabID()
     * @uses ClsWCFAndroidSample::setProposalWorkArea()
     * @uses ClsWCFAndroidSample::setHubNoAccessReasonID()
     * @uses ClsWCFAndroidSample::setSampleID()
     * @uses ClsWCFAndroidSample::setDuplicateOfSampleID()
     * @uses ClsWCFAndroidSample::setPhotoFileName()
     * @uses ClsWCFAndroidSample::setBuildingDescription()
     * @uses ClsWCFAndroidSample::setBlockNumber()
     * @uses ClsWCFAndroidSample::setFloorDescription()
     * @uses ClsWCFAndroidSample::setRoomNumber()
     * @uses ClsWCFAndroidSample::setRoomDescription()
     * @uses ClsWCFAndroidSample::setPositionDescription()
     * @uses ClsWCFAndroidSample::setComponentDescription()
     * @uses ClsWCFAndroidSample::setLabSampleRef()
     * @uses ClsWCFAndroidSample::setQty()
     * @uses ClsWCFAndroidSample::setHashText()
     * @uses ClsWCFAndroidSample::setMaterialRisk()
     * @uses ClsWCFAndroidSample::setActionDescription()
     * @uses ClsWCFAndroidSample::setNextInspectionDescription()
     * @uses ClsWCFAndroidSample::setSurveyorsRecommendation()
     * @uses ClsWCFAndroidSample::setPriorityRisk()
     * @uses ClsWCFAndroidSample::setComments()
     * @param int $hubSampleID
     * @param int $hubSurveyID
     * @param int $referenceNumber
     * @param int $originalReferenceNumber
     * @param float $oldQty
     * @param int $hubUnitID
     * @param int $hubMaterialProductTypeFactorID
     * @param int $hubMaterialDamageExtentFactorID
     * @param int $hubMaterialSurfaceTreatmentFactorID
     * @param int $hubMaterialAsbestosTypeFactorID
     * @param string $materialAccessibilityCode
     * @param int $hubPriorityActivityPrimaryFactorID
     * @param int $hubPriorityActivitySecondaryFactorID
     * @param int $hubPriorityDisturbanceLocationFactorID
     * @param int $hubPriorityDisturbanceAccessibilityFactorID
     * @param int $hubPriorityDisturbanceExtentFactorID
     * @param int $hubPriorityHumanOccupancyFactorID
     * @param int $hubPriorityHumanFrequencyFactorID
     * @param int $hubPriorityHumanTimeFactorID
     * @param int $hubPriorityMaintDisturbanceFactorID
     * @param int $hubPriorityMaintFrequencyFactorID
     * @param int $priorityScore
     * @param int $materialScore
     * @param int $hubLabID
     * @param bool $proposalWorkArea
     * @param int $hubNoAccessReasonID
     * @param int $sampleID
     * @param int $duplicateOfSampleID
     * @param string $photoFileName
     * @param string $buildingDescription
     * @param string $blockNumber
     * @param string $floorDescription
     * @param string $roomNumber
     * @param string $roomDescription
     * @param string $positionDescription
     * @param string $componentDescription
     * @param string $labSampleRef
     * @param string $qty
     * @param string $hashText
     * @param string $materialRisk
     * @param string $actionDescription
     * @param string $nextInspectionDescription
     * @param string $surveyorsRecommendation
     * @param string $priorityRisk
     * @param string $comments
     */
    public function __construct($hubSampleID = null, $hubSurveyID = null, $referenceNumber = null, $originalReferenceNumber = null, $oldQty = null, $hubUnitID = null, $hubMaterialProductTypeFactorID = null, $hubMaterialDamageExtentFactorID = null, $hubMaterialSurfaceTreatmentFactorID = null, $hubMaterialAsbestosTypeFactorID = null, $materialAccessibilityCode = null, $hubPriorityActivityPrimaryFactorID = null, $hubPriorityActivitySecondaryFactorID = null, $hubPriorityDisturbanceLocationFactorID = null, $hubPriorityDisturbanceAccessibilityFactorID = null, $hubPriorityDisturbanceExtentFactorID = null, $hubPriorityHumanOccupancyFactorID = null, $hubPriorityHumanFrequencyFactorID = null, $hubPriorityHumanTimeFactorID = null, $hubPriorityMaintDisturbanceFactorID = null, $hubPriorityMaintFrequencyFactorID = null, $priorityScore = null, $materialScore = null, $hubLabID = null, $proposalWorkArea = null, $hubNoAccessReasonID = null, $sampleID = null, $duplicateOfSampleID = null, $photoFileName = null, $buildingDescription = null, $blockNumber = null, $floorDescription = null, $roomNumber = null, $roomDescription = null, $positionDescription = null, $componentDescription = null, $labSampleRef = null, $qty = null, $hashText = null, $materialRisk = null, $actionDescription = null, $nextInspectionDescription = null, $surveyorsRecommendation = null, $priorityRisk = null, $comments = null)
    {
        $this
            ->setHubSampleID($hubSampleID)
            ->setHubSurveyID($hubSurveyID)
            ->setReferenceNumber($referenceNumber)
            ->setOriginalReferenceNumber($originalReferenceNumber)
            ->setOldQty($oldQty)
            ->setHubUnitID($hubUnitID)
            ->setHubMaterialProductTypeFactorID($hubMaterialProductTypeFactorID)
            ->setHubMaterialDamageExtentFactorID($hubMaterialDamageExtentFactorID)
            ->setHubMaterialSurfaceTreatmentFactorID($hubMaterialSurfaceTreatmentFactorID)
            ->setHubMaterialAsbestosTypeFactorID($hubMaterialAsbestosTypeFactorID)
            ->setMaterialAccessibilityCode($materialAccessibilityCode)
            ->setHubPriorityActivityPrimaryFactorID($hubPriorityActivityPrimaryFactorID)
            ->setHubPriorityActivitySecondaryFactorID($hubPriorityActivitySecondaryFactorID)
            ->setHubPriorityDisturbanceLocationFactorID($hubPriorityDisturbanceLocationFactorID)
            ->setHubPriorityDisturbanceAccessibilityFactorID($hubPriorityDisturbanceAccessibilityFactorID)
            ->setHubPriorityDisturbanceExtentFactorID($hubPriorityDisturbanceExtentFactorID)
            ->setHubPriorityHumanOccupancyFactorID($hubPriorityHumanOccupancyFactorID)
            ->setHubPriorityHumanFrequencyFactorID($hubPriorityHumanFrequencyFactorID)
            ->setHubPriorityHumanTimeFactorID($hubPriorityHumanTimeFactorID)
            ->setHubPriorityMaintDisturbanceFactorID($hubPriorityMaintDisturbanceFactorID)
            ->setHubPriorityMaintFrequencyFactorID($hubPriorityMaintFrequencyFactorID)
            ->setPriorityScore($priorityScore)
            ->setMaterialScore($materialScore)
            ->setHubLabID($hubLabID)
            ->setProposalWorkArea($proposalWorkArea)
            ->setHubNoAccessReasonID($hubNoAccessReasonID)
            ->setSampleID($sampleID)
            ->setDuplicateOfSampleID($duplicateOfSampleID)
            ->setPhotoFileName($photoFileName)
            ->setBuildingDescription($buildingDescription)
            ->setBlockNumber($blockNumber)
            ->setFloorDescription($floorDescription)
            ->setRoomNumber($roomNumber)
            ->setRoomDescription($roomDescription)
            ->setPositionDescription($positionDescription)
            ->setComponentDescription($componentDescription)
            ->setLabSampleRef($labSampleRef)
            ->setQty($qty)
            ->setHashText($hashText)
            ->setMaterialRisk($materialRisk)
            ->setActionDescription($actionDescription)
            ->setNextInspectionDescription($nextInspectionDescription)
            ->setSurveyorsRecommendation($surveyorsRecommendation)
            ->setPriorityRisk($priorityRisk)
            ->setComments($comments);
    }
    /**
     * Get HubSampleID value
     * @return int
     */
    public function getHubSampleID()
    {
        return $this->HubSampleID;
    }
    /**
     * Set HubSampleID value
     * @param int $hubSampleID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubSampleID($hubSampleID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSampleID) && !(is_int($hubSampleID) || ctype_digit($hubSampleID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSampleID, true), gettype($hubSampleID)), __LINE__);
        }
        $this->HubSampleID = $hubSampleID;
        return $this;
    }
    /**
     * Get HubSurveyID value
     * @return int
     */
    public function getHubSurveyID()
    {
        return $this->HubSurveyID;
    }
    /**
     * Set HubSurveyID value
     * @param int $hubSurveyID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubSurveyID($hubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSurveyID) && !(is_int($hubSurveyID) || ctype_digit($hubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSurveyID, true), gettype($hubSurveyID)), __LINE__);
        }
        $this->HubSurveyID = $hubSurveyID;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return int
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get OriginalReferenceNumber value
     * @return int
     */
    public function getOriginalReferenceNumber()
    {
        return $this->OriginalReferenceNumber;
    }
    /**
     * Set OriginalReferenceNumber value
     * @param int $originalReferenceNumber
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setOriginalReferenceNumber($originalReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($originalReferenceNumber) && !(is_int($originalReferenceNumber) || ctype_digit($originalReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalReferenceNumber, true), gettype($originalReferenceNumber)), __LINE__);
        }
        $this->OriginalReferenceNumber = $originalReferenceNumber;
        return $this;
    }
    /**
     * Get OldQty value
     * @return float
     */
    public function getOldQty()
    {
        return $this->OldQty;
    }
    /**
     * Set OldQty value
     * @param float $oldQty
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setOldQty($oldQty = null)
    {
        // validation for constraint: float
        if (!is_null($oldQty) && !(is_float($oldQty) || is_numeric($oldQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oldQty, true), gettype($oldQty)), __LINE__);
        }
        $this->OldQty = $oldQty;
        return $this;
    }
    /**
     * Get HubUnitID value
     * @return int
     */
    public function getHubUnitID()
    {
        return $this->HubUnitID;
    }
    /**
     * Set HubUnitID value
     * @param int $hubUnitID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubUnitID($hubUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($hubUnitID) && !(is_int($hubUnitID) || ctype_digit($hubUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubUnitID, true), gettype($hubUnitID)), __LINE__);
        }
        $this->HubUnitID = $hubUnitID;
        return $this;
    }
    /**
     * Get HubMaterialProductTypeFactorID value
     * @return int
     */
    public function getHubMaterialProductTypeFactorID()
    {
        return $this->HubMaterialProductTypeFactorID;
    }
    /**
     * Set HubMaterialProductTypeFactorID value
     * @param int $hubMaterialProductTypeFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubMaterialProductTypeFactorID($hubMaterialProductTypeFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubMaterialProductTypeFactorID) && !(is_int($hubMaterialProductTypeFactorID) || ctype_digit($hubMaterialProductTypeFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubMaterialProductTypeFactorID, true), gettype($hubMaterialProductTypeFactorID)), __LINE__);
        }
        $this->HubMaterialProductTypeFactorID = $hubMaterialProductTypeFactorID;
        return $this;
    }
    /**
     * Get HubMaterialDamageExtentFactorID value
     * @return int
     */
    public function getHubMaterialDamageExtentFactorID()
    {
        return $this->HubMaterialDamageExtentFactorID;
    }
    /**
     * Set HubMaterialDamageExtentFactorID value
     * @param int $hubMaterialDamageExtentFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubMaterialDamageExtentFactorID($hubMaterialDamageExtentFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubMaterialDamageExtentFactorID) && !(is_int($hubMaterialDamageExtentFactorID) || ctype_digit($hubMaterialDamageExtentFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubMaterialDamageExtentFactorID, true), gettype($hubMaterialDamageExtentFactorID)), __LINE__);
        }
        $this->HubMaterialDamageExtentFactorID = $hubMaterialDamageExtentFactorID;
        return $this;
    }
    /**
     * Get HubMaterialSurfaceTreatmentFactorID value
     * @return int
     */
    public function getHubMaterialSurfaceTreatmentFactorID()
    {
        return $this->HubMaterialSurfaceTreatmentFactorID;
    }
    /**
     * Set HubMaterialSurfaceTreatmentFactorID value
     * @param int $hubMaterialSurfaceTreatmentFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubMaterialSurfaceTreatmentFactorID($hubMaterialSurfaceTreatmentFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubMaterialSurfaceTreatmentFactorID) && !(is_int($hubMaterialSurfaceTreatmentFactorID) || ctype_digit($hubMaterialSurfaceTreatmentFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubMaterialSurfaceTreatmentFactorID, true), gettype($hubMaterialSurfaceTreatmentFactorID)), __LINE__);
        }
        $this->HubMaterialSurfaceTreatmentFactorID = $hubMaterialSurfaceTreatmentFactorID;
        return $this;
    }
    /**
     * Get HubMaterialAsbestosTypeFactorID value
     * @return int
     */
    public function getHubMaterialAsbestosTypeFactorID()
    {
        return $this->HubMaterialAsbestosTypeFactorID;
    }
    /**
     * Set HubMaterialAsbestosTypeFactorID value
     * @param int $hubMaterialAsbestosTypeFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubMaterialAsbestosTypeFactorID($hubMaterialAsbestosTypeFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubMaterialAsbestosTypeFactorID) && !(is_int($hubMaterialAsbestosTypeFactorID) || ctype_digit($hubMaterialAsbestosTypeFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubMaterialAsbestosTypeFactorID, true), gettype($hubMaterialAsbestosTypeFactorID)), __LINE__);
        }
        $this->HubMaterialAsbestosTypeFactorID = $hubMaterialAsbestosTypeFactorID;
        return $this;
    }
    /**
     * Get MaterialAccessibilityCode value
     * @return string
     */
    public function getMaterialAccessibilityCode()
    {
        return $this->MaterialAccessibilityCode;
    }
    /**
     * Set MaterialAccessibilityCode value
     * @param string $materialAccessibilityCode
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setMaterialAccessibilityCode($materialAccessibilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($materialAccessibilityCode) && !is_string($materialAccessibilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($materialAccessibilityCode, true), gettype($materialAccessibilityCode)), __LINE__);
        }
        $this->MaterialAccessibilityCode = $materialAccessibilityCode;
        return $this;
    }
    /**
     * Get HubPriorityActivityPrimaryFactorID value
     * @return int
     */
    public function getHubPriorityActivityPrimaryFactorID()
    {
        return $this->HubPriorityActivityPrimaryFactorID;
    }
    /**
     * Set HubPriorityActivityPrimaryFactorID value
     * @param int $hubPriorityActivityPrimaryFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubPriorityActivityPrimaryFactorID($hubPriorityActivityPrimaryFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubPriorityActivityPrimaryFactorID) && !(is_int($hubPriorityActivityPrimaryFactorID) || ctype_digit($hubPriorityActivityPrimaryFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubPriorityActivityPrimaryFactorID, true), gettype($hubPriorityActivityPrimaryFactorID)), __LINE__);
        }
        $this->HubPriorityActivityPrimaryFactorID = $hubPriorityActivityPrimaryFactorID;
        return $this;
    }
    /**
     * Get HubPriorityActivitySecondaryFactorID value
     * @return int
     */
    public function getHubPriorityActivitySecondaryFactorID()
    {
        return $this->HubPriorityActivitySecondaryFactorID;
    }
    /**
     * Set HubPriorityActivitySecondaryFactorID value
     * @param int $hubPriorityActivitySecondaryFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubPriorityActivitySecondaryFactorID($hubPriorityActivitySecondaryFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubPriorityActivitySecondaryFactorID) && !(is_int($hubPriorityActivitySecondaryFactorID) || ctype_digit($hubPriorityActivitySecondaryFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubPriorityActivitySecondaryFactorID, true), gettype($hubPriorityActivitySecondaryFactorID)), __LINE__);
        }
        $this->HubPriorityActivitySecondaryFactorID = $hubPriorityActivitySecondaryFactorID;
        return $this;
    }
    /**
     * Get HubPriorityDisturbanceLocationFactorID value
     * @return int
     */
    public function getHubPriorityDisturbanceLocationFactorID()
    {
        return $this->HubPriorityDisturbanceLocationFactorID;
    }
    /**
     * Set HubPriorityDisturbanceLocationFactorID value
     * @param int $hubPriorityDisturbanceLocationFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubPriorityDisturbanceLocationFactorID($hubPriorityDisturbanceLocationFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubPriorityDisturbanceLocationFactorID) && !(is_int($hubPriorityDisturbanceLocationFactorID) || ctype_digit($hubPriorityDisturbanceLocationFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubPriorityDisturbanceLocationFactorID, true), gettype($hubPriorityDisturbanceLocationFactorID)), __LINE__);
        }
        $this->HubPriorityDisturbanceLocationFactorID = $hubPriorityDisturbanceLocationFactorID;
        return $this;
    }
    /**
     * Get HubPriorityDisturbanceAccessibilityFactorID value
     * @return int
     */
    public function getHubPriorityDisturbanceAccessibilityFactorID()
    {
        return $this->HubPriorityDisturbanceAccessibilityFactorID;
    }
    /**
     * Set HubPriorityDisturbanceAccessibilityFactorID value
     * @param int $hubPriorityDisturbanceAccessibilityFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubPriorityDisturbanceAccessibilityFactorID($hubPriorityDisturbanceAccessibilityFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubPriorityDisturbanceAccessibilityFactorID) && !(is_int($hubPriorityDisturbanceAccessibilityFactorID) || ctype_digit($hubPriorityDisturbanceAccessibilityFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubPriorityDisturbanceAccessibilityFactorID, true), gettype($hubPriorityDisturbanceAccessibilityFactorID)), __LINE__);
        }
        $this->HubPriorityDisturbanceAccessibilityFactorID = $hubPriorityDisturbanceAccessibilityFactorID;
        return $this;
    }
    /**
     * Get HubPriorityDisturbanceExtentFactorID value
     * @return int
     */
    public function getHubPriorityDisturbanceExtentFactorID()
    {
        return $this->HubPriorityDisturbanceExtentFactorID;
    }
    /**
     * Set HubPriorityDisturbanceExtentFactorID value
     * @param int $hubPriorityDisturbanceExtentFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubPriorityDisturbanceExtentFactorID($hubPriorityDisturbanceExtentFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubPriorityDisturbanceExtentFactorID) && !(is_int($hubPriorityDisturbanceExtentFactorID) || ctype_digit($hubPriorityDisturbanceExtentFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubPriorityDisturbanceExtentFactorID, true), gettype($hubPriorityDisturbanceExtentFactorID)), __LINE__);
        }
        $this->HubPriorityDisturbanceExtentFactorID = $hubPriorityDisturbanceExtentFactorID;
        return $this;
    }
    /**
     * Get HubPriorityHumanOccupancyFactorID value
     * @return int
     */
    public function getHubPriorityHumanOccupancyFactorID()
    {
        return $this->HubPriorityHumanOccupancyFactorID;
    }
    /**
     * Set HubPriorityHumanOccupancyFactorID value
     * @param int $hubPriorityHumanOccupancyFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubPriorityHumanOccupancyFactorID($hubPriorityHumanOccupancyFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubPriorityHumanOccupancyFactorID) && !(is_int($hubPriorityHumanOccupancyFactorID) || ctype_digit($hubPriorityHumanOccupancyFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubPriorityHumanOccupancyFactorID, true), gettype($hubPriorityHumanOccupancyFactorID)), __LINE__);
        }
        $this->HubPriorityHumanOccupancyFactorID = $hubPriorityHumanOccupancyFactorID;
        return $this;
    }
    /**
     * Get HubPriorityHumanFrequencyFactorID value
     * @return int
     */
    public function getHubPriorityHumanFrequencyFactorID()
    {
        return $this->HubPriorityHumanFrequencyFactorID;
    }
    /**
     * Set HubPriorityHumanFrequencyFactorID value
     * @param int $hubPriorityHumanFrequencyFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubPriorityHumanFrequencyFactorID($hubPriorityHumanFrequencyFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubPriorityHumanFrequencyFactorID) && !(is_int($hubPriorityHumanFrequencyFactorID) || ctype_digit($hubPriorityHumanFrequencyFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubPriorityHumanFrequencyFactorID, true), gettype($hubPriorityHumanFrequencyFactorID)), __LINE__);
        }
        $this->HubPriorityHumanFrequencyFactorID = $hubPriorityHumanFrequencyFactorID;
        return $this;
    }
    /**
     * Get HubPriorityHumanTimeFactorID value
     * @return int
     */
    public function getHubPriorityHumanTimeFactorID()
    {
        return $this->HubPriorityHumanTimeFactorID;
    }
    /**
     * Set HubPriorityHumanTimeFactorID value
     * @param int $hubPriorityHumanTimeFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubPriorityHumanTimeFactorID($hubPriorityHumanTimeFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubPriorityHumanTimeFactorID) && !(is_int($hubPriorityHumanTimeFactorID) || ctype_digit($hubPriorityHumanTimeFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubPriorityHumanTimeFactorID, true), gettype($hubPriorityHumanTimeFactorID)), __LINE__);
        }
        $this->HubPriorityHumanTimeFactorID = $hubPriorityHumanTimeFactorID;
        return $this;
    }
    /**
     * Get HubPriorityMaintDisturbanceFactorID value
     * @return int
     */
    public function getHubPriorityMaintDisturbanceFactorID()
    {
        return $this->HubPriorityMaintDisturbanceFactorID;
    }
    /**
     * Set HubPriorityMaintDisturbanceFactorID value
     * @param int $hubPriorityMaintDisturbanceFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubPriorityMaintDisturbanceFactorID($hubPriorityMaintDisturbanceFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubPriorityMaintDisturbanceFactorID) && !(is_int($hubPriorityMaintDisturbanceFactorID) || ctype_digit($hubPriorityMaintDisturbanceFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubPriorityMaintDisturbanceFactorID, true), gettype($hubPriorityMaintDisturbanceFactorID)), __LINE__);
        }
        $this->HubPriorityMaintDisturbanceFactorID = $hubPriorityMaintDisturbanceFactorID;
        return $this;
    }
    /**
     * Get HubPriorityMaintFrequencyFactorID value
     * @return int
     */
    public function getHubPriorityMaintFrequencyFactorID()
    {
        return $this->HubPriorityMaintFrequencyFactorID;
    }
    /**
     * Set HubPriorityMaintFrequencyFactorID value
     * @param int $hubPriorityMaintFrequencyFactorID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubPriorityMaintFrequencyFactorID($hubPriorityMaintFrequencyFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($hubPriorityMaintFrequencyFactorID) && !(is_int($hubPriorityMaintFrequencyFactorID) || ctype_digit($hubPriorityMaintFrequencyFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubPriorityMaintFrequencyFactorID, true), gettype($hubPriorityMaintFrequencyFactorID)), __LINE__);
        }
        $this->HubPriorityMaintFrequencyFactorID = $hubPriorityMaintFrequencyFactorID;
        return $this;
    }
    /**
     * Get PriorityScore value
     * @return int
     */
    public function getPriorityScore()
    {
        return $this->PriorityScore;
    }
    /**
     * Set PriorityScore value
     * @param int $priorityScore
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setPriorityScore($priorityScore = null)
    {
        // validation for constraint: int
        if (!is_null($priorityScore) && !(is_int($priorityScore) || ctype_digit($priorityScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priorityScore, true), gettype($priorityScore)), __LINE__);
        }
        $this->PriorityScore = $priorityScore;
        return $this;
    }
    /**
     * Get MaterialScore value
     * @return int
     */
    public function getMaterialScore()
    {
        return $this->MaterialScore;
    }
    /**
     * Set MaterialScore value
     * @param int $materialScore
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setMaterialScore($materialScore = null)
    {
        // validation for constraint: int
        if (!is_null($materialScore) && !(is_int($materialScore) || ctype_digit($materialScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($materialScore, true), gettype($materialScore)), __LINE__);
        }
        $this->MaterialScore = $materialScore;
        return $this;
    }
    /**
     * Get HubLabID value
     * @return int
     */
    public function getHubLabID()
    {
        return $this->HubLabID;
    }
    /**
     * Set HubLabID value
     * @param int $hubLabID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubLabID($hubLabID = null)
    {
        // validation for constraint: int
        if (!is_null($hubLabID) && !(is_int($hubLabID) || ctype_digit($hubLabID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubLabID, true), gettype($hubLabID)), __LINE__);
        }
        $this->HubLabID = $hubLabID;
        return $this;
    }
    /**
     * Get ProposalWorkArea value
     * @return bool
     */
    public function getProposalWorkArea()
    {
        return $this->ProposalWorkArea;
    }
    /**
     * Set ProposalWorkArea value
     * @param bool $proposalWorkArea
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setProposalWorkArea($proposalWorkArea = null)
    {
        // validation for constraint: boolean
        if (!is_null($proposalWorkArea) && !is_bool($proposalWorkArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($proposalWorkArea, true), gettype($proposalWorkArea)), __LINE__);
        }
        $this->ProposalWorkArea = $proposalWorkArea;
        return $this;
    }
    /**
     * Get HubNoAccessReasonID value
     * @return int
     */
    public function getHubNoAccessReasonID()
    {
        return $this->HubNoAccessReasonID;
    }
    /**
     * Set HubNoAccessReasonID value
     * @param int $hubNoAccessReasonID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHubNoAccessReasonID($hubNoAccessReasonID = null)
    {
        // validation for constraint: int
        if (!is_null($hubNoAccessReasonID) && !(is_int($hubNoAccessReasonID) || ctype_digit($hubNoAccessReasonID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubNoAccessReasonID, true), gettype($hubNoAccessReasonID)), __LINE__);
        }
        $this->HubNoAccessReasonID = $hubNoAccessReasonID;
        return $this;
    }
    /**
     * Get SampleID value
     * @return int
     */
    public function getSampleID()
    {
        return $this->SampleID;
    }
    /**
     * Set SampleID value
     * @param int $sampleID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setSampleID($sampleID = null)
    {
        // validation for constraint: int
        if (!is_null($sampleID) && !(is_int($sampleID) || ctype_digit($sampleID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sampleID, true), gettype($sampleID)), __LINE__);
        }
        $this->SampleID = $sampleID;
        return $this;
    }
    /**
     * Get DuplicateOfSampleID value
     * @return int
     */
    public function getDuplicateOfSampleID()
    {
        return $this->DuplicateOfSampleID;
    }
    /**
     * Set DuplicateOfSampleID value
     * @param int $duplicateOfSampleID
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setDuplicateOfSampleID($duplicateOfSampleID = null)
    {
        // validation for constraint: int
        if (!is_null($duplicateOfSampleID) && !(is_int($duplicateOfSampleID) || ctype_digit($duplicateOfSampleID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duplicateOfSampleID, true), gettype($duplicateOfSampleID)), __LINE__);
        }
        $this->DuplicateOfSampleID = $duplicateOfSampleID;
        return $this;
    }
    /**
     * Get PhotoFileName value
     * @return string|null
     */
    public function getPhotoFileName()
    {
        return $this->PhotoFileName;
    }
    /**
     * Set PhotoFileName value
     * @param string $photoFileName
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setPhotoFileName($photoFileName = null)
    {
        // validation for constraint: string
        if (!is_null($photoFileName) && !is_string($photoFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($photoFileName, true), gettype($photoFileName)), __LINE__);
        }
        $this->PhotoFileName = $photoFileName;
        return $this;
    }
    /**
     * Get BuildingDescription value
     * @return string|null
     */
    public function getBuildingDescription()
    {
        return $this->BuildingDescription;
    }
    /**
     * Set BuildingDescription value
     * @param string $buildingDescription
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setBuildingDescription($buildingDescription = null)
    {
        // validation for constraint: string
        if (!is_null($buildingDescription) && !is_string($buildingDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingDescription, true), gettype($buildingDescription)), __LINE__);
        }
        $this->BuildingDescription = $buildingDescription;
        return $this;
    }
    /**
     * Get BlockNumber value
     * @return string|null
     */
    public function getBlockNumber()
    {
        return $this->BlockNumber;
    }
    /**
     * Set BlockNumber value
     * @param string $blockNumber
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setBlockNumber($blockNumber = null)
    {
        // validation for constraint: string
        if (!is_null($blockNumber) && !is_string($blockNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockNumber, true), gettype($blockNumber)), __LINE__);
        }
        $this->BlockNumber = $blockNumber;
        return $this;
    }
    /**
     * Get FloorDescription value
     * @return string|null
     */
    public function getFloorDescription()
    {
        return $this->FloorDescription;
    }
    /**
     * Set FloorDescription value
     * @param string $floorDescription
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setFloorDescription($floorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($floorDescription) && !is_string($floorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floorDescription, true), gettype($floorDescription)), __LINE__);
        }
        $this->FloorDescription = $floorDescription;
        return $this;
    }
    /**
     * Get RoomNumber value
     * @return string|null
     */
    public function getRoomNumber()
    {
        return $this->RoomNumber;
    }
    /**
     * Set RoomNumber value
     * @param string $roomNumber
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setRoomNumber($roomNumber = null)
    {
        // validation for constraint: string
        if (!is_null($roomNumber) && !is_string($roomNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomNumber, true), gettype($roomNumber)), __LINE__);
        }
        $this->RoomNumber = $roomNumber;
        return $this;
    }
    /**
     * Get RoomDescription value
     * @return string|null
     */
    public function getRoomDescription()
    {
        return $this->RoomDescription;
    }
    /**
     * Set RoomDescription value
     * @param string $roomDescription
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setRoomDescription($roomDescription = null)
    {
        // validation for constraint: string
        if (!is_null($roomDescription) && !is_string($roomDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomDescription, true), gettype($roomDescription)), __LINE__);
        }
        $this->RoomDescription = $roomDescription;
        return $this;
    }
    /**
     * Get PositionDescription value
     * @return string|null
     */
    public function getPositionDescription()
    {
        return $this->PositionDescription;
    }
    /**
     * Set PositionDescription value
     * @param string $positionDescription
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setPositionDescription($positionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($positionDescription) && !is_string($positionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionDescription, true), gettype($positionDescription)), __LINE__);
        }
        $this->PositionDescription = $positionDescription;
        return $this;
    }
    /**
     * Get ComponentDescription value
     * @return string|null
     */
    public function getComponentDescription()
    {
        return $this->ComponentDescription;
    }
    /**
     * Set ComponentDescription value
     * @param string $componentDescription
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setComponentDescription($componentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($componentDescription) && !is_string($componentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($componentDescription, true), gettype($componentDescription)), __LINE__);
        }
        $this->ComponentDescription = $componentDescription;
        return $this;
    }
    /**
     * Get LabSampleRef value
     * @return string|null
     */
    public function getLabSampleRef()
    {
        return $this->LabSampleRef;
    }
    /**
     * Set LabSampleRef value
     * @param string $labSampleRef
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setLabSampleRef($labSampleRef = null)
    {
        // validation for constraint: string
        if (!is_null($labSampleRef) && !is_string($labSampleRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labSampleRef, true), gettype($labSampleRef)), __LINE__);
        }
        $this->LabSampleRef = $labSampleRef;
        return $this;
    }
    /**
     * Get Qty value
     * @return string|null
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param string $qty
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get HashText value
     * @return string|null
     */
    public function getHashText()
    {
        return $this->HashText;
    }
    /**
     * Set HashText value
     * @param string $hashText
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setHashText($hashText = null)
    {
        // validation for constraint: string
        if (!is_null($hashText) && !is_string($hashText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashText, true), gettype($hashText)), __LINE__);
        }
        $this->HashText = $hashText;
        return $this;
    }
    /**
     * Get MaterialRisk value
     * @return string|null
     */
    public function getMaterialRisk()
    {
        return $this->MaterialRisk;
    }
    /**
     * Set MaterialRisk value
     * @param string $materialRisk
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setMaterialRisk($materialRisk = null)
    {
        // validation for constraint: string
        if (!is_null($materialRisk) && !is_string($materialRisk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($materialRisk, true), gettype($materialRisk)), __LINE__);
        }
        $this->MaterialRisk = $materialRisk;
        return $this;
    }
    /**
     * Get ActionDescription value
     * @return string|null
     */
    public function getActionDescription()
    {
        return $this->ActionDescription;
    }
    /**
     * Set ActionDescription value
     * @param string $actionDescription
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setActionDescription($actionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($actionDescription) && !is_string($actionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionDescription, true), gettype($actionDescription)), __LINE__);
        }
        $this->ActionDescription = $actionDescription;
        return $this;
    }
    /**
     * Get NextInspectionDescription value
     * @return string|null
     */
    public function getNextInspectionDescription()
    {
        return $this->NextInspectionDescription;
    }
    /**
     * Set NextInspectionDescription value
     * @param string $nextInspectionDescription
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setNextInspectionDescription($nextInspectionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($nextInspectionDescription) && !is_string($nextInspectionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextInspectionDescription, true), gettype($nextInspectionDescription)), __LINE__);
        }
        $this->NextInspectionDescription = $nextInspectionDescription;
        return $this;
    }
    /**
     * Get SurveyorsRecommendation value
     * @return string|null
     */
    public function getSurveyorsRecommendation()
    {
        return $this->SurveyorsRecommendation;
    }
    /**
     * Set SurveyorsRecommendation value
     * @param string $surveyorsRecommendation
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setSurveyorsRecommendation($surveyorsRecommendation = null)
    {
        // validation for constraint: string
        if (!is_null($surveyorsRecommendation) && !is_string($surveyorsRecommendation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyorsRecommendation, true), gettype($surveyorsRecommendation)), __LINE__);
        }
        $this->SurveyorsRecommendation = $surveyorsRecommendation;
        return $this;
    }
    /**
     * Get PriorityRisk value
     * @return string|null
     */
    public function getPriorityRisk()
    {
        return $this->PriorityRisk;
    }
    /**
     * Set PriorityRisk value
     * @param string $priorityRisk
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setPriorityRisk($priorityRisk = null)
    {
        // validation for constraint: string
        if (!is_null($priorityRisk) && !is_string($priorityRisk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priorityRisk, true), gettype($priorityRisk)), __LINE__);
        }
        $this->PriorityRisk = $priorityRisk;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\ClsWCFAndroidSample
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFAndroidSample
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
