<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFAnalystEntry StructType
 * @subpackage Structs
 */
class ClsWCFAnalystEntry extends AbstractStructBase
{
    /**
     * The HubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSurveyID;
    /**
     * The ClearanceAreaNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClearanceAreaNo;
    /**
     * The CertificateNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CertificateNo;
    /**
     * The AirTestNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AirTestNo;
    /**
     * The SectionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SectionType;
    /**
     * The SurveyorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SurveyorID;
    /**
     * The AnalystPhoneID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AnalystPhoneID;
    /**
     * The AnalystEntryNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AnalystEntryNo;
    /**
     * The AnalystName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnalystName;
    /**
     * Constructor method for clsWCFAnalystEntry
     * @uses ClsWCFAnalystEntry::setHubSurveyID()
     * @uses ClsWCFAnalystEntry::setClearanceAreaNo()
     * @uses ClsWCFAnalystEntry::setCertificateNo()
     * @uses ClsWCFAnalystEntry::setAirTestNo()
     * @uses ClsWCFAnalystEntry::setSectionType()
     * @uses ClsWCFAnalystEntry::setSurveyorID()
     * @uses ClsWCFAnalystEntry::setAnalystPhoneID()
     * @uses ClsWCFAnalystEntry::setAnalystEntryNo()
     * @uses ClsWCFAnalystEntry::setAnalystName()
     * @param int $hubSurveyID
     * @param int $clearanceAreaNo
     * @param int $certificateNo
     * @param int $airTestNo
     * @param int $sectionType
     * @param int $surveyorID
     * @param int $analystPhoneID
     * @param int $analystEntryNo
     * @param string $analystName
     */
    public function __construct($hubSurveyID = null, $clearanceAreaNo = null, $certificateNo = null, $airTestNo = null, $sectionType = null, $surveyorID = null, $analystPhoneID = null, $analystEntryNo = null, $analystName = null)
    {
        $this
            ->setHubSurveyID($hubSurveyID)
            ->setClearanceAreaNo($clearanceAreaNo)
            ->setCertificateNo($certificateNo)
            ->setAirTestNo($airTestNo)
            ->setSectionType($sectionType)
            ->setSurveyorID($surveyorID)
            ->setAnalystPhoneID($analystPhoneID)
            ->setAnalystEntryNo($analystEntryNo)
            ->setAnalystName($analystName);
    }
    /**
     * Get HubSurveyID value
     * @return int
     */
    public function getHubSurveyID()
    {
        return $this->HubSurveyID;
    }
    /**
     * Set HubSurveyID value
     * @param int $hubSurveyID
     * @return \StructType\ClsWCFAnalystEntry
     */
    public function setHubSurveyID($hubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSurveyID) && !(is_int($hubSurveyID) || ctype_digit($hubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSurveyID, true), gettype($hubSurveyID)), __LINE__);
        }
        $this->HubSurveyID = $hubSurveyID;
        return $this;
    }
    /**
     * Get ClearanceAreaNo value
     * @return int
     */
    public function getClearanceAreaNo()
    {
        return $this->ClearanceAreaNo;
    }
    /**
     * Set ClearanceAreaNo value
     * @param int $clearanceAreaNo
     * @return \StructType\ClsWCFAnalystEntry
     */
    public function setClearanceAreaNo($clearanceAreaNo = null)
    {
        // validation for constraint: int
        if (!is_null($clearanceAreaNo) && !(is_int($clearanceAreaNo) || ctype_digit($clearanceAreaNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clearanceAreaNo, true), gettype($clearanceAreaNo)), __LINE__);
        }
        $this->ClearanceAreaNo = $clearanceAreaNo;
        return $this;
    }
    /**
     * Get CertificateNo value
     * @return int
     */
    public function getCertificateNo()
    {
        return $this->CertificateNo;
    }
    /**
     * Set CertificateNo value
     * @param int $certificateNo
     * @return \StructType\ClsWCFAnalystEntry
     */
    public function setCertificateNo($certificateNo = null)
    {
        // validation for constraint: int
        if (!is_null($certificateNo) && !(is_int($certificateNo) || ctype_digit($certificateNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($certificateNo, true), gettype($certificateNo)), __LINE__);
        }
        $this->CertificateNo = $certificateNo;
        return $this;
    }
    /**
     * Get AirTestNo value
     * @return int
     */
    public function getAirTestNo()
    {
        return $this->AirTestNo;
    }
    /**
     * Set AirTestNo value
     * @param int $airTestNo
     * @return \StructType\ClsWCFAnalystEntry
     */
    public function setAirTestNo($airTestNo = null)
    {
        // validation for constraint: int
        if (!is_null($airTestNo) && !(is_int($airTestNo) || ctype_digit($airTestNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($airTestNo, true), gettype($airTestNo)), __LINE__);
        }
        $this->AirTestNo = $airTestNo;
        return $this;
    }
    /**
     * Get SectionType value
     * @return int
     */
    public function getSectionType()
    {
        return $this->SectionType;
    }
    /**
     * Set SectionType value
     * @param int $sectionType
     * @return \StructType\ClsWCFAnalystEntry
     */
    public function setSectionType($sectionType = null)
    {
        // validation for constraint: int
        if (!is_null($sectionType) && !(is_int($sectionType) || ctype_digit($sectionType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sectionType, true), gettype($sectionType)), __LINE__);
        }
        $this->SectionType = $sectionType;
        return $this;
    }
    /**
     * Get SurveyorID value
     * @return int
     */
    public function getSurveyorID()
    {
        return $this->SurveyorID;
    }
    /**
     * Set SurveyorID value
     * @param int $surveyorID
     * @return \StructType\ClsWCFAnalystEntry
     */
    public function setSurveyorID($surveyorID = null)
    {
        // validation for constraint: int
        if (!is_null($surveyorID) && !(is_int($surveyorID) || ctype_digit($surveyorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($surveyorID, true), gettype($surveyorID)), __LINE__);
        }
        $this->SurveyorID = $surveyorID;
        return $this;
    }
    /**
     * Get AnalystPhoneID value
     * @return int
     */
    public function getAnalystPhoneID()
    {
        return $this->AnalystPhoneID;
    }
    /**
     * Set AnalystPhoneID value
     * @param int $analystPhoneID
     * @return \StructType\ClsWCFAnalystEntry
     */
    public function setAnalystPhoneID($analystPhoneID = null)
    {
        // validation for constraint: int
        if (!is_null($analystPhoneID) && !(is_int($analystPhoneID) || ctype_digit($analystPhoneID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($analystPhoneID, true), gettype($analystPhoneID)), __LINE__);
        }
        $this->AnalystPhoneID = $analystPhoneID;
        return $this;
    }
    /**
     * Get AnalystEntryNo value
     * @return int
     */
    public function getAnalystEntryNo()
    {
        return $this->AnalystEntryNo;
    }
    /**
     * Set AnalystEntryNo value
     * @param int $analystEntryNo
     * @return \StructType\ClsWCFAnalystEntry
     */
    public function setAnalystEntryNo($analystEntryNo = null)
    {
        // validation for constraint: int
        if (!is_null($analystEntryNo) && !(is_int($analystEntryNo) || ctype_digit($analystEntryNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($analystEntryNo, true), gettype($analystEntryNo)), __LINE__);
        }
        $this->AnalystEntryNo = $analystEntryNo;
        return $this;
    }
    /**
     * Get AnalystName value
     * @return string|null
     */
    public function getAnalystName()
    {
        return $this->AnalystName;
    }
    /**
     * Set AnalystName value
     * @param string $analystName
     * @return \StructType\ClsWCFAnalystEntry
     */
    public function setAnalystName($analystName = null)
    {
        // validation for constraint: string
        if (!is_null($analystName) && !is_string($analystName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($analystName, true), gettype($analystName)), __LINE__);
        }
        $this->AnalystName = $analystName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFAnalystEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
