<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mikes ServiceType
 * @subpackage Services
 */
class Mikes extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MikesTestWCF
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MikesTestWCF $parameters
     * @return \StructType\MikesTestWCFResponse|bool
     */
    public function MikesTestWCF(\StructType\MikesTestWCF $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MikesTestWCF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MikesTestWCFResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
