<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mark ServiceType
 * @subpackage Services
 */
class Mark extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MarkSurveyDownloaded
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarkSurveyDownloaded $parameters
     * @return \StructType\MarkSurveyDownloadedResponse|bool
     */
    public function MarkSurveyDownloaded(\StructType\MarkSurveyDownloaded $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkSurveyDownloaded($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarkSurveyFinished
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarkSurveyFinished $parameters
     * @return \StructType\MarkSurveyFinishedResponse|bool
     */
    public function MarkSurveyFinished(\StructType\MarkSurveyFinished $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkSurveyFinished($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MarkSurveyDownloadedResponse|\StructType\MarkSurveyFinishedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
