<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteCLODownloadIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCLODownloadIds $parameters
     * @return \StructType\DeleteCLODownloadIdsResponse|bool
     */
    public function DeleteCLODownloadIds(\StructType\DeleteCLODownloadIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteCLODownloadIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteCLOJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCLOJob $parameters
     * @return \StructType\DeleteCLOJobResponse|bool
     */
    public function DeleteCLOJob(\StructType\DeleteCLOJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteCLOJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteTeam
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteTeam $parameters
     * @return \StructType\DeleteTeamResponse|bool
     */
    public function DeleteTeam(\StructType\DeleteTeam $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteTeam($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteFiles $parameters
     * @return \StructType\DeleteFilesResponse|bool
     */
    public function DeleteFiles(\StructType\DeleteFiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteSurveys
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteSurveys $parameters
     * @return \StructType\DeleteSurveysResponse|bool
     */
    public function DeleteSurveys(\StructType\DeleteSurveys $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteSurveys($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteErrors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteErrors $parameters
     * @return \StructType\DeleteErrorsResponse|bool
     */
    public function DeleteErrors(\StructType\DeleteErrors $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteErrors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteCLODownloadIdsResponse|\StructType\DeleteCLOJobResponse|\StructType\DeleteErrorsResponse|\StructType\DeleteFilesResponse|\StructType\DeleteSurveysResponse|\StructType\DeleteTeamResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
