<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadSurveyorLocation StructType
 * @subpackage Structs
 */
class UploadSurveyorLocation extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pLongitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $pLongitude;
    /**
     * The pLatitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $pLatitude;
    /**
     * The pHubSurveyorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubSurveyorID;
    /**
     * Constructor method for UploadSurveyorLocation
     * @uses UploadSurveyorLocation::setPCompanyID()
     * @uses UploadSurveyorLocation::setPUserID()
     * @uses UploadSurveyorLocation::setPAuthKey()
     * @uses UploadSurveyorLocation::setPLongitude()
     * @uses UploadSurveyorLocation::setPLatitude()
     * @uses UploadSurveyorLocation::setPHubSurveyorID()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param float $pLongitude
     * @param float $pLatitude
     * @param int $pHubSurveyorID
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pLongitude = null, $pLatitude = null, $pHubSurveyorID = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPLongitude($pLongitude)
            ->setPLatitude($pLatitude)
            ->setPHubSurveyorID($pHubSurveyorID);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadSurveyorLocation
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadSurveyorLocation
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadSurveyorLocation
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pLongitude value
     * @return float
     */
    public function getPLongitude()
    {
        return $this->pLongitude;
    }
    /**
     * Set pLongitude value
     * @param float $pLongitude
     * @return \StructType\UploadSurveyorLocation
     */
    public function setPLongitude($pLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($pLongitude) && !(is_float($pLongitude) || is_numeric($pLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pLongitude, true), gettype($pLongitude)), __LINE__);
        }
        $this->pLongitude = $pLongitude;
        return $this;
    }
    /**
     * Get pLatitude value
     * @return float
     */
    public function getPLatitude()
    {
        return $this->pLatitude;
    }
    /**
     * Set pLatitude value
     * @param float $pLatitude
     * @return \StructType\UploadSurveyorLocation
     */
    public function setPLatitude($pLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($pLatitude) && !(is_float($pLatitude) || is_numeric($pLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pLatitude, true), gettype($pLatitude)), __LINE__);
        }
        $this->pLatitude = $pLatitude;
        return $this;
    }
    /**
     * Get pHubSurveyorID value
     * @return int
     */
    public function getPHubSurveyorID()
    {
        return $this->pHubSurveyorID;
    }
    /**
     * Set pHubSurveyorID value
     * @param int $pHubSurveyorID
     * @return \StructType\UploadSurveyorLocation
     */
    public function setPHubSurveyorID($pHubSurveyorID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubSurveyorID) && !(is_int($pHubSurveyorID) || ctype_digit($pHubSurveyorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubSurveyorID, true), gettype($pHubSurveyorID)), __LINE__);
        }
        $this->pHubSurveyorID = $pHubSurveyorID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadSurveyorLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
