<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadSurveyor StructType
 * @subpackage Structs
 */
class UploadSurveyor extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pHubSurveyorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubSurveyorID;
    /**
     * The pSurveyorFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pSurveyorFlag;
    /**
     * The pProjectManagerFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pProjectManagerFlag;
    /**
     * The pAnalyticalFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pAnalyticalFlag;
    /**
     * The pDisabledFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pDisabledFlag;
    /**
     * The pName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pName;
    /**
     * Constructor method for UploadSurveyor
     * @uses UploadSurveyor::setPCompanyID()
     * @uses UploadSurveyor::setPUserID()
     * @uses UploadSurveyor::setPAuthKey()
     * @uses UploadSurveyor::setPHubSurveyorID()
     * @uses UploadSurveyor::setPSurveyorFlag()
     * @uses UploadSurveyor::setPProjectManagerFlag()
     * @uses UploadSurveyor::setPAnalyticalFlag()
     * @uses UploadSurveyor::setPDisabledFlag()
     * @uses UploadSurveyor::setPName()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pHubSurveyorID
     * @param bool $pSurveyorFlag
     * @param bool $pProjectManagerFlag
     * @param bool $pAnalyticalFlag
     * @param bool $pDisabledFlag
     * @param string $pName
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pHubSurveyorID = null, $pSurveyorFlag = null, $pProjectManagerFlag = null, $pAnalyticalFlag = null, $pDisabledFlag = null, $pName = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPHubSurveyorID($pHubSurveyorID)
            ->setPSurveyorFlag($pSurveyorFlag)
            ->setPProjectManagerFlag($pProjectManagerFlag)
            ->setPAnalyticalFlag($pAnalyticalFlag)
            ->setPDisabledFlag($pDisabledFlag)
            ->setPName($pName);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadSurveyor
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadSurveyor
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadSurveyor
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pHubSurveyorID value
     * @return int
     */
    public function getPHubSurveyorID()
    {
        return $this->pHubSurveyorID;
    }
    /**
     * Set pHubSurveyorID value
     * @param int $pHubSurveyorID
     * @return \StructType\UploadSurveyor
     */
    public function setPHubSurveyorID($pHubSurveyorID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubSurveyorID) && !(is_int($pHubSurveyorID) || ctype_digit($pHubSurveyorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubSurveyorID, true), gettype($pHubSurveyorID)), __LINE__);
        }
        $this->pHubSurveyorID = $pHubSurveyorID;
        return $this;
    }
    /**
     * Get pSurveyorFlag value
     * @return bool
     */
    public function getPSurveyorFlag()
    {
        return $this->pSurveyorFlag;
    }
    /**
     * Set pSurveyorFlag value
     * @param bool $pSurveyorFlag
     * @return \StructType\UploadSurveyor
     */
    public function setPSurveyorFlag($pSurveyorFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pSurveyorFlag) && !is_bool($pSurveyorFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pSurveyorFlag, true), gettype($pSurveyorFlag)), __LINE__);
        }
        $this->pSurveyorFlag = $pSurveyorFlag;
        return $this;
    }
    /**
     * Get pProjectManagerFlag value
     * @return bool
     */
    public function getPProjectManagerFlag()
    {
        return $this->pProjectManagerFlag;
    }
    /**
     * Set pProjectManagerFlag value
     * @param bool $pProjectManagerFlag
     * @return \StructType\UploadSurveyor
     */
    public function setPProjectManagerFlag($pProjectManagerFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pProjectManagerFlag) && !is_bool($pProjectManagerFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pProjectManagerFlag, true), gettype($pProjectManagerFlag)), __LINE__);
        }
        $this->pProjectManagerFlag = $pProjectManagerFlag;
        return $this;
    }
    /**
     * Get pAnalyticalFlag value
     * @return bool
     */
    public function getPAnalyticalFlag()
    {
        return $this->pAnalyticalFlag;
    }
    /**
     * Set pAnalyticalFlag value
     * @param bool $pAnalyticalFlag
     * @return \StructType\UploadSurveyor
     */
    public function setPAnalyticalFlag($pAnalyticalFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pAnalyticalFlag) && !is_bool($pAnalyticalFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pAnalyticalFlag, true), gettype($pAnalyticalFlag)), __LINE__);
        }
        $this->pAnalyticalFlag = $pAnalyticalFlag;
        return $this;
    }
    /**
     * Get pDisabledFlag value
     * @return bool
     */
    public function getPDisabledFlag()
    {
        return $this->pDisabledFlag;
    }
    /**
     * Set pDisabledFlag value
     * @param bool $pDisabledFlag
     * @return \StructType\UploadSurveyor
     */
    public function setPDisabledFlag($pDisabledFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pDisabledFlag) && !is_bool($pDisabledFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pDisabledFlag, true), gettype($pDisabledFlag)), __LINE__);
        }
        $this->pDisabledFlag = $pDisabledFlag;
        return $this;
    }
    /**
     * Get pName value
     * @return string|null
     */
    public function getPName()
    {
        return $this->pName;
    }
    /**
     * Set pName value
     * @param string $pName
     * @return \StructType\UploadSurveyor
     */
    public function setPName($pName = null)
    {
        // validation for constraint: string
        if (!is_null($pName) && !is_string($pName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pName, true), gettype($pName)), __LINE__);
        }
        $this->pName = $pName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadSurveyor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
