<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadSurveyRisks StructType
 * @subpackage Structs
 */
class UploadSurveyRisks extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pHubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubSurveyID;
    /**
     * The pSurveyRisks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClsWCFSurveyRisk
     */
    public $pSurveyRisks;
    /**
     * Constructor method for UploadSurveyRisks
     * @uses UploadSurveyRisks::setPCompanyID()
     * @uses UploadSurveyRisks::setPUserID()
     * @uses UploadSurveyRisks::setPAuthKey()
     * @uses UploadSurveyRisks::setPHubSurveyID()
     * @uses UploadSurveyRisks::setPSurveyRisks()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pHubSurveyID
     * @param \ArrayType\ArrayOfClsWCFSurveyRisk $pSurveyRisks
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pHubSurveyID = null, \ArrayType\ArrayOfClsWCFSurveyRisk $pSurveyRisks = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPHubSurveyID($pHubSurveyID)
            ->setPSurveyRisks($pSurveyRisks);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadSurveyRisks
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadSurveyRisks
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadSurveyRisks
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pHubSurveyID value
     * @return int
     */
    public function getPHubSurveyID()
    {
        return $this->pHubSurveyID;
    }
    /**
     * Set pHubSurveyID value
     * @param int $pHubSurveyID
     * @return \StructType\UploadSurveyRisks
     */
    public function setPHubSurveyID($pHubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubSurveyID) && !(is_int($pHubSurveyID) || ctype_digit($pHubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubSurveyID, true), gettype($pHubSurveyID)), __LINE__);
        }
        $this->pHubSurveyID = $pHubSurveyID;
        return $this;
    }
    /**
     * Get pSurveyRisks value
     * @return \ArrayType\ArrayOfClsWCFSurveyRisk|null
     */
    public function getPSurveyRisks()
    {
        return $this->pSurveyRisks;
    }
    /**
     * Set pSurveyRisks value
     * @param \ArrayType\ArrayOfClsWCFSurveyRisk $pSurveyRisks
     * @return \StructType\UploadSurveyRisks
     */
    public function setPSurveyRisks(\ArrayType\ArrayOfClsWCFSurveyRisk $pSurveyRisks = null)
    {
        $this->pSurveyRisks = $pSurveyRisks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadSurveyRisks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
