<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadSelection StructType
 * @subpackage Structs
 */
class UploadSelection extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pHubSelectionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubSelectionID;
    /**
     * The pHubQuestionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubQuestionID;
    /**
     * The pSkipAllFurtherQuestions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pSkipAllFurtherQuestions;
    /**
     * The pDisabledFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pDisabledFlag;
    /**
     * The pSelectionText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pSelectionText;
    /**
     * Constructor method for UploadSelection
     * @uses UploadSelection::setPCompanyID()
     * @uses UploadSelection::setPUserID()
     * @uses UploadSelection::setPAuthKey()
     * @uses UploadSelection::setPHubSelectionID()
     * @uses UploadSelection::setPHubQuestionID()
     * @uses UploadSelection::setPSkipAllFurtherQuestions()
     * @uses UploadSelection::setPDisabledFlag()
     * @uses UploadSelection::setPSelectionText()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pHubSelectionID
     * @param int $pHubQuestionID
     * @param bool $pSkipAllFurtherQuestions
     * @param bool $pDisabledFlag
     * @param string $pSelectionText
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pHubSelectionID = null, $pHubQuestionID = null, $pSkipAllFurtherQuestions = null, $pDisabledFlag = null, $pSelectionText = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPHubSelectionID($pHubSelectionID)
            ->setPHubQuestionID($pHubQuestionID)
            ->setPSkipAllFurtherQuestions($pSkipAllFurtherQuestions)
            ->setPDisabledFlag($pDisabledFlag)
            ->setPSelectionText($pSelectionText);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadSelection
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadSelection
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadSelection
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pHubSelectionID value
     * @return int
     */
    public function getPHubSelectionID()
    {
        return $this->pHubSelectionID;
    }
    /**
     * Set pHubSelectionID value
     * @param int $pHubSelectionID
     * @return \StructType\UploadSelection
     */
    public function setPHubSelectionID($pHubSelectionID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubSelectionID) && !(is_int($pHubSelectionID) || ctype_digit($pHubSelectionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubSelectionID, true), gettype($pHubSelectionID)), __LINE__);
        }
        $this->pHubSelectionID = $pHubSelectionID;
        return $this;
    }
    /**
     * Get pHubQuestionID value
     * @return int
     */
    public function getPHubQuestionID()
    {
        return $this->pHubQuestionID;
    }
    /**
     * Set pHubQuestionID value
     * @param int $pHubQuestionID
     * @return \StructType\UploadSelection
     */
    public function setPHubQuestionID($pHubQuestionID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubQuestionID) && !(is_int($pHubQuestionID) || ctype_digit($pHubQuestionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubQuestionID, true), gettype($pHubQuestionID)), __LINE__);
        }
        $this->pHubQuestionID = $pHubQuestionID;
        return $this;
    }
    /**
     * Get pSkipAllFurtherQuestions value
     * @return bool
     */
    public function getPSkipAllFurtherQuestions()
    {
        return $this->pSkipAllFurtherQuestions;
    }
    /**
     * Set pSkipAllFurtherQuestions value
     * @param bool $pSkipAllFurtherQuestions
     * @return \StructType\UploadSelection
     */
    public function setPSkipAllFurtherQuestions($pSkipAllFurtherQuestions = null)
    {
        // validation for constraint: boolean
        if (!is_null($pSkipAllFurtherQuestions) && !is_bool($pSkipAllFurtherQuestions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pSkipAllFurtherQuestions, true), gettype($pSkipAllFurtherQuestions)), __LINE__);
        }
        $this->pSkipAllFurtherQuestions = $pSkipAllFurtherQuestions;
        return $this;
    }
    /**
     * Get pDisabledFlag value
     * @return bool
     */
    public function getPDisabledFlag()
    {
        return $this->pDisabledFlag;
    }
    /**
     * Set pDisabledFlag value
     * @param bool $pDisabledFlag
     * @return \StructType\UploadSelection
     */
    public function setPDisabledFlag($pDisabledFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pDisabledFlag) && !is_bool($pDisabledFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pDisabledFlag, true), gettype($pDisabledFlag)), __LINE__);
        }
        $this->pDisabledFlag = $pDisabledFlag;
        return $this;
    }
    /**
     * Get pSelectionText value
     * @return string|null
     */
    public function getPSelectionText()
    {
        return $this->pSelectionText;
    }
    /**
     * Set pSelectionText value
     * @param string $pSelectionText
     * @return \StructType\UploadSelection
     */
    public function setPSelectionText($pSelectionText = null)
    {
        // validation for constraint: string
        if (!is_null($pSelectionText) && !is_string($pSelectionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pSelectionText, true), gettype($pSelectionText)), __LINE__);
        }
        $this->pSelectionText = $pSelectionText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
