<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadSection StructType
 * @subpackage Structs
 */
class UploadSection extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pHubSectionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubSectionID;
    /**
     * The pDisabledFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pDisabledFlag;
    /**
     * The pAllowsRecommendationsFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pAllowsRecommendationsFlag;
    /**
     * The pSequenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pSequenceNumber;
    /**
     * The pPhotosAllowedFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pPhotosAllowedFlag;
    /**
     * The pName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pName;
    /**
     * Constructor method for UploadSection
     * @uses UploadSection::setPCompanyID()
     * @uses UploadSection::setPUserID()
     * @uses UploadSection::setPAuthKey()
     * @uses UploadSection::setPHubSectionID()
     * @uses UploadSection::setPDisabledFlag()
     * @uses UploadSection::setPAllowsRecommendationsFlag()
     * @uses UploadSection::setPSequenceNumber()
     * @uses UploadSection::setPPhotosAllowedFlag()
     * @uses UploadSection::setPName()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pHubSectionID
     * @param bool $pDisabledFlag
     * @param bool $pAllowsRecommendationsFlag
     * @param int $pSequenceNumber
     * @param bool $pPhotosAllowedFlag
     * @param string $pName
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pHubSectionID = null, $pDisabledFlag = null, $pAllowsRecommendationsFlag = null, $pSequenceNumber = null, $pPhotosAllowedFlag = null, $pName = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPHubSectionID($pHubSectionID)
            ->setPDisabledFlag($pDisabledFlag)
            ->setPAllowsRecommendationsFlag($pAllowsRecommendationsFlag)
            ->setPSequenceNumber($pSequenceNumber)
            ->setPPhotosAllowedFlag($pPhotosAllowedFlag)
            ->setPName($pName);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadSection
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadSection
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadSection
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pHubSectionID value
     * @return int
     */
    public function getPHubSectionID()
    {
        return $this->pHubSectionID;
    }
    /**
     * Set pHubSectionID value
     * @param int $pHubSectionID
     * @return \StructType\UploadSection
     */
    public function setPHubSectionID($pHubSectionID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubSectionID) && !(is_int($pHubSectionID) || ctype_digit($pHubSectionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubSectionID, true), gettype($pHubSectionID)), __LINE__);
        }
        $this->pHubSectionID = $pHubSectionID;
        return $this;
    }
    /**
     * Get pDisabledFlag value
     * @return bool
     */
    public function getPDisabledFlag()
    {
        return $this->pDisabledFlag;
    }
    /**
     * Set pDisabledFlag value
     * @param bool $pDisabledFlag
     * @return \StructType\UploadSection
     */
    public function setPDisabledFlag($pDisabledFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pDisabledFlag) && !is_bool($pDisabledFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pDisabledFlag, true), gettype($pDisabledFlag)), __LINE__);
        }
        $this->pDisabledFlag = $pDisabledFlag;
        return $this;
    }
    /**
     * Get pAllowsRecommendationsFlag value
     * @return bool
     */
    public function getPAllowsRecommendationsFlag()
    {
        return $this->pAllowsRecommendationsFlag;
    }
    /**
     * Set pAllowsRecommendationsFlag value
     * @param bool $pAllowsRecommendationsFlag
     * @return \StructType\UploadSection
     */
    public function setPAllowsRecommendationsFlag($pAllowsRecommendationsFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pAllowsRecommendationsFlag) && !is_bool($pAllowsRecommendationsFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pAllowsRecommendationsFlag, true), gettype($pAllowsRecommendationsFlag)), __LINE__);
        }
        $this->pAllowsRecommendationsFlag = $pAllowsRecommendationsFlag;
        return $this;
    }
    /**
     * Get pSequenceNumber value
     * @return int
     */
    public function getPSequenceNumber()
    {
        return $this->pSequenceNumber;
    }
    /**
     * Set pSequenceNumber value
     * @param int $pSequenceNumber
     * @return \StructType\UploadSection
     */
    public function setPSequenceNumber($pSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pSequenceNumber) && !(is_int($pSequenceNumber) || ctype_digit($pSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pSequenceNumber, true), gettype($pSequenceNumber)), __LINE__);
        }
        $this->pSequenceNumber = $pSequenceNumber;
        return $this;
    }
    /**
     * Get pPhotosAllowedFlag value
     * @return bool
     */
    public function getPPhotosAllowedFlag()
    {
        return $this->pPhotosAllowedFlag;
    }
    /**
     * Set pPhotosAllowedFlag value
     * @param bool $pPhotosAllowedFlag
     * @return \StructType\UploadSection
     */
    public function setPPhotosAllowedFlag($pPhotosAllowedFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pPhotosAllowedFlag) && !is_bool($pPhotosAllowedFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pPhotosAllowedFlag, true), gettype($pPhotosAllowedFlag)), __LINE__);
        }
        $this->pPhotosAllowedFlag = $pPhotosAllowedFlag;
        return $this;
    }
    /**
     * Get pName value
     * @return string|null
     */
    public function getPName()
    {
        return $this->pName;
    }
    /**
     * Set pName value
     * @param string $pName
     * @return \StructType\UploadSection
     */
    public function setPName($pName = null)
    {
        // validation for constraint: string
        if (!is_null($pName) && !is_string($pName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pName, true), gettype($pName)), __LINE__);
        }
        $this->pName = $pName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadSection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
