<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadScheme StructType
 * @subpackage Structs
 */
class UploadScheme extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pHubSchemeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubSchemeID;
    /**
     * The pName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pName;
    /**
     * The pSurveyorsInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pSurveyorsInstructions;
    /**
     * Constructor method for UploadScheme
     * @uses UploadScheme::setPCompanyID()
     * @uses UploadScheme::setPUserID()
     * @uses UploadScheme::setPAuthKey()
     * @uses UploadScheme::setPHubSchemeID()
     * @uses UploadScheme::setPName()
     * @uses UploadScheme::setPSurveyorsInstructions()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pHubSchemeID
     * @param string $pName
     * @param string $pSurveyorsInstructions
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pHubSchemeID = null, $pName = null, $pSurveyorsInstructions = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPHubSchemeID($pHubSchemeID)
            ->setPName($pName)
            ->setPSurveyorsInstructions($pSurveyorsInstructions);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadScheme
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadScheme
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadScheme
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pHubSchemeID value
     * @return int
     */
    public function getPHubSchemeID()
    {
        return $this->pHubSchemeID;
    }
    /**
     * Set pHubSchemeID value
     * @param int $pHubSchemeID
     * @return \StructType\UploadScheme
     */
    public function setPHubSchemeID($pHubSchemeID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubSchemeID) && !(is_int($pHubSchemeID) || ctype_digit($pHubSchemeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubSchemeID, true), gettype($pHubSchemeID)), __LINE__);
        }
        $this->pHubSchemeID = $pHubSchemeID;
        return $this;
    }
    /**
     * Get pName value
     * @return string|null
     */
    public function getPName()
    {
        return $this->pName;
    }
    /**
     * Set pName value
     * @param string $pName
     * @return \StructType\UploadScheme
     */
    public function setPName($pName = null)
    {
        // validation for constraint: string
        if (!is_null($pName) && !is_string($pName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pName, true), gettype($pName)), __LINE__);
        }
        $this->pName = $pName;
        return $this;
    }
    /**
     * Get pSurveyorsInstructions value
     * @return string|null
     */
    public function getPSurveyorsInstructions()
    {
        return $this->pSurveyorsInstructions;
    }
    /**
     * Set pSurveyorsInstructions value
     * @param string $pSurveyorsInstructions
     * @return \StructType\UploadScheme
     */
    public function setPSurveyorsInstructions($pSurveyorsInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($pSurveyorsInstructions) && !is_string($pSurveyorsInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pSurveyorsInstructions, true), gettype($pSurveyorsInstructions)), __LINE__);
        }
        $this->pSurveyorsInstructions = $pSurveyorsInstructions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadScheme
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
