<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadRisk StructType
 * @subpackage Structs
 */
class UploadRisk extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pHubRiskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubRiskID;
    /**
     * The pRequiresPhotoFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pRequiresPhotoFlag;
    /**
     * The pDisabledFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pDisabledFlag;
    /**
     * The pDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pDescription;
    /**
     * Constructor method for UploadRisk
     * @uses UploadRisk::setPCompanyID()
     * @uses UploadRisk::setPUserID()
     * @uses UploadRisk::setPAuthKey()
     * @uses UploadRisk::setPHubRiskID()
     * @uses UploadRisk::setPRequiresPhotoFlag()
     * @uses UploadRisk::setPDisabledFlag()
     * @uses UploadRisk::setPDescription()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pHubRiskID
     * @param bool $pRequiresPhotoFlag
     * @param bool $pDisabledFlag
     * @param string $pDescription
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pHubRiskID = null, $pRequiresPhotoFlag = null, $pDisabledFlag = null, $pDescription = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPHubRiskID($pHubRiskID)
            ->setPRequiresPhotoFlag($pRequiresPhotoFlag)
            ->setPDisabledFlag($pDisabledFlag)
            ->setPDescription($pDescription);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadRisk
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadRisk
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadRisk
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pHubRiskID value
     * @return int
     */
    public function getPHubRiskID()
    {
        return $this->pHubRiskID;
    }
    /**
     * Set pHubRiskID value
     * @param int $pHubRiskID
     * @return \StructType\UploadRisk
     */
    public function setPHubRiskID($pHubRiskID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubRiskID) && !(is_int($pHubRiskID) || ctype_digit($pHubRiskID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubRiskID, true), gettype($pHubRiskID)), __LINE__);
        }
        $this->pHubRiskID = $pHubRiskID;
        return $this;
    }
    /**
     * Get pRequiresPhotoFlag value
     * @return bool
     */
    public function getPRequiresPhotoFlag()
    {
        return $this->pRequiresPhotoFlag;
    }
    /**
     * Set pRequiresPhotoFlag value
     * @param bool $pRequiresPhotoFlag
     * @return \StructType\UploadRisk
     */
    public function setPRequiresPhotoFlag($pRequiresPhotoFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pRequiresPhotoFlag) && !is_bool($pRequiresPhotoFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pRequiresPhotoFlag, true), gettype($pRequiresPhotoFlag)), __LINE__);
        }
        $this->pRequiresPhotoFlag = $pRequiresPhotoFlag;
        return $this;
    }
    /**
     * Get pDisabledFlag value
     * @return bool
     */
    public function getPDisabledFlag()
    {
        return $this->pDisabledFlag;
    }
    /**
     * Set pDisabledFlag value
     * @param bool $pDisabledFlag
     * @return \StructType\UploadRisk
     */
    public function setPDisabledFlag($pDisabledFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pDisabledFlag) && !is_bool($pDisabledFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pDisabledFlag, true), gettype($pDisabledFlag)), __LINE__);
        }
        $this->pDisabledFlag = $pDisabledFlag;
        return $this;
    }
    /**
     * Get pDescription value
     * @return string|null
     */
    public function getPDescription()
    {
        return $this->pDescription;
    }
    /**
     * Set pDescription value
     * @param string $pDescription
     * @return \StructType\UploadRisk
     */
    public function setPDescription($pDescription = null)
    {
        // validation for constraint: string
        if (!is_null($pDescription) && !is_string($pDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDescription, true), gettype($pDescription)), __LINE__);
        }
        $this->pDescription = $pDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadRisk
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
