<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadLocationDescription StructType
 * @subpackage Structs
 */
class UploadLocationDescription extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pHubLocationDescriptionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubLocationDescriptionID;
    /**
     * The pLocationTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pLocationTypeCode;
    /**
     * The pDisabledFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pDisabledFlag;
    /**
     * The pDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pDescription;
    /**
     * Constructor method for UploadLocationDescription
     * @uses UploadLocationDescription::setPCompanyID()
     * @uses UploadLocationDescription::setPUserID()
     * @uses UploadLocationDescription::setPAuthKey()
     * @uses UploadLocationDescription::setPHubLocationDescriptionID()
     * @uses UploadLocationDescription::setPLocationTypeCode()
     * @uses UploadLocationDescription::setPDisabledFlag()
     * @uses UploadLocationDescription::setPDescription()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pHubLocationDescriptionID
     * @param string $pLocationTypeCode
     * @param bool $pDisabledFlag
     * @param string $pDescription
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pHubLocationDescriptionID = null, $pLocationTypeCode = null, $pDisabledFlag = null, $pDescription = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPHubLocationDescriptionID($pHubLocationDescriptionID)
            ->setPLocationTypeCode($pLocationTypeCode)
            ->setPDisabledFlag($pDisabledFlag)
            ->setPDescription($pDescription);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadLocationDescription
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadLocationDescription
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadLocationDescription
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pHubLocationDescriptionID value
     * @return int
     */
    public function getPHubLocationDescriptionID()
    {
        return $this->pHubLocationDescriptionID;
    }
    /**
     * Set pHubLocationDescriptionID value
     * @param int $pHubLocationDescriptionID
     * @return \StructType\UploadLocationDescription
     */
    public function setPHubLocationDescriptionID($pHubLocationDescriptionID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubLocationDescriptionID) && !(is_int($pHubLocationDescriptionID) || ctype_digit($pHubLocationDescriptionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubLocationDescriptionID, true), gettype($pHubLocationDescriptionID)), __LINE__);
        }
        $this->pHubLocationDescriptionID = $pHubLocationDescriptionID;
        return $this;
    }
    /**
     * Get pLocationTypeCode value
     * @return string
     */
    public function getPLocationTypeCode()
    {
        return $this->pLocationTypeCode;
    }
    /**
     * Set pLocationTypeCode value
     * @param string $pLocationTypeCode
     * @return \StructType\UploadLocationDescription
     */
    public function setPLocationTypeCode($pLocationTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($pLocationTypeCode) && !is_string($pLocationTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pLocationTypeCode, true), gettype($pLocationTypeCode)), __LINE__);
        }
        $this->pLocationTypeCode = $pLocationTypeCode;
        return $this;
    }
    /**
     * Get pDisabledFlag value
     * @return bool
     */
    public function getPDisabledFlag()
    {
        return $this->pDisabledFlag;
    }
    /**
     * Set pDisabledFlag value
     * @param bool $pDisabledFlag
     * @return \StructType\UploadLocationDescription
     */
    public function setPDisabledFlag($pDisabledFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pDisabledFlag) && !is_bool($pDisabledFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pDisabledFlag, true), gettype($pDisabledFlag)), __LINE__);
        }
        $this->pDisabledFlag = $pDisabledFlag;
        return $this;
    }
    /**
     * Get pDescription value
     * @return string|null
     */
    public function getPDescription()
    {
        return $this->pDescription;
    }
    /**
     * Set pDescription value
     * @param string $pDescription
     * @return \StructType\UploadLocationDescription
     */
    public function setPDescription($pDescription = null)
    {
        // validation for constraint: string
        if (!is_null($pDescription) && !is_string($pDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDescription, true), gettype($pDescription)), __LINE__);
        }
        $this->pDescription = $pDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadLocationDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
