<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadFileAnalytical StructType
 * @subpackage Structs
 */
class UploadFileAnalytical extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pFile;
    /**
     * The pFilename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pFilename;
    /**
     * Constructor method for UploadFileAnalytical
     * @uses UploadFileAnalytical::setPCompanyID()
     * @uses UploadFileAnalytical::setPUserID()
     * @uses UploadFileAnalytical::setPAuthKey()
     * @uses UploadFileAnalytical::setPFile()
     * @uses UploadFileAnalytical::setPFilename()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param string $pFile
     * @param string $pFilename
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pFile = null, $pFilename = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPFile($pFile)
            ->setPFilename($pFilename);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadFileAnalytical
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadFileAnalytical
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadFileAnalytical
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pFile value
     * @return string|null
     */
    public function getPFile()
    {
        return $this->pFile;
    }
    /**
     * Set pFile value
     * @param string $pFile
     * @return \StructType\UploadFileAnalytical
     */
    public function setPFile($pFile = null)
    {
        // validation for constraint: string
        if (!is_null($pFile) && !is_string($pFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pFile, true), gettype($pFile)), __LINE__);
        }
        $this->pFile = $pFile;
        return $this;
    }
    /**
     * Get pFilename value
     * @return string|null
     */
    public function getPFilename()
    {
        return $this->pFilename;
    }
    /**
     * Set pFilename value
     * @param string $pFilename
     * @return \StructType\UploadFileAnalytical
     */
    public function setPFilename($pFilename = null)
    {
        // validation for constraint: string
        if (!is_null($pFilename) && !is_string($pFilename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pFilename, true), gettype($pFilename)), __LINE__);
        }
        $this->pFilename = $pFilename;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadFileAnalytical
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
