<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadFactor StructType
 * @subpackage Structs
 */
class UploadFactor extends AbstractStructBase
{
    /**
     * The pCompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pCompanyID;
    /**
     * The pUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pUserID;
    /**
     * The pAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pAuthKey;
    /**
     * The pHubFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pHubFactorID;
    /**
     * The pScore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pScore;
    /**
     * The pType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pType;
    /**
     * The pDisabledFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pDisabledFlag;
    /**
     * The pOfficeFactorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pOfficeFactorID;
    /**
     * The pDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pDescription;
    /**
     * Constructor method for UploadFactor
     * @uses UploadFactor::setPCompanyID()
     * @uses UploadFactor::setPUserID()
     * @uses UploadFactor::setPAuthKey()
     * @uses UploadFactor::setPHubFactorID()
     * @uses UploadFactor::setPScore()
     * @uses UploadFactor::setPType()
     * @uses UploadFactor::setPDisabledFlag()
     * @uses UploadFactor::setPOfficeFactorID()
     * @uses UploadFactor::setPDescription()
     * @param int $pCompanyID
     * @param int $pUserID
     * @param int $pAuthKey
     * @param int $pHubFactorID
     * @param int $pScore
     * @param int $pType
     * @param bool $pDisabledFlag
     * @param int $pOfficeFactorID
     * @param string $pDescription
     */
    public function __construct($pCompanyID = null, $pUserID = null, $pAuthKey = null, $pHubFactorID = null, $pScore = null, $pType = null, $pDisabledFlag = null, $pOfficeFactorID = null, $pDescription = null)
    {
        $this
            ->setPCompanyID($pCompanyID)
            ->setPUserID($pUserID)
            ->setPAuthKey($pAuthKey)
            ->setPHubFactorID($pHubFactorID)
            ->setPScore($pScore)
            ->setPType($pType)
            ->setPDisabledFlag($pDisabledFlag)
            ->setPOfficeFactorID($pOfficeFactorID)
            ->setPDescription($pDescription);
    }
    /**
     * Get pCompanyID value
     * @return int
     */
    public function getPCompanyID()
    {
        return $this->pCompanyID;
    }
    /**
     * Set pCompanyID value
     * @param int $pCompanyID
     * @return \StructType\UploadFactor
     */
    public function setPCompanyID($pCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($pCompanyID) && !(is_int($pCompanyID) || ctype_digit($pCompanyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pCompanyID, true), gettype($pCompanyID)), __LINE__);
        }
        $this->pCompanyID = $pCompanyID;
        return $this;
    }
    /**
     * Get pUserID value
     * @return int
     */
    public function getPUserID()
    {
        return $this->pUserID;
    }
    /**
     * Set pUserID value
     * @param int $pUserID
     * @return \StructType\UploadFactor
     */
    public function setPUserID($pUserID = null)
    {
        // validation for constraint: int
        if (!is_null($pUserID) && !(is_int($pUserID) || ctype_digit($pUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pUserID, true), gettype($pUserID)), __LINE__);
        }
        $this->pUserID = $pUserID;
        return $this;
    }
    /**
     * Get pAuthKey value
     * @return int
     */
    public function getPAuthKey()
    {
        return $this->pAuthKey;
    }
    /**
     * Set pAuthKey value
     * @param int $pAuthKey
     * @return \StructType\UploadFactor
     */
    public function setPAuthKey($pAuthKey = null)
    {
        // validation for constraint: int
        if (!is_null($pAuthKey) && !(is_int($pAuthKey) || ctype_digit($pAuthKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pAuthKey, true), gettype($pAuthKey)), __LINE__);
        }
        $this->pAuthKey = $pAuthKey;
        return $this;
    }
    /**
     * Get pHubFactorID value
     * @return int
     */
    public function getPHubFactorID()
    {
        return $this->pHubFactorID;
    }
    /**
     * Set pHubFactorID value
     * @param int $pHubFactorID
     * @return \StructType\UploadFactor
     */
    public function setPHubFactorID($pHubFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($pHubFactorID) && !(is_int($pHubFactorID) || ctype_digit($pHubFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pHubFactorID, true), gettype($pHubFactorID)), __LINE__);
        }
        $this->pHubFactorID = $pHubFactorID;
        return $this;
    }
    /**
     * Get pScore value
     * @return int
     */
    public function getPScore()
    {
        return $this->pScore;
    }
    /**
     * Set pScore value
     * @param int $pScore
     * @return \StructType\UploadFactor
     */
    public function setPScore($pScore = null)
    {
        // validation for constraint: int
        if (!is_null($pScore) && !(is_int($pScore) || ctype_digit($pScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pScore, true), gettype($pScore)), __LINE__);
        }
        $this->pScore = $pScore;
        return $this;
    }
    /**
     * Get pType value
     * @return int
     */
    public function getPType()
    {
        return $this->pType;
    }
    /**
     * Set pType value
     * @param int $pType
     * @return \StructType\UploadFactor
     */
    public function setPType($pType = null)
    {
        // validation for constraint: int
        if (!is_null($pType) && !(is_int($pType) || ctype_digit($pType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pType, true), gettype($pType)), __LINE__);
        }
        $this->pType = $pType;
        return $this;
    }
    /**
     * Get pDisabledFlag value
     * @return bool
     */
    public function getPDisabledFlag()
    {
        return $this->pDisabledFlag;
    }
    /**
     * Set pDisabledFlag value
     * @param bool $pDisabledFlag
     * @return \StructType\UploadFactor
     */
    public function setPDisabledFlag($pDisabledFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($pDisabledFlag) && !is_bool($pDisabledFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pDisabledFlag, true), gettype($pDisabledFlag)), __LINE__);
        }
        $this->pDisabledFlag = $pDisabledFlag;
        return $this;
    }
    /**
     * Get pOfficeFactorID value
     * @return int
     */
    public function getPOfficeFactorID()
    {
        return $this->pOfficeFactorID;
    }
    /**
     * Set pOfficeFactorID value
     * @param int $pOfficeFactorID
     * @return \StructType\UploadFactor
     */
    public function setPOfficeFactorID($pOfficeFactorID = null)
    {
        // validation for constraint: int
        if (!is_null($pOfficeFactorID) && !(is_int($pOfficeFactorID) || ctype_digit($pOfficeFactorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pOfficeFactorID, true), gettype($pOfficeFactorID)), __LINE__);
        }
        $this->pOfficeFactorID = $pOfficeFactorID;
        return $this;
    }
    /**
     * Get pDescription value
     * @return string|null
     */
    public function getPDescription()
    {
        return $this->pDescription;
    }
    /**
     * Set pDescription value
     * @param string $pDescription
     * @return \StructType\UploadFactor
     */
    public function setPDescription($pDescription = null)
    {
        // validation for constraint: string
        if (!is_null($pDescription) && !is_string($pDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDescription, true), gettype($pDescription)), __LINE__);
        }
        $this->pDescription = $pDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadFactor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
