<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCompany StructType
 * @subpackage Structs
 */
class GetCompany extends AbstractStructBase
{
    /**
     * The pRegistrationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pRegistrationNumber;
    /**
     * The pUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pUserName;
    /**
     * The pAccessCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pAccessCode;
    /**
     * Constructor method for GetCompany
     * @uses GetCompany::setPRegistrationNumber()
     * @uses GetCompany::setPUserName()
     * @uses GetCompany::setPAccessCode()
     * @param int $pRegistrationNumber
     * @param string $pUserName
     * @param string $pAccessCode
     */
    public function __construct($pRegistrationNumber = null, $pUserName = null, $pAccessCode = null)
    {
        $this
            ->setPRegistrationNumber($pRegistrationNumber)
            ->setPUserName($pUserName)
            ->setPAccessCode($pAccessCode);
    }
    /**
     * Get pRegistrationNumber value
     * @return int
     */
    public function getPRegistrationNumber()
    {
        return $this->pRegistrationNumber;
    }
    /**
     * Set pRegistrationNumber value
     * @param int $pRegistrationNumber
     * @return \StructType\GetCompany
     */
    public function setPRegistrationNumber($pRegistrationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pRegistrationNumber) && !(is_int($pRegistrationNumber) || ctype_digit($pRegistrationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pRegistrationNumber, true), gettype($pRegistrationNumber)), __LINE__);
        }
        $this->pRegistrationNumber = $pRegistrationNumber;
        return $this;
    }
    /**
     * Get pUserName value
     * @return string|null
     */
    public function getPUserName()
    {
        return $this->pUserName;
    }
    /**
     * Set pUserName value
     * @param string $pUserName
     * @return \StructType\GetCompany
     */
    public function setPUserName($pUserName = null)
    {
        // validation for constraint: string
        if (!is_null($pUserName) && !is_string($pUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pUserName, true), gettype($pUserName)), __LINE__);
        }
        $this->pUserName = $pUserName;
        return $this;
    }
    /**
     * Get pAccessCode value
     * @return string|null
     */
    public function getPAccessCode()
    {
        return $this->pAccessCode;
    }
    /**
     * Set pAccessCode value
     * @param string $pAccessCode
     * @return \StructType\GetCompany
     */
    public function setPAccessCode($pAccessCode = null)
    {
        // validation for constraint: string
        if (!is_null($pAccessCode) && !is_string($pAccessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAccessCode, true), gettype($pAccessCode)), __LINE__);
        }
        $this->pAccessCode = $pAccessCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCompany
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
