<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFStagePhotoEntry StructType
 * @subpackage Structs
 */
class ClsWCFStagePhotoEntry extends AbstractStructBase
{
    /**
     * The PhotoType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PhotoType;
    /**
     * The PhotoNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PhotoNo;
    /**
     * The AirTestID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AirTestID;
    /**
     * The AirTestNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AirTestNo;
    /**
     * The CertificateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CertificateID;
    /**
     * The CertificateNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CertificateNo;
    /**
     * The ClearanceAreaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClearanceAreaID;
    /**
     * The ClearanceAreaNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClearanceAreaNo;
    /**
     * The StageNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StageNo;
    /**
     * The IsPhotoTaken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPhotoTaken;
    /**
     * The PhotoID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PhotoID;
    /**
     * The HubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSurveyID;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * Constructor method for clsWCFStagePhotoEntry
     * @uses ClsWCFStagePhotoEntry::setPhotoType()
     * @uses ClsWCFStagePhotoEntry::setPhotoNo()
     * @uses ClsWCFStagePhotoEntry::setAirTestID()
     * @uses ClsWCFStagePhotoEntry::setAirTestNo()
     * @uses ClsWCFStagePhotoEntry::setCertificateID()
     * @uses ClsWCFStagePhotoEntry::setCertificateNo()
     * @uses ClsWCFStagePhotoEntry::setClearanceAreaID()
     * @uses ClsWCFStagePhotoEntry::setClearanceAreaNo()
     * @uses ClsWCFStagePhotoEntry::setStageNo()
     * @uses ClsWCFStagePhotoEntry::setIsPhotoTaken()
     * @uses ClsWCFStagePhotoEntry::setPhotoID()
     * @uses ClsWCFStagePhotoEntry::setHubSurveyID()
     * @uses ClsWCFStagePhotoEntry::setFileName()
     * @param int $photoType
     * @param int $photoNo
     * @param int $airTestID
     * @param int $airTestNo
     * @param int $certificateID
     * @param int $certificateNo
     * @param int $clearanceAreaID
     * @param int $clearanceAreaNo
     * @param int $stageNo
     * @param bool $isPhotoTaken
     * @param int $photoID
     * @param int $hubSurveyID
     * @param string $fileName
     */
    public function __construct($photoType = null, $photoNo = null, $airTestID = null, $airTestNo = null, $certificateID = null, $certificateNo = null, $clearanceAreaID = null, $clearanceAreaNo = null, $stageNo = null, $isPhotoTaken = null, $photoID = null, $hubSurveyID = null, $fileName = null)
    {
        $this
            ->setPhotoType($photoType)
            ->setPhotoNo($photoNo)
            ->setAirTestID($airTestID)
            ->setAirTestNo($airTestNo)
            ->setCertificateID($certificateID)
            ->setCertificateNo($certificateNo)
            ->setClearanceAreaID($clearanceAreaID)
            ->setClearanceAreaNo($clearanceAreaNo)
            ->setStageNo($stageNo)
            ->setIsPhotoTaken($isPhotoTaken)
            ->setPhotoID($photoID)
            ->setHubSurveyID($hubSurveyID)
            ->setFileName($fileName);
    }
    /**
     * Get PhotoType value
     * @return int
     */
    public function getPhotoType()
    {
        return $this->PhotoType;
    }
    /**
     * Set PhotoType value
     * @param int $photoType
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setPhotoType($photoType = null)
    {
        // validation for constraint: int
        if (!is_null($photoType) && !(is_int($photoType) || ctype_digit($photoType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($photoType, true), gettype($photoType)), __LINE__);
        }
        $this->PhotoType = $photoType;
        return $this;
    }
    /**
     * Get PhotoNo value
     * @return int
     */
    public function getPhotoNo()
    {
        return $this->PhotoNo;
    }
    /**
     * Set PhotoNo value
     * @param int $photoNo
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setPhotoNo($photoNo = null)
    {
        // validation for constraint: int
        if (!is_null($photoNo) && !(is_int($photoNo) || ctype_digit($photoNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($photoNo, true), gettype($photoNo)), __LINE__);
        }
        $this->PhotoNo = $photoNo;
        return $this;
    }
    /**
     * Get AirTestID value
     * @return int
     */
    public function getAirTestID()
    {
        return $this->AirTestID;
    }
    /**
     * Set AirTestID value
     * @param int $airTestID
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setAirTestID($airTestID = null)
    {
        // validation for constraint: int
        if (!is_null($airTestID) && !(is_int($airTestID) || ctype_digit($airTestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($airTestID, true), gettype($airTestID)), __LINE__);
        }
        $this->AirTestID = $airTestID;
        return $this;
    }
    /**
     * Get AirTestNo value
     * @return int
     */
    public function getAirTestNo()
    {
        return $this->AirTestNo;
    }
    /**
     * Set AirTestNo value
     * @param int $airTestNo
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setAirTestNo($airTestNo = null)
    {
        // validation for constraint: int
        if (!is_null($airTestNo) && !(is_int($airTestNo) || ctype_digit($airTestNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($airTestNo, true), gettype($airTestNo)), __LINE__);
        }
        $this->AirTestNo = $airTestNo;
        return $this;
    }
    /**
     * Get CertificateID value
     * @return int
     */
    public function getCertificateID()
    {
        return $this->CertificateID;
    }
    /**
     * Set CertificateID value
     * @param int $certificateID
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setCertificateID($certificateID = null)
    {
        // validation for constraint: int
        if (!is_null($certificateID) && !(is_int($certificateID) || ctype_digit($certificateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($certificateID, true), gettype($certificateID)), __LINE__);
        }
        $this->CertificateID = $certificateID;
        return $this;
    }
    /**
     * Get CertificateNo value
     * @return int
     */
    public function getCertificateNo()
    {
        return $this->CertificateNo;
    }
    /**
     * Set CertificateNo value
     * @param int $certificateNo
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setCertificateNo($certificateNo = null)
    {
        // validation for constraint: int
        if (!is_null($certificateNo) && !(is_int($certificateNo) || ctype_digit($certificateNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($certificateNo, true), gettype($certificateNo)), __LINE__);
        }
        $this->CertificateNo = $certificateNo;
        return $this;
    }
    /**
     * Get ClearanceAreaID value
     * @return int
     */
    public function getClearanceAreaID()
    {
        return $this->ClearanceAreaID;
    }
    /**
     * Set ClearanceAreaID value
     * @param int $clearanceAreaID
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setClearanceAreaID($clearanceAreaID = null)
    {
        // validation for constraint: int
        if (!is_null($clearanceAreaID) && !(is_int($clearanceAreaID) || ctype_digit($clearanceAreaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clearanceAreaID, true), gettype($clearanceAreaID)), __LINE__);
        }
        $this->ClearanceAreaID = $clearanceAreaID;
        return $this;
    }
    /**
     * Get ClearanceAreaNo value
     * @return int
     */
    public function getClearanceAreaNo()
    {
        return $this->ClearanceAreaNo;
    }
    /**
     * Set ClearanceAreaNo value
     * @param int $clearanceAreaNo
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setClearanceAreaNo($clearanceAreaNo = null)
    {
        // validation for constraint: int
        if (!is_null($clearanceAreaNo) && !(is_int($clearanceAreaNo) || ctype_digit($clearanceAreaNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clearanceAreaNo, true), gettype($clearanceAreaNo)), __LINE__);
        }
        $this->ClearanceAreaNo = $clearanceAreaNo;
        return $this;
    }
    /**
     * Get StageNo value
     * @return int
     */
    public function getStageNo()
    {
        return $this->StageNo;
    }
    /**
     * Set StageNo value
     * @param int $stageNo
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setStageNo($stageNo = null)
    {
        // validation for constraint: int
        if (!is_null($stageNo) && !(is_int($stageNo) || ctype_digit($stageNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stageNo, true), gettype($stageNo)), __LINE__);
        }
        $this->StageNo = $stageNo;
        return $this;
    }
    /**
     * Get IsPhotoTaken value
     * @return bool
     */
    public function getIsPhotoTaken()
    {
        return $this->IsPhotoTaken;
    }
    /**
     * Set IsPhotoTaken value
     * @param bool $isPhotoTaken
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setIsPhotoTaken($isPhotoTaken = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPhotoTaken) && !is_bool($isPhotoTaken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPhotoTaken, true), gettype($isPhotoTaken)), __LINE__);
        }
        $this->IsPhotoTaken = $isPhotoTaken;
        return $this;
    }
    /**
     * Get PhotoID value
     * @return int
     */
    public function getPhotoID()
    {
        return $this->PhotoID;
    }
    /**
     * Set PhotoID value
     * @param int $photoID
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setPhotoID($photoID = null)
    {
        // validation for constraint: int
        if (!is_null($photoID) && !(is_int($photoID) || ctype_digit($photoID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($photoID, true), gettype($photoID)), __LINE__);
        }
        $this->PhotoID = $photoID;
        return $this;
    }
    /**
     * Get HubSurveyID value
     * @return int
     */
    public function getHubSurveyID()
    {
        return $this->HubSurveyID;
    }
    /**
     * Set HubSurveyID value
     * @param int $hubSurveyID
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setHubSurveyID($hubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSurveyID) && !(is_int($hubSurveyID) || ctype_digit($hubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSurveyID, true), gettype($hubSurveyID)), __LINE__);
        }
        $this->HubSurveyID = $hubSurveyID;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFStagePhotoEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
