<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFEmailEntry StructType
 * @subpackage Structs
 */
class ClsWCFEmailEntry extends AbstractStructBase
{
    /**
     * The EmailNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EmailNo;
    /**
     * The HubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSurveyID;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * Constructor method for clsWCFEmailEntry
     * @uses ClsWCFEmailEntry::setEmailNo()
     * @uses ClsWCFEmailEntry::setHubSurveyID()
     * @uses ClsWCFEmailEntry::setEMailAddress()
     * @uses ClsWCFEmailEntry::setCompanyName()
     * @param int $emailNo
     * @param int $hubSurveyID
     * @param string $eMailAddress
     * @param string $companyName
     */
    public function __construct($emailNo = null, $hubSurveyID = null, $eMailAddress = null, $companyName = null)
    {
        $this
            ->setEmailNo($emailNo)
            ->setHubSurveyID($hubSurveyID)
            ->setEMailAddress($eMailAddress)
            ->setCompanyName($companyName);
    }
    /**
     * Get EmailNo value
     * @return int
     */
    public function getEmailNo()
    {
        return $this->EmailNo;
    }
    /**
     * Set EmailNo value
     * @param int $emailNo
     * @return \StructType\ClsWCFEmailEntry
     */
    public function setEmailNo($emailNo = null)
    {
        // validation for constraint: int
        if (!is_null($emailNo) && !(is_int($emailNo) || ctype_digit($emailNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emailNo, true), gettype($emailNo)), __LINE__);
        }
        $this->EmailNo = $emailNo;
        return $this;
    }
    /**
     * Get HubSurveyID value
     * @return int
     */
    public function getHubSurveyID()
    {
        return $this->HubSurveyID;
    }
    /**
     * Set HubSurveyID value
     * @param int $hubSurveyID
     * @return \StructType\ClsWCFEmailEntry
     */
    public function setHubSurveyID($hubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSurveyID) && !(is_int($hubSurveyID) || ctype_digit($hubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSurveyID, true), gettype($hubSurveyID)), __LINE__);
        }
        $this->HubSurveyID = $hubSurveyID;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \StructType\ClsWCFEmailEntry
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\ClsWCFEmailEntry
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFEmailEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
