<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFDiaryEntry StructType
 * @subpackage Structs
 */
class ClsWCFDiaryEntry extends AbstractStructBase
{
    /**
     * The HubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSurveyID;
    /**
     * The DiaryEntryNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DiaryEntryNo;
    /**
     * The DiaryEntryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DiaryEntryTime;
    /**
     * The DiaryEntryText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiaryEntryText;
    /**
     * Constructor method for clsWCFDiaryEntry
     * @uses ClsWCFDiaryEntry::setHubSurveyID()
     * @uses ClsWCFDiaryEntry::setDiaryEntryNo()
     * @uses ClsWCFDiaryEntry::setDiaryEntryTime()
     * @uses ClsWCFDiaryEntry::setDiaryEntryText()
     * @param int $hubSurveyID
     * @param int $diaryEntryNo
     * @param string $diaryEntryTime
     * @param string $diaryEntryText
     */
    public function __construct($hubSurveyID = null, $diaryEntryNo = null, $diaryEntryTime = null, $diaryEntryText = null)
    {
        $this
            ->setHubSurveyID($hubSurveyID)
            ->setDiaryEntryNo($diaryEntryNo)
            ->setDiaryEntryTime($diaryEntryTime)
            ->setDiaryEntryText($diaryEntryText);
    }
    /**
     * Get HubSurveyID value
     * @return int
     */
    public function getHubSurveyID()
    {
        return $this->HubSurveyID;
    }
    /**
     * Set HubSurveyID value
     * @param int $hubSurveyID
     * @return \StructType\ClsWCFDiaryEntry
     */
    public function setHubSurveyID($hubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSurveyID) && !(is_int($hubSurveyID) || ctype_digit($hubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSurveyID, true), gettype($hubSurveyID)), __LINE__);
        }
        $this->HubSurveyID = $hubSurveyID;
        return $this;
    }
    /**
     * Get DiaryEntryNo value
     * @return int
     */
    public function getDiaryEntryNo()
    {
        return $this->DiaryEntryNo;
    }
    /**
     * Set DiaryEntryNo value
     * @param int $diaryEntryNo
     * @return \StructType\ClsWCFDiaryEntry
     */
    public function setDiaryEntryNo($diaryEntryNo = null)
    {
        // validation for constraint: int
        if (!is_null($diaryEntryNo) && !(is_int($diaryEntryNo) || ctype_digit($diaryEntryNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($diaryEntryNo, true), gettype($diaryEntryNo)), __LINE__);
        }
        $this->DiaryEntryNo = $diaryEntryNo;
        return $this;
    }
    /**
     * Get DiaryEntryTime value
     * @return string
     */
    public function getDiaryEntryTime()
    {
        return $this->DiaryEntryTime;
    }
    /**
     * Set DiaryEntryTime value
     * @param string $diaryEntryTime
     * @return \StructType\ClsWCFDiaryEntry
     */
    public function setDiaryEntryTime($diaryEntryTime = null)
    {
        // validation for constraint: string
        if (!is_null($diaryEntryTime) && !is_string($diaryEntryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($diaryEntryTime, true), gettype($diaryEntryTime)), __LINE__);
        }
        $this->DiaryEntryTime = $diaryEntryTime;
        return $this;
    }
    /**
     * Get DiaryEntryText value
     * @return string|null
     */
    public function getDiaryEntryText()
    {
        return $this->DiaryEntryText;
    }
    /**
     * Set DiaryEntryText value
     * @param string $diaryEntryText
     * @return \StructType\ClsWCFDiaryEntry
     */
    public function setDiaryEntryText($diaryEntryText = null)
    {
        // validation for constraint: string
        if (!is_null($diaryEntryText) && !is_string($diaryEntryText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($diaryEntryText, true), gettype($diaryEntryText)), __LINE__);
        }
        $this->DiaryEntryText = $diaryEntryText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFDiaryEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
