<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFClearanceAreaEntry StructType
 * @subpackage Structs
 */
class ClsWCFClearanceAreaEntry extends AbstractStructBase
{
    /**
     * The HubSurveyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HubSurveyID;
    /**
     * The AreaNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AreaNo;
    /**
     * The AreaIsComplete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AreaIsComplete;
    /**
     * The AreaLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaLocation;
    /**
     * The AreaACMRemoved
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaACMRemoved;
    /**
     * The AreaRepresentative
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaRepresentative;
    /**
     * The AreaAnticDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaAnticDate;
    /**
     * The AreaAnticTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaAnticTime;
    /**
     * The AreaActualDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaActualDate;
    /**
     * The AreaActualTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaActualTime;
    /**
     * The AreaDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaDuration;
    /**
     * The CertificateEntries
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClsWCFCertificateEntry
     */
    public $CertificateEntries;
    /**
     * Constructor method for clsWCFClearanceAreaEntry
     * @uses ClsWCFClearanceAreaEntry::setHubSurveyID()
     * @uses ClsWCFClearanceAreaEntry::setAreaNo()
     * @uses ClsWCFClearanceAreaEntry::setAreaIsComplete()
     * @uses ClsWCFClearanceAreaEntry::setAreaLocation()
     * @uses ClsWCFClearanceAreaEntry::setAreaACMRemoved()
     * @uses ClsWCFClearanceAreaEntry::setAreaRepresentative()
     * @uses ClsWCFClearanceAreaEntry::setAreaAnticDate()
     * @uses ClsWCFClearanceAreaEntry::setAreaAnticTime()
     * @uses ClsWCFClearanceAreaEntry::setAreaActualDate()
     * @uses ClsWCFClearanceAreaEntry::setAreaActualTime()
     * @uses ClsWCFClearanceAreaEntry::setAreaDuration()
     * @uses ClsWCFClearanceAreaEntry::setCertificateEntries()
     * @param int $hubSurveyID
     * @param int $areaNo
     * @param bool $areaIsComplete
     * @param string $areaLocation
     * @param string $areaACMRemoved
     * @param string $areaRepresentative
     * @param string $areaAnticDate
     * @param string $areaAnticTime
     * @param string $areaActualDate
     * @param string $areaActualTime
     * @param string $areaDuration
     * @param \ArrayType\ArrayOfClsWCFCertificateEntry $certificateEntries
     */
    public function __construct($hubSurveyID = null, $areaNo = null, $areaIsComplete = null, $areaLocation = null, $areaACMRemoved = null, $areaRepresentative = null, $areaAnticDate = null, $areaAnticTime = null, $areaActualDate = null, $areaActualTime = null, $areaDuration = null, \ArrayType\ArrayOfClsWCFCertificateEntry $certificateEntries = null)
    {
        $this
            ->setHubSurveyID($hubSurveyID)
            ->setAreaNo($areaNo)
            ->setAreaIsComplete($areaIsComplete)
            ->setAreaLocation($areaLocation)
            ->setAreaACMRemoved($areaACMRemoved)
            ->setAreaRepresentative($areaRepresentative)
            ->setAreaAnticDate($areaAnticDate)
            ->setAreaAnticTime($areaAnticTime)
            ->setAreaActualDate($areaActualDate)
            ->setAreaActualTime($areaActualTime)
            ->setAreaDuration($areaDuration)
            ->setCertificateEntries($certificateEntries);
    }
    /**
     * Get HubSurveyID value
     * @return int
     */
    public function getHubSurveyID()
    {
        return $this->HubSurveyID;
    }
    /**
     * Set HubSurveyID value
     * @param int $hubSurveyID
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setHubSurveyID($hubSurveyID = null)
    {
        // validation for constraint: int
        if (!is_null($hubSurveyID) && !(is_int($hubSurveyID) || ctype_digit($hubSurveyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubSurveyID, true), gettype($hubSurveyID)), __LINE__);
        }
        $this->HubSurveyID = $hubSurveyID;
        return $this;
    }
    /**
     * Get AreaNo value
     * @return int
     */
    public function getAreaNo()
    {
        return $this->AreaNo;
    }
    /**
     * Set AreaNo value
     * @param int $areaNo
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setAreaNo($areaNo = null)
    {
        // validation for constraint: int
        if (!is_null($areaNo) && !(is_int($areaNo) || ctype_digit($areaNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($areaNo, true), gettype($areaNo)), __LINE__);
        }
        $this->AreaNo = $areaNo;
        return $this;
    }
    /**
     * Get AreaIsComplete value
     * @return bool
     */
    public function getAreaIsComplete()
    {
        return $this->AreaIsComplete;
    }
    /**
     * Set AreaIsComplete value
     * @param bool $areaIsComplete
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setAreaIsComplete($areaIsComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($areaIsComplete) && !is_bool($areaIsComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($areaIsComplete, true), gettype($areaIsComplete)), __LINE__);
        }
        $this->AreaIsComplete = $areaIsComplete;
        return $this;
    }
    /**
     * Get AreaLocation value
     * @return string|null
     */
    public function getAreaLocation()
    {
        return $this->AreaLocation;
    }
    /**
     * Set AreaLocation value
     * @param string $areaLocation
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setAreaLocation($areaLocation = null)
    {
        // validation for constraint: string
        if (!is_null($areaLocation) && !is_string($areaLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaLocation, true), gettype($areaLocation)), __LINE__);
        }
        $this->AreaLocation = $areaLocation;
        return $this;
    }
    /**
     * Get AreaACMRemoved value
     * @return string|null
     */
    public function getAreaACMRemoved()
    {
        return $this->AreaACMRemoved;
    }
    /**
     * Set AreaACMRemoved value
     * @param string $areaACMRemoved
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setAreaACMRemoved($areaACMRemoved = null)
    {
        // validation for constraint: string
        if (!is_null($areaACMRemoved) && !is_string($areaACMRemoved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaACMRemoved, true), gettype($areaACMRemoved)), __LINE__);
        }
        $this->AreaACMRemoved = $areaACMRemoved;
        return $this;
    }
    /**
     * Get AreaRepresentative value
     * @return string|null
     */
    public function getAreaRepresentative()
    {
        return $this->AreaRepresentative;
    }
    /**
     * Set AreaRepresentative value
     * @param string $areaRepresentative
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setAreaRepresentative($areaRepresentative = null)
    {
        // validation for constraint: string
        if (!is_null($areaRepresentative) && !is_string($areaRepresentative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaRepresentative, true), gettype($areaRepresentative)), __LINE__);
        }
        $this->AreaRepresentative = $areaRepresentative;
        return $this;
    }
    /**
     * Get AreaAnticDate value
     * @return string|null
     */
    public function getAreaAnticDate()
    {
        return $this->AreaAnticDate;
    }
    /**
     * Set AreaAnticDate value
     * @param string $areaAnticDate
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setAreaAnticDate($areaAnticDate = null)
    {
        // validation for constraint: string
        if (!is_null($areaAnticDate) && !is_string($areaAnticDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaAnticDate, true), gettype($areaAnticDate)), __LINE__);
        }
        $this->AreaAnticDate = $areaAnticDate;
        return $this;
    }
    /**
     * Get AreaAnticTime value
     * @return string|null
     */
    public function getAreaAnticTime()
    {
        return $this->AreaAnticTime;
    }
    /**
     * Set AreaAnticTime value
     * @param string $areaAnticTime
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setAreaAnticTime($areaAnticTime = null)
    {
        // validation for constraint: string
        if (!is_null($areaAnticTime) && !is_string($areaAnticTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaAnticTime, true), gettype($areaAnticTime)), __LINE__);
        }
        $this->AreaAnticTime = $areaAnticTime;
        return $this;
    }
    /**
     * Get AreaActualDate value
     * @return string|null
     */
    public function getAreaActualDate()
    {
        return $this->AreaActualDate;
    }
    /**
     * Set AreaActualDate value
     * @param string $areaActualDate
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setAreaActualDate($areaActualDate = null)
    {
        // validation for constraint: string
        if (!is_null($areaActualDate) && !is_string($areaActualDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaActualDate, true), gettype($areaActualDate)), __LINE__);
        }
        $this->AreaActualDate = $areaActualDate;
        return $this;
    }
    /**
     * Get AreaActualTime value
     * @return string|null
     */
    public function getAreaActualTime()
    {
        return $this->AreaActualTime;
    }
    /**
     * Set AreaActualTime value
     * @param string $areaActualTime
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setAreaActualTime($areaActualTime = null)
    {
        // validation for constraint: string
        if (!is_null($areaActualTime) && !is_string($areaActualTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaActualTime, true), gettype($areaActualTime)), __LINE__);
        }
        $this->AreaActualTime = $areaActualTime;
        return $this;
    }
    /**
     * Get AreaDuration value
     * @return string|null
     */
    public function getAreaDuration()
    {
        return $this->AreaDuration;
    }
    /**
     * Set AreaDuration value
     * @param string $areaDuration
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setAreaDuration($areaDuration = null)
    {
        // validation for constraint: string
        if (!is_null($areaDuration) && !is_string($areaDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaDuration, true), gettype($areaDuration)), __LINE__);
        }
        $this->AreaDuration = $areaDuration;
        return $this;
    }
    /**
     * Get CertificateEntries value
     * @return \ArrayType\ArrayOfClsWCFCertificateEntry|null
     */
    public function getCertificateEntries()
    {
        return $this->CertificateEntries;
    }
    /**
     * Set CertificateEntries value
     * @param \ArrayType\ArrayOfClsWCFCertificateEntry $certificateEntries
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public function setCertificateEntries(\ArrayType\ArrayOfClsWCFCertificateEntry $certificateEntries = null)
    {
        $this->CertificateEntries = $certificateEntries;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFClearanceAreaEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
