<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsWCFChunkByteArrayMessage StructType
 * @subpackage Structs
 */
class ClsWCFChunkByteArrayMessage extends AbstractStructBase
{
    /**
     * The ChunkNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChunkNo;
    /**
     * The FileSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FileSize;
    /**
     * The NextAuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NextAuthCode;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ReturnValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnValue;
    /**
     * Constructor method for clsWCFChunkByteArrayMessage
     * @uses ClsWCFChunkByteArrayMessage::setChunkNo()
     * @uses ClsWCFChunkByteArrayMessage::setFileSize()
     * @uses ClsWCFChunkByteArrayMessage::setNextAuthCode()
     * @uses ClsWCFChunkByteArrayMessage::setErrorMessage()
     * @uses ClsWCFChunkByteArrayMessage::setReturnValue()
     * @param int $chunkNo
     * @param int $fileSize
     * @param string $nextAuthCode
     * @param string $errorMessage
     * @param string $returnValue
     */
    public function __construct($chunkNo = null, $fileSize = null, $nextAuthCode = null, $errorMessage = null, $returnValue = null)
    {
        $this
            ->setChunkNo($chunkNo)
            ->setFileSize($fileSize)
            ->setNextAuthCode($nextAuthCode)
            ->setErrorMessage($errorMessage)
            ->setReturnValue($returnValue);
    }
    /**
     * Get ChunkNo value
     * @return int
     */
    public function getChunkNo()
    {
        return $this->ChunkNo;
    }
    /**
     * Set ChunkNo value
     * @param int $chunkNo
     * @return \StructType\ClsWCFChunkByteArrayMessage
     */
    public function setChunkNo($chunkNo = null)
    {
        // validation for constraint: int
        if (!is_null($chunkNo) && !(is_int($chunkNo) || ctype_digit($chunkNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chunkNo, true), gettype($chunkNo)), __LINE__);
        }
        $this->ChunkNo = $chunkNo;
        return $this;
    }
    /**
     * Get FileSize value
     * @return int
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param int $fileSize
     * @return \StructType\ClsWCFChunkByteArrayMessage
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Get NextAuthCode value
     * @return string|null
     */
    public function getNextAuthCode()
    {
        return $this->NextAuthCode;
    }
    /**
     * Set NextAuthCode value
     * @param string $nextAuthCode
     * @return \StructType\ClsWCFChunkByteArrayMessage
     */
    public function setNextAuthCode($nextAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($nextAuthCode) && !is_string($nextAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextAuthCode, true), gettype($nextAuthCode)), __LINE__);
        }
        $this->NextAuthCode = $nextAuthCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\ClsWCFChunkByteArrayMessage
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get ReturnValue value
     * @return string|null
     */
    public function getReturnValue()
    {
        return $this->ReturnValue;
    }
    /**
     * Set ReturnValue value
     * @param string $returnValue
     * @return \StructType\ClsWCFChunkByteArrayMessage
     */
    public function setReturnValue($returnValue = null)
    {
        // validation for constraint: string
        if (!is_null($returnValue) && !is_string($returnValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnValue, true), gettype($returnValue)), __LINE__);
        }
        $this->ReturnValue = $returnValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsWCFChunkByteArrayMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
