<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @subpackage Services
 */
class Upload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UploadSamples
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadSamples $parameters
     * @return \StructType\UploadSamplesResponse|bool
     */
    public function UploadSamples(\StructType\UploadSamples $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadSamples($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadAssets
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadAssets $parameters
     * @return \StructType\UploadAssetsResponse|bool
     */
    public function UploadAssets(\StructType\UploadAssets $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadAssets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadAndroidAssets
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadAndroidAssets $parameters
     * @return \StructType\UploadAndroidAssetsResponse|bool
     */
    public function UploadAndroidAssets(\StructType\UploadAndroidAssets $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadAndroidAssets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadAssetAnswers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadAssetAnswers $parameters
     * @return \StructType\UploadAssetAnswersResponse|bool
     */
    public function UploadAssetAnswers(\StructType\UploadAssetAnswers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadAssetAnswers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadSurveyorLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadSurveyorLocation $parameters
     * @return \StructType\UploadSurveyorLocationResponse|bool
     */
    public function UploadSurveyorLocation(\StructType\UploadSurveyorLocation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadSurveyorLocation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadSurvey
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadSurvey $parameters
     * @return \StructType\UploadSurveyResponse|bool
     */
    public function UploadSurvey(\StructType\UploadSurvey $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadSurvey($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadSurveyRisks
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadSurveyRisks $parameters
     * @return \StructType\UploadSurveyRisksResponse|bool
     */
    public function UploadSurveyRisks(\StructType\UploadSurveyRisks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadSurveyRisks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadTapsPipes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadTapsPipes $parameters
     * @return \StructType\UploadTapsPipesResponse|bool
     */
    public function UploadTapsPipes(\StructType\UploadTapsPipes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadTapsPipes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadQuestionnaire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadQuestionnaire $parameters
     * @return \StructType\UploadQuestionnaireResponse|bool
     */
    public function UploadQuestionnaire(\StructType\UploadQuestionnaire $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadQuestionnaire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadQuestionnaireFire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadQuestionnaireFire $parameters
     * @return \StructType\UploadQuestionnaireFireResponse|bool
     */
    public function UploadQuestionnaireFire(\StructType\UploadQuestionnaireFire $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadQuestionnaireFire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFlatFire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFlatFire $parameters
     * @return \StructType\UploadFlatFireResponse|bool
     */
    public function UploadFlatFire(\StructType\UploadFlatFire $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFlatFire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadJobOperatives
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadJobOperatives $parameters
     * @return \StructType\UploadJobOperativesResponse|bool
     */
    public function UploadJobOperatives(\StructType\UploadJobOperatives $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadJobOperatives($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadCalibrations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadCalibrations $parameters
     * @return \StructType\UploadCalibrationsResponse|bool
     */
    public function UploadCalibrations(\StructType\UploadCalibrations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadCalibrations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadStagePhotoList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadStagePhotoList $parameters
     * @return \StructType\UploadStagePhotoListResponse|bool
     */
    public function UploadStagePhotoList(\StructType\UploadStagePhotoList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadStagePhotoList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadDiaryEntries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadDiaryEntries $parameters
     * @return \StructType\UploadDiaryEntriesResponse|bool
     */
    public function UploadDiaryEntries(\StructType\UploadDiaryEntries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadDiaryEntries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadAdditionalAnalysts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadAdditionalAnalysts $parameters
     * @return \StructType\UploadAdditionalAnalystsResponse|bool
     */
    public function UploadAdditionalAnalysts(\StructType\UploadAdditionalAnalysts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadAdditionalAnalysts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadAirTests
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadAirTests $parameters
     * @return \StructType\UploadAirTestsResponse|bool
     */
    public function UploadAirTests(\StructType\UploadAirTests $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadAirTests($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadClearanceAreas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadClearanceAreas $parameters
     * @return \StructType\UploadClearanceAreasResponse|bool
     */
    public function UploadClearanceAreas(\StructType\UploadClearanceAreas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadClearanceAreas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadErrorMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadErrorMessages $parameters
     * @return \StructType\UploadErrorMessagesResponse|bool
     */
    public function UploadErrorMessages(\StructType\UploadErrorMessages $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadErrorMessages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFile $parameters
     * @return \StructType\UploadFileResponse|bool
     */
    public function UploadFile(\StructType\UploadFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFileAnalytical
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFileAnalytical $parameters
     * @return \StructType\UploadFileAnalyticalResponse|bool
     */
    public function UploadFileAnalytical(\StructType\UploadFileAnalytical $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFileAnalytical($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadAndroidSamples
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadAndroidSamples $parameters
     * @return \StructType\UploadAndroidSamplesResponse|bool
     */
    public function UploadAndroidSamples(\StructType\UploadAndroidSamples $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadAndroidSamples($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadActionDescription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadActionDescription $parameters
     * @return \StructType\UploadActionDescriptionResponse|bool
     */
    public function UploadActionDescription(\StructType\UploadActionDescription $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadActionDescription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadFactor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadFactor $parameters
     * @return \StructType\UploadFactorResponse|bool
     */
    public function UploadFactor(\StructType\UploadFactor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadFactor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadLab
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadLab $parameters
     * @return \StructType\UploadLabResponse|bool
     */
    public function UploadLab(\StructType\UploadLab $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadLab($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadRisk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadRisk $parameters
     * @return \StructType\UploadRiskResponse|bool
     */
    public function UploadRisk(\StructType\UploadRisk $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadRisk($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadReInspectionItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadReInspectionItem $parameters
     * @return \StructType\UploadReInspectionItemResponse|bool
     */
    public function UploadReInspectionItem(\StructType\UploadReInspectionItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadReInspectionItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadScheme
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadScheme $parameters
     * @return \StructType\UploadSchemeResponse|bool
     */
    public function UploadScheme(\StructType\UploadScheme $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadScheme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadLocationDescription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadLocationDescription $parameters
     * @return \StructType\UploadLocationDescriptionResponse|bool
     */
    public function UploadLocationDescription(\StructType\UploadLocationDescription $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadLocationDescription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadNoAccessReason
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadNoAccessReason $parameters
     * @return \StructType\UploadNoAccessReasonResponse|bool
     */
    public function UploadNoAccessReason(\StructType\UploadNoAccessReason $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadNoAccessReason($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadQuestion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadQuestion $parameters
     * @return \StructType\UploadQuestionResponse|bool
     */
    public function UploadQuestion(\StructType\UploadQuestion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadQuestion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadQuestionFire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadQuestionFire $parameters
     * @return \StructType\UploadQuestionFireResponse|bool
     */
    public function UploadQuestionFire(\StructType\UploadQuestionFire $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadQuestionFire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadAssetType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadAssetType $parameters
     * @return \StructType\UploadAssetTypeResponse|bool
     */
    public function UploadAssetType(\StructType\UploadAssetType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadAssetType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadCompanySettings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadCompanySettings $parameters
     * @return \StructType\UploadCompanySettingsResponse|bool
     */
    public function UploadCompanySettings(\StructType\UploadCompanySettings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadCompanySettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadRecommendationDescription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadRecommendationDescription $parameters
     * @return \StructType\UploadRecommendationDescriptionResponse|bool
     */
    public function UploadRecommendationDescription(\StructType\UploadRecommendationDescription $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadRecommendationDescription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadSection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadSection $parameters
     * @return \StructType\UploadSectionResponse|bool
     */
    public function UploadSection(\StructType\UploadSection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadSection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadSelection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadSelection $parameters
     * @return \StructType\UploadSelectionResponse|bool
     */
    public function UploadSelection(\StructType\UploadSelection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadSelection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadSelectionFire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadSelectionFire $parameters
     * @return \StructType\UploadSelectionFireResponse|bool
     */
    public function UploadSelectionFire(\StructType\UploadSelectionFire $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadSelectionFire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadSurveyor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadSurveyor $parameters
     * @return \StructType\UploadSurveyorResponse|bool
     */
    public function UploadSurveyor(\StructType\UploadSurveyor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadSurveyor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadJob $parameters
     * @return \StructType\UploadJobResponse|bool
     */
    public function UploadJob(\StructType\UploadJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadUnit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadUnit $parameters
     * @return \StructType\UploadUnitResponse|bool
     */
    public function UploadUnit(\StructType\UploadUnit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadUnit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadWaterSystemType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadWaterSystemType $parameters
     * @return \StructType\UploadWaterSystemTypeResponse|bool
     */
    public function UploadWaterSystemType(\StructType\UploadWaterSystemType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadWaterSystemType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UploadActionDescriptionResponse|\StructType\UploadAdditionalAnalystsResponse|\StructType\UploadAirTestsResponse|\StructType\UploadAndroidAssetsResponse|\StructType\UploadAndroidSamplesResponse|\StructType\UploadAssetAnswersResponse|\StructType\UploadAssetsResponse|\StructType\UploadAssetTypeResponse|\StructType\UploadCalibrationsResponse|\StructType\UploadClearanceAreasResponse|\StructType\UploadCompanySettingsResponse|\StructType\UploadDiaryEntriesResponse|\StructType\UploadErrorMessagesResponse|\StructType\UploadFactorResponse|\StructType\UploadFileAnalyticalResponse|\StructType\UploadFileResponse|\StructType\UploadFlatFireResponse|\StructType\UploadJobOperativesResponse|\StructType\UploadJobResponse|\StructType\UploadLabResponse|\StructType\UploadLocationDescriptionResponse|\StructType\UploadNoAccessReasonResponse|\StructType\UploadQuestionFireResponse|\StructType\UploadQuestionnaireFireResponse|\StructType\UploadQuestionnaireResponse|\StructType\UploadQuestionResponse|\StructType\UploadRecommendationDescriptionResponse|\StructType\UploadReInspectionItemResponse|\StructType\UploadRiskResponse|\StructType\UploadSamplesResponse|\StructType\UploadSchemeResponse|\StructType\UploadSectionResponse|\StructType\UploadSelectionFireResponse|\StructType\UploadSelectionResponse|\StructType\UploadStagePhotoListResponse|\StructType\UploadSurveyorLocationResponse|\StructType\UploadSurveyorResponse|\StructType\UploadSurveyResponse|\StructType\UploadSurveyRisksResponse|\StructType\UploadTapsPipesResponse|\StructType\UploadUnitResponse|\StructType\UploadWaterSystemTypeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
