<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Request ServiceType
 * @subpackage Services
 */
class Request extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RequestAppCurrentVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RequestAppCurrentVersion $parameters
     * @return \StructType\RequestAppCurrentVersionResponse|bool
     */
    public function RequestAppCurrentVersion(\StructType\RequestAppCurrentVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RequestAppCurrentVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestCompanyLinkCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RequestCompanyLinkCode $parameters
     * @return \StructType\RequestCompanyLinkCodeResponse|bool
     */
    public function RequestCompanyLinkCode(\StructType\RequestCompanyLinkCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RequestCompanyLinkCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RequestAppCurrentVersionResponse|\StructType\RequestCompanyLinkCodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
