<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Read ServiceType
 * @subpackage Services
 */
class Read extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReadSurveyorLocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadSurveyorLocations $parameters
     * @return \StructType\ReadSurveyorLocationsResponse|bool
     */
    public function ReadSurveyorLocations(\StructType\ReadSurveyorLocations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadSurveyorLocations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadErrors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadErrors $parameters
     * @return \StructType\ReadErrorsResponse|bool
     */
    public function ReadErrors(\StructType\ReadErrors $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadErrors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadAnswers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadAnswers $parameters
     * @return \StructType\ReadAnswersResponse|bool
     */
    public function ReadAnswers(\StructType\ReadAnswers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadAnswers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadFlats
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadFlats $parameters
     * @return \StructType\ReadFlatsResponse|bool
     */
    public function ReadFlats(\StructType\ReadFlats $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadFlats($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadCalibrations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadCalibrations $parameters
     * @return \StructType\ReadCalibrationsResponse|bool
     */
    public function ReadCalibrations(\StructType\ReadCalibrations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadCalibrations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEMails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadEMails $parameters
     * @return \StructType\ReadEMailsResponse|bool
     */
    public function ReadEMails(\StructType\ReadEMails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEMails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadClearanceAreas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadClearanceAreas $parameters
     * @return \StructType\ReadClearanceAreasResponse|bool
     */
    public function ReadClearanceAreas(\StructType\ReadClearanceAreas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadClearanceAreas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadCertificates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadCertificates $parameters
     * @return \StructType\ReadCertificatesResponse|bool
     */
    public function ReadCertificates(\StructType\ReadCertificates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadCertificates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadStagePhotoList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadStagePhotoList $parameters
     * @return \StructType\ReadStagePhotoListResponse|bool
     */
    public function ReadStagePhotoList(\StructType\ReadStagePhotoList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadStagePhotoList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadDiaryEntries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadDiaryEntries $parameters
     * @return \StructType\ReadDiaryEntriesResponse|bool
     */
    public function ReadDiaryEntries(\StructType\ReadDiaryEntries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadDiaryEntries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadAnalystEntries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadAnalystEntries $parameters
     * @return \StructType\ReadAnalystEntriesResponse|bool
     */
    public function ReadAnalystEntries(\StructType\ReadAnalystEntries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadAnalystEntries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadAirTests
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadAirTests $parameters
     * @return \StructType\ReadAirTestsResponse|bool
     */
    public function ReadAirTests(\StructType\ReadAirTests $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadAirTests($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadAssetAnswers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadAssetAnswers $parameters
     * @return \StructType\ReadAssetAnswersResponse|bool
     */
    public function ReadAssetAnswers(\StructType\ReadAssetAnswers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadAssetAnswers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadSurveyRisks
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadSurveyRisks $parameters
     * @return \StructType\ReadSurveyRisksResponse|bool
     */
    public function ReadSurveyRisks(\StructType\ReadSurveyRisks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadSurveyRisks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadSamples
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadSamples $parameters
     * @return \StructType\ReadSamplesResponse|bool
     */
    public function ReadSamples(\StructType\ReadSamples $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadSamples($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadAssets
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadAssets $parameters
     * @return \StructType\ReadAssetsResponse|bool
     */
    public function ReadAssets(\StructType\ReadAssets $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadAssets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadSurveysReadyForDownload
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadSurveysReadyForDownload $parameters
     * @return \StructType\ReadSurveysReadyForDownloadResponse|bool
     */
    public function ReadSurveysReadyForDownload(\StructType\ReadSurveysReadyForDownload $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadSurveysReadyForDownload($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadWaterPipes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadWaterPipes $parameters
     * @return \StructType\ReadWaterPipesResponse|bool
     */
    public function ReadWaterPipes(\StructType\ReadWaterPipes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadWaterPipes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadStopTaps
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadStopTaps $parameters
     * @return \StructType\ReadStopTapsResponse|bool
     */
    public function ReadStopTaps(\StructType\ReadStopTaps $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadStopTaps($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadSurveysForSurveyor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadSurveysForSurveyor $parameters
     * @return \StructType\ReadSurveysForSurveyorResponse|bool
     */
    public function ReadSurveysForSurveyor(\StructType\ReadSurveysForSurveyor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadSurveysForSurveyor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadLookups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReadLookups $parameters
     * @return \StructType\ReadLookupsResponse|bool
     */
    public function ReadLookups(\StructType\ReadLookups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadLookups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReadAirTestsResponse|\StructType\ReadAnalystEntriesResponse|\StructType\ReadAnswersResponse|\StructType\ReadAssetAnswersResponse|\StructType\ReadAssetsResponse|\StructType\ReadCalibrationsResponse|\StructType\ReadCertificatesResponse|\StructType\ReadClearanceAreasResponse|\StructType\ReadDiaryEntriesResponse|\StructType\ReadEMailsResponse|\StructType\ReadErrorsResponse|\StructType\ReadFlatsResponse|\StructType\ReadLookupsResponse|\StructType\ReadSamplesResponse|\StructType\ReadStagePhotoListResponse|\StructType\ReadStopTapsResponse|\StructType\ReadSurveyorLocationsResponse|\StructType\ReadSurveyRisksResponse|\StructType\ReadSurveysForSurveyorResponse|\StructType\ReadSurveysReadyForDownloadResponse|\StructType\ReadWaterPipesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
