<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fetch ServiceType
 * @subpackage Services
 */
class Fetch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FetchSurveyJobsFromHub
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FetchSurveyJobsFromHub $parameters
     * @return \StructType\FetchSurveyJobsFromHubResponse|bool
     */
    public function FetchSurveyJobsFromHub(\StructType\FetchSurveyJobsFromHub $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FetchSurveyJobsFromHub($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FetchSurveyDiaryEntries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FetchSurveyDiaryEntries $parameters
     * @return \StructType\FetchSurveyDiaryEntriesResponse|bool
     */
    public function FetchSurveyDiaryEntries(\StructType\FetchSurveyDiaryEntries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FetchSurveyDiaryEntries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FetchSurveyAirTestEntries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FetchSurveyAirTestEntries $parameters
     * @return \StructType\FetchSurveyAirTestEntriesResponse|bool
     */
    public function FetchSurveyAirTestEntries(\StructType\FetchSurveyAirTestEntries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FetchSurveyAirTestEntries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FetchSurveyPhotoList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FetchSurveyPhotoList $parameters
     * @return \StructType\FetchSurveyPhotoListResponse|bool
     */
    public function FetchSurveyPhotoList(\StructType\FetchSurveyPhotoList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FetchSurveyPhotoList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FetchSurveyClearanceAreas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FetchSurveyClearanceAreas $parameters
     * @return \StructType\FetchSurveyClearanceAreasResponse|bool
     */
    public function FetchSurveyClearanceAreas(\StructType\FetchSurveyClearanceAreas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FetchSurveyClearanceAreas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FetchSurveyCertificates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FetchSurveyCertificates $parameters
     * @return \StructType\FetchSurveyCertificatesResponse|bool
     */
    public function FetchSurveyCertificates(\StructType\FetchSurveyCertificates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FetchSurveyCertificates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FetchSurveyAirTestEntriesResponse|\StructType\FetchSurveyCertificatesResponse|\StructType\FetchSurveyClearanceAreasResponse|\StructType\FetchSurveyDiaryEntriesResponse|\StructType\FetchSurveyJobsFromHubResponse|\StructType\FetchSurveyPhotoListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
