<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Download ServiceType
 * @subpackage Services
 */
class Download extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DownloadFileNoCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DownloadFileNoCheck $parameters
     * @return \StructType\DownloadFileNoCheckResponse|bool
     */
    public function DownloadFileNoCheck(\StructType\DownloadFileNoCheck $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DownloadFileNoCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DownloadFileChunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DownloadFileChunk $parameters
     * @return \StructType\DownloadFileChunkResponse|bool
     */
    public function DownloadFileChunk(\StructType\DownloadFileChunk $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DownloadFileChunk($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DownloadFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DownloadFile $parameters
     * @return \StructType\DownloadFileResponse|bool
     */
    public function DownloadFile(\StructType\DownloadFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DownloadFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DownloadFileChunkResponse|\StructType\DownloadFileNoCheckResponse|\StructType\DownloadFileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
