<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Archive ServiceType
 * @subpackage Services
 */
class Archive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ArchiveSurveyPhotos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ArchiveSurveyPhotos $parameters
     * @return \StructType\ArchiveSurveyPhotosResponse|bool
     */
    public function ArchiveSurveyPhotos(\StructType\ArchiveSurveyPhotos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ArchiveSurveyPhotos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ArchiveSurveyPhotosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
