<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSiparisler
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSiparisler $parameters
     * @return \StructType\GetSiparislerResponse|bool
     */
    public function GetSiparisler(\StructType\GetSiparisler $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSiparisler($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetYeniSiparisler
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetYeniSiparisler $parameters
     * @return \StructType\GetYeniSiparislerResponse|bool
     */
    public function GetYeniSiparisler(\StructType\GetYeniSiparisler $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetYeniSiparisler($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetYeniSiparislerByTarih
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetYeniSiparislerByTarih $parameters
     * @return \StructType\GetYeniSiparislerByTarihResponse|bool
     */
    public function GetYeniSiparislerByTarih(\StructType\GetYeniSiparislerByTarih $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetYeniSiparislerByTarih($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOnaylanmisSiparisler
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOnaylanmisSiparisler $parameters
     * @return \StructType\GetOnaylanmisSiparislerResponse|bool
     */
    public function GetOnaylanmisSiparisler(\StructType\GetOnaylanmisSiparisler $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOnaylanmisSiparisler($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetOnaylanmisSiparislerResponse|\StructType\GetSiparislerResponse|\StructType\GetYeniSiparislerByTarihResponse|\StructType\GetYeniSiparislerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
